/*
  XN[̕`揈
  Satofumi KAMIMURA
  $Id$
*/

#include "screenTask.h"
#include "parseArgs.h"
#include "deleteObjects.h"


ScreenTask::ScreenTask(WindowInterface* winObj, TTF_Draw* ttfObj)
  : win(winObj), ttf(ttfObj), mon(vmonitor::getObject()),
    main_back(NULL), under_back(NULL),
    ticks(0), isActivated(false), component_created(false),
    pause_next(mon->is_pause),
    pause_locked(false), msec_text(NULL), pos_text(NULL), pause_text(NULL),
    scroll_text(NULL), v_line(NULL), h_line_1(NULL), h_line_2(NULL),
    msec_label(NULL), pos_label(NULL), pause_label(NULL),
    main_view(NULL), user_view(NULL), mini_view(NULL),
    body_lines(NULL), debug_area(NULL), crd_cmb(NULL), scroll_checkbox(NULL),
    view_magnify((480.0 / 6000.0)), // 480[px][mm]ɕϊ邩
    view_center(VXV::Grid()),
    grid_center(VXV::Grid(0,0)), no_scroll(false), debug_area_clear(false),
    layer_index(ALL_LAYER +1),
    command_log(NULL) {

  body_original.push_back(VXV::Grid(-100, 150));
  body_original.push_back(VXV::Grid(-100, -150));
  body_original.push_back(VXV::Grid(70, -150));
  body_original.push_back(VXV::Grid(150, 0));
  body_original.push_back(VXV::Grid(70, 150));
  body_original.push_back(VXV::Grid(-100, 150));

  mini_body.push_back(VXV::Grid(-2, -2));
  mini_body.push_back(VXV::Grid(+2, -2));
  mini_body.push_back(VXV::Grid(+2, +2));
  mini_body.push_back(VXV::Grid(-2, +2));
  mini_body.push_back(VXV::Grid(-2, -2));

  int mini_x = win->w / MiniScrMagnify /2;
  int mini_y = (win->h - FrameHeight - LineWidth) / MiniScrMagnify /2;
  scr_rect.push_back(VXV::Grid(-mini_x, -mini_y));
  scr_rect.push_back(VXV::Grid(+mini_x, -mini_y));
  scr_rect.push_back(VXV::Grid(+mini_x, +mini_y));
  scr_rect.push_back(VXV::Grid(-mini_x, +mini_y));
  scr_rect.push_back(VXV::Grid(-mini_x, -mini_y));
}


ScreenTask::~ScreenTask(void) {
  isActivated = false;
  clear(ALL_LAYER);

  delete v_line;
  delete h_line_1;
  delete h_line_2;
  delete msec_text;
  delete pos_text;
  delete pause_text;
  delete scroll_text;
  delete under_back;
  delete main_back;
}


void  ScreenTask::init(void) {
  win->lock();

  // ʔwizu
  main_back = new FillSurface(Rect(win->w, win->h - FrameHeight), Gray3);
  win->add(new LabelComponent(main_back));

  // ̔wi
  under_back = new FillSurface(Rect(win->w, FrameHeight), Black);
  win->add((new LabelComponent(under_back))
	   ->setPosition(VXV::Grid(0, win->h - FrameHeight)));

  v_line = new FillSurface(Rect(win->w, LineWidth), White);
  win->add((new LabelComponent(v_line))
	   ->setPosition(VXV::Grid(0, win->h - FrameHeight)));
  h_line_1 = new FillSurface(Rect(LineWidth, FrameHeight), White);
  win->add((new LabelComponent(h_line_1))
	   ->setPosition(VXV::Grid(MiniMapWidth,
				   win->h - FrameHeight + LineWidth)));

  h_line_2 = new FillSurface(Rect(LineWidth, FrameHeight), White);
  win->add((new LabelComponent(h_line_2))
	   ->setPosition(VXV::Grid(MiniMapWidth + LineWidth + MiniInfoWidth,
				   win->h - FrameHeight + LineWidth)));

  // `R|[lgzu
  main_view = new ViewComponent(VXV::Rect(win->w, win->h - FrameHeight));
  user_view = new ViewComponent(VXV::Rect(win->w, win->h - FrameHeight));
  grid_center = VXV::Grid(win->w/2, (win->h - FrameHeight)/2);
  updateViewMagnify(view_magnify);
  win->add(main_view);
  win->add(user_view);

  // \g̕\p
  mini_view = new ViewComponent(VXV::Rect(MiniMapWidth, FrameHeight));
  mini_view->setPosition(VXV::Grid(0, win->h - FrameHeight + LineWidth));
  mini_view->setViewToRangeGrid(Grid(0,0), Grid(MiniMapWidth/2,FrameHeight/2));

  win->add(mini_view);

  // R}hp
  command_log =
    new ScrollAreaComponent(*ttf, VXV::Rect(MiniCmd_X,
					    win->h - FrameHeight + LineWidth,
					    win->w - MiniCmd_X, FrameHeight));
  win->add(command_log);

  // fobO\p
  debug_area =
    new ScrollAreaComponent(*ttf, VXV::Rect(win->w, win->h - FrameHeight));
  win->add(debug_area);

  // WnĨR{{bNX
  crd_cmb = new ComboBoxComponent(*ttf);

  // XN[w̃`FbN{bNX
  scroll_checkbox = new CheckBoxComponent(*ttf);

  win->unlock();
  ticks = mon->getTicks();
}


void ScreenTask::activate(void) {
  if (component_created) {
    return;
  }
  win->lock();

  // WnĨR{{bNX
  crd_cmb->add(" World ");
  crd_cmb->add(" GL ");
  crd_cmb->setFontSize(LogFontPx);
  crd_cmb->activate(true);
  crd_cmb->setNowIndex(mon->property->crd_index);
  crd_cmb->setPosition(Grid(win->w -16, 8), Right | Top);
  win->addInputComponent(crd_cmb, LogLevelFore);

  // XN[w̃`FbN{bNX
  scroll_text =
    new DrawSurface(ttf->createText("scroll with robot",
				    MiniFontPx, White, Gray4), true);
  scroll_checkbox->setLabel(new LabelComponent(scroll_text));
  scroll_checkbox->setLength(LogFontPx);
  scroll_checkbox->activate();
  scroll_checkbox->setNowChecked(true);
  scroll_checkbox->setPosition(VXV::Grid(8, win->h - FrameHeight +4));
  win->add(scroll_checkbox);

  // |[Y\p̃T[tFX
  pause_text =
    new DrawSurface(ttf->createText("Pause!", LogFontPx, Red, Gray4), true);

  win->unlock();
  component_created = true;
}


void ScreenTask::rotatePoint(VXV::Grid& point, double radian) {
  int px = (int)(point.x * cos(radian) + point.y * sin(radian));
  int py = (int)(point.x * -sin(radian) + point.y * cos(radian));
  point.x = px;
  point.y = py;
}


void ScreenTask::drawRobotBody(const VXV::Position& bodyPos,
			       const VXV::Direction& diff) {
  // ➑̂̃f[^_Q]
  std::deque<Grid> body = body_original;
  double direction = bodyPos.zt.to_rad() + diff.to_rad();
  for (std::deque<Grid>::iterator it = body.begin();
       it != body.end(); ++it) {
    rotatePoint(*it, -direction);
    it->x += bodyPos.x;
    it->y += bodyPos.y;
  }

  // `
  body_lines = new ContLineDraw(body, Green);
  main_view->add(body_lines);
}


void ScreenTask::drawRunGrid(const VXV::Position& offset) {
  VXV::Grid first, last;
  first.x = static_cast<int>(+view_center.x -(main_view->w/2/view_magnify));
  first.y = static_cast<int>(-view_center.y -(main_view->h/2/view_magnify));
  last.x = first.x + static_cast<int>(main_view->w / view_magnify);
  last.y = first.y + static_cast<int>(main_view->h / view_magnify);

  first -= offset;
  last -= offset;
  char grid_str[13];
  for (int x = (first.x / 1000) * 1000; x <= last.x; x += 1000) {
    main_view->add(new LineDraw(VXV::Grid(x, first.y) + offset,
				VXV::Grid(x, last.y) + offset, Gray7));
    sprintf(grid_str, "%d", x);
    main_view->add(new TextDraw(*ttf, grid_str,
				Grid(x +16, last.y) + offset,
				MiniFontPx, true, Gray14, Black, true));
  }
  for (int y = ((first.y / 1000) * 1000); y <= last.y; y += 1000) {
    main_view->add(new LineDraw(VXV::Grid(first.x, y) + offset,
				VXV::Grid(last.x, y) + offset, Gray7));
    sprintf(grid_str, "%d", y);
    main_view->add(new TextDraw(*ttf, grid_str,
				Grid(first.x, y -16) + offset,
				MiniFontPx, true, Gray14, Black, true));
  }
}


void ScreenTask::drawEnvironment(const VXV::Position& pos_diff,
				 const VXV::Position& diff) {

  VXV::Position rotate = pos_diff;
  rotate.zt = diff.zt;
  VXV::Matrix4D convert = VXV::createConvertMatrix(rotate);

  for (std::vector<CoordinateCtrl::polygon_t>::iterator it
	 = env_polygons.begin(); it != env_polygons.end(); ++it) {
    VXV::Grid3D pre_p = it->back();
    for (std::vector<VXV::Grid3D>::iterator p = it->begin();
	 p != it->end(); ++p) {
      VXV::Position3D rotate_p, rotate_pre_p;
      rotate_p.x = p->x + diff.x;
      rotate_p.y = p->y + diff.y;
      rotate_pre_p.x = pre_p.x + diff.x;
      rotate_pre_p.y = pre_p.y + diff.y;
      VXV::convert(rotate_p, rotate_p, convert);
      VXV::convert(rotate_pre_p, rotate_pre_p, convert);
      main_view->add(new LineDraw(rotate_p, rotate_pre_p, LightSalmon));

      pre_p = *p;
    }
  }
}


void ScreenTask::userInputHandle(UserInput::userInput_t& ui) {
  // L[́AzC[ɂʂ̊gAk
  if (ui.isPressed('9') || (ui.wheel_moved < 0)) {
    // k
    double set_magnify = view_magnify * 0.850;
    if (set_magnify > 0.03) {
      updateViewMagnify(set_magnify);
    }
  } else if (ui.isPressed('0') || (ui.wheel_moved > 0)) {
    // g
    double set_magnify = view_magnify * 1.150;
    if (set_magnify < 0.6) {
      updateViewMagnify(set_magnify);
    }
  }
}


void ScreenTask::drawRobotInfo(const VXV::Position& bodyPos) {
  if (msec_text) {
    win->del(msec_label, LogLevel);
    delete msec_text;
  }
  char msec_str[22];
  sprintf(msec_str, "%.01f [sec]", ticks / 1000.0);

  msec_text = new DrawSurface(ttf->createText(msec_str, LogFontPx,
					      White, Gray7), true);
  msec_label = new LabelComponent(msec_text);
  msec_label->setPosition(Grid(win->w -8, +8 +LogFontPx*2 +16), Right | Top);
  win->add(msec_label, LogLevel);

  // Ȉʒu̕`
  if (pos_text) {
    win->del(pos_label, LogLevel);
    delete pos_text;
  }
  char pos_str[47];
  sprintf(pos_str, "%0.3f [m], %0.3f [m], %3d [deg]",
	  bodyPos.x / 1000.0, bodyPos.y / 1000.0, bodyPos.zt.to_deg());
  pos_text = new DrawSurface(ttf->createText(pos_str, LogFontPx,
					     White, Gray7), true);
  pos_label = new LabelComponent(pos_text);
  pos_label->setPosition(Grid(win->w - 8, +16 +LogFontPx), Right | Top);
  win->add(pos_label, LogLevel);
}


void ScreenTask::handlePauseInput(UserInput::userInput_t& ui) {

  bool monitor_pause = mon->is_pause;
  if ((mon->mode == Monitor::Playback) && ui.isPressed(' ')) {
    pause_next = !monitor_pause;
  }
  if (pause_next != monitor_pause) {
    if (pause_next) {
      if (SDL_SemTryWait(mon->pause_sem) == 0) {
	mon->pause();
	pause_locked = true;

	pause_label = new LabelComponent(pause_text);
	pause_label->setPosition(VXV::Grid(win->w-10, win->h -FrameHeight -10),
				 Right | Bottom);
	win->add(pause_label, LogLevel);
      }
    } else {
      if (pause_locked) {
	mon->start();
	pause_locked = false;
	SDL_SemPost(mon->pause_sem);
	win->del(pause_label, LogLevel);
	pause_label = NULL;
      }
    }
  }
}


// k}bv̕`
void ScreenTask::drawMiniMap(VXV::Position& bodyPos) {
  mini_view->clear();
  mini_view->add(new ContLineDraw(mini_body, Green));
  mini_view->add(new ContLineDraw(scr_rect, White));
  VXV::Grid env_offset =
    VXV::Grid(static_cast<int>(-bodyPos.x /MiniScrMagnify * view_magnify),
	      static_cast<int>(-bodyPos.y /MiniScrMagnify * view_magnify));
  for (std::vector<CoordinateCtrl::polygon_t>::iterator it
	 = env_polygons.begin(); it != env_polygons.end(); ++it) {
    VXV::Grid3D pre_p = it->back();
    for (std::vector<VXV::Grid3D>::iterator p = it->begin();
	 p != it->end(); ++p) {
      if (VXV::length(*p - pre_p) > 600) {
	int mag = static_cast<int>(1.0 * MiniScrMagnify / view_magnify);
	mini_view->
	  add(new LineDraw(VXV::Grid(p->x/mag, p->y/mag) + env_offset,
			   VXV::Grid(pre_p.x/mag, pre_p.y/mag) + env_offset,
			   LightSalmon));
      }
      pre_p = *p;
    }
  }
}


void ScreenTask::handleCrdSelectInput(void) {
  if (crd_cmb->isDecided()) {
    mon->property->crd_index = crd_cmb->getNowIndex();
  }
}


void ScreenTask::send(void) {
  if (!isActivated) {
    return;
  }

  // L[͂ɂďI邽߂̏
  UserInput::userInput_t ui = UserInput::getInputed();
  if (ui.quit) {
    exit(1);
  }

  // \ʂ̑
  userInputHandle(ui);

  // ʂ̕`XV
  ticks = mon->getTicks();
  // !!!
  // !!! ȑOɍXVς݂

  // !!! Ƃ肠ACɂXV
  // !!! ͂APx`悳ĂAȉ̏(`pIuWFNg̐)
  // ɑJڂׂ

  win->lock();
  main_view->clear();

  // {bg𒆐Sɕ`悷ꍇ́Aʂ̕`撆SXVKv
  if (scroll_checkbox->getNowChecked()) {
    view_center = VXV::Grid(MonitorTask::bodyPosition.x,
			    -MonitorTask::bodyPosition.y);
  }
  VXV::Position diff;
  VXV::Position bodyPos;
  if (!no_scroll) {
    if (mon->property->crd_index == 0) { // World
      bodyPos = MonitorTask::bodyPosition;
    } else {			// GL
      bodyPos = MonitorTask::getRunPosition();
      diff = bodyPos - MonitorTask::bodyPosition;
#if 0
      diff = bodyPos - MonitorTask::bodyPosition;
      //fprintf(stderr, "diff: (%d, %d)\n", diff.x, diff.y);
      VXV::Matrix4D convert =
	VXV::createConvertMatrix(diff);

      VXV::Position3D point = bodyPos;
      VXV::convert(point, point, convert);
      bodyPos.x = point.x;
      bodyPos.y = point.y;
#endif
    }
  }
  updateView();

  drawRunGrid(MonitorTask::bodyPosition - bodyPos); // Obh̕`
  drawEnvironment(MonitorTask::bodyPosition - bodyPos, diff); // ̕`
  drawRobotBody(MonitorTask::bodyPosition, diff.zt); // {bg̕`
  drawRobotInfo(bodyPos);	// ticks, position ̕`
  handlePauseInput(ui);		// Xy[XL[ɂꎞ~
  drawObjects(); // [UR}h`
  drawMiniMap(MonitorTask::bodyPosition); // k}bv̕`
  handleCrdSelectInput();	// R{{bNXI̔f

  win->unlock();
}


void ScreenTask::show(void) {
  isActivated = true;
  activate();
}


void ScreenTask::hide(void) {
  isActivated = false;
}


void ScreenTask::updateView(void) {
  main_view->
    updateMagnify(view_magnify).setViewToRangeGrid(view_center, grid_center);

  user_view->
    updateMagnify(view_magnify).setViewToRangeGrid(view_center, grid_center);
}


void ScreenTask::updateViewMagnify(double magnify) {
  view_magnify = magnify;
  updateView();
}


void ScreenTask::setViewCenter(VXV::Grid& center) {
  view_center = center;
  updateView();
}


void ScreenTask::setEnvironment(const std::vector<CoordinateCtrl::polygon_t>&
				objs) {
  env_polygons = objs;
}


void ScreenTask::scrollWithRobot(bool on) {
  win->lock();
  scroll_checkbox->setNowChecked(on);
  win->unlock();
}
