/*
  pPbg̃^[Qbg
  Satofumi KAMIMURA
  $Id$
*/

#include "packetHandleTarget.h"
#include "structTables.h"
#include "nodeAccess.h"
#include "transferCtrl.h"
#include "tRunCtrl.h"


int packetRecvHandler(runCtrl_t *run) {
  enum {
    WaitStartByte,
    WaitHeaderRecv,
    WaitPacketRecv,
    RecvCompleted,
    InvalidPacket,

    RecvPacketSize = 512,
  };
  static int state = InvalidPacket;
  static unsigned char recv_buffer[RecvPacketSize];
  static int require_size = 0;
  static int filled = 0;
  static int type = 0;
  static int packet_length = 0;
  int n;

  // !!! ̊Jn return ܂ŁA1[msec] ̊荞݂֎~ׂȋC

  while (1) {
    if (state == InvalidPacket) {
      // M̏
      state = WaitStartByte;
      require_size = NODE_ACCESS_PACKET_HEADER_SIZE;
      recv_buffer[0] = 0x00;
      filled = removeInvalidPacketHeader((unsigned char*)recv_buffer, filled);
    }

    // M
    filled = removeInvalidPacketHeader(recv_buffer, filled);

    // V R}hւ̉
    if ((state == WaitStartByte) && (trans_size() >= 2)) {
      unsigned char command[2] = { '\0', '\0' };
      trans_copy(command, 2);
      if ((command[0] == 'V') &&
	  ((command[1] == '\n') || (command[1] == '\r'))) {
	// o[WԂ
	trans_recv(command, 2);
	trans_send((unsigned char *)V_COMMAND_REPLY, sizeof(V_COMMAND_REPLY));
      }
    }

    if (trans_size() < require_size) {
      return 0;
    }
    n = trans_recv(&recv_buffer[filled], require_size);
    filled += n;
    require_size -= n;

    filled = removeInvalidPacketHeader(recv_buffer, filled);

    if (state == WaitStartByte) {
      // X^[goCg҂
      if ((filled >= 3) && (checkFirstTag(recv_buffer) >= 0)) {
	state = WaitHeaderRecv;
      }
    }

    if (state == WaitHeaderRecv) {
      // wb_̃`FbNTmF
      if (checkHeaderFormat(recv_buffer) < 0) {
	state = InvalidPacket;
      } else {
	// wb_pPbg擾
	packet_length = getPacketLength(recv_buffer);
	require_size += packet_length - NODE_ACCESS_PACKET_HEADER_SIZE;
	state = WaitPacketRecv;
	type = getPacketType(recv_buffer);
      }
      continue;
    }

    if (state == WaitPacketRecv) {
      if (checkPacketFormat(recv_buffer, packet_length) < 0) {
	state = InvalidPacket;
      } else {
	state = RecvCompleted;
      }
    }

    if (state == RecvCompleted) {
      if (type == PACKET_WRITE_REQUEST) {
	// ݃pPbgւ̉
	writeFromPacketData(recv_buffer, (unsigned char *)run);
	packet_length =
	  createWriteResponsePacket(recv_buffer, (unsigned char *)run);

      } else if (type == PACKET_READ_REQUEST) {
	// ǂݏopPbgւ̉
	packet_length =
	  createReadResponsePacket(recv_buffer, (unsigned char *)run);
      } else {
	packet_length = 0;
      }
      trans_send(recv_buffer, packet_length);
      state = InvalidPacket;
      filled = 0;
      return 1;
    }
  }
}
