#ifndef ENVIRONMENT_CODEC_H
#define ENVIRONMENT_CODEC_H

/*!
  \file
  \brief ̃R[fbN
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "coordinateCtrl.h"
#include <deque>


/*!
  \brief ̓ǂݏoC^[tF[X`
*/
class EnvironmentCodecStream {

  /*!
    \brief PoCgǂݏo
  */
  virtual char get1ch(void) = 0;
  void ungetch(void);

public:
  enum { Fail = -1, Complete = 0, All = -1, };
  std::deque<char> buffer;	/*!< Oobt@ */

  virtual ~EnvironmentCodecStream(void) {}

  /*!
    \brief t@C open Ă邩

    \return open Ăꍇ true
  */
  virtual bool is_open(void) = 0;

  /*!
    \brief t@CI[ɓB
    
    \return Bꍇ true
  */
  virtual bool eof(void) = 0;

  /*!
    \brief Pǂݏo

    Xg[ 1 ǂݏoAobt@Ɋi[
  */
  void read1ch(void);

  /*!
    \brief obt@̃NA

    n  All w肷ƁASf[^폜

    \param n [i] 폜oCg
  */
  void clearBuffer(int n = All);
};


/*!
  \brief s̓ǂݏo
*/
extern int encodeLineFeedFromText(EnvironmentCodecStream& codec, int offset);

/*!
  \brief 󔒂̓ǂݏo
*/
extern int encodeSpaceFromText(EnvironmentCodecStream& codec, int offset,
			       int require_size = 0);

/*!
  \brief l̓ǂݏo
*/
extern int encodeNumericFromText(EnvironmentCodecStream& codec, int offset,
				 int* numeric);

/*!
  \brief _̓ǂݏo
*/
extern int encodeAPointFromText(EnvironmentCodecStream& codec, int offset,
				VXV::Grid3D& point);

/*!
  \brief _Q̓ǂݏo
*/
extern int encodePointsFromText(EnvironmentCodecStream& codec, int offset,
				std::vector<VXV::Grid3D>& points);

/*!
  \brief |S̓ǂݏo
*/
extern int encodePolygonFromText(EnvironmentCodecStream& codec, int offset,
				 std::vector<CoordinateCtrl::polygon_t>&
				 polygons);

#endif /* !ENVIRONMENT_CODEC_H */
