/*
  TTF T[tFX̍쐬
  Satofumi KAMIMURA
  $Id$
*/

#include "ttfDraw.h"
#include "detect_os.h"
#ifndef MSC
#include <unistd.h>
#else
#include <windows.h>
#include <direct.h>
#include <io.h>
#ifndef F_OK
#define F_OK 06
#endif
#endif
#include <stdlib.h>
#include <memory>


bool TTF_Draw::ttf_initialized = false;


void TTF_Draw::initTTF(void) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_TTF
  if (TTF_Init() < 0) {
    throw TTF_Exception(TTF_GetError());
  }
#endif
}


TTF_Draw::TTF_Draw(void) : fileName(NULL) {
}


TTF_Draw::~TTF_Draw(void) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_TTF
  for (std::map<int,TTF_Font*>::iterator it = fonts.begin();
       it != fonts.end(); ++it) {
    TTF_CloseFont(it->second);
    it->second = NULL;
  }
  free(fileName);
  TTF_Quit();
#endif
}


void TTF_Draw::createFontResource(int pxSize) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_TTF
#if 1
  if (pxSize <= 11) {
    fprintf(stderr, "font size is too small: %d\n", pxSize);
  }
#endif
  TTF_Font* font = TTF_OpenFont(fileName, pxSize);
  if (!font) {
    throw TTF_Exception(TTF_GetError());
  }
  fonts[pxSize] = font;
#endif
}


bool TTF_Draw::load(const char* file) {
  if (!ttf_initialized) {
    initTTF();
    ttf_initialized = true;
  }

  if (access(file, F_OK) < 0) {
    std::string message = std::string("TTF file is not found: ") + file;
    throw TTF_Exception(message.c_str());
  }

  int length = static_cast<int>(strlen(file) + 1);
  fileName = (char*)malloc(length);
  strncpy(fileName, file, length);

  return true;
}


SDL_Surface* TTF_Draw::createText(const unsigned short* text, int pxSize,
				  unsigned long color,
				  unsigned long background) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_TTF
  if (!fileName) {
    return NULL;
  }

  std::map<int,TTF_Font*>::iterator it = fonts.find(pxSize);
  if (it == fonts.end()) {
    createFontResource(pxSize);
  }

  // T[tFXԂ
  if (!text || text[0] == 0x00) {
    return NULL;
  }
  SDL_Color font_color = {
    static_cast<Uint8>((color >> 24) & 0xff),
    static_cast<Uint8>((color >> 16) & 0xff),
    static_cast<Uint8>((color >> 8) & 0xff), 0 };
  SDL_Color back_color = {
    static_cast<Uint8>((background >> 24) & 0xff),
    static_cast<Uint8>((background >> 16) & 0xff),
    static_cast<Uint8>((background >> 8) & 0xff), 0 };

  return TTF_RenderUNICODE_Shaded(fonts[pxSize], text, font_color, back_color);
#else
  return NULL;
#endif
}


SDL_Surface* TTF_Draw::createText(const char* text, int pxSize,
				  unsigned long color,
				  unsigned long background) {
  int length = static_cast<int>(strlen(text)) +1;
  unsigned short* p = new unsigned short [length];
  for (int i = 0; i < length; ++i) {
    p[i] = text[i];
  }
  SDL_Surface* draw = createText(static_cast<const unsigned short*>(p),
				 pxSize, color, background);
  delete [] p;
  return draw;
}
