#ifndef SDL_VIDEO_H
#define SDL_VIDEO_H

/*!
  \file
  \brief SDL(Video)̑
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "sdlBase.h"
#include "focusComponentInterface.h"
#include <SDL_thread.h>
#include <map>


/*!
  \brief SDL ̕`摀NX
*/
class SDL_Video : private SDL_Base {
  enum { FPS = 60 };
  static bool activated;
  SDL_Thread* thread;
  char* titleName;
  SDL_Surface* iconSurface;
  static Uint32 pre_ticks;
  static bool cursor_hide;
  static int wait_msec_max;
  static int wait_msec;

  typedef void (*call_t)(unsigned long);
  static call_t callback;
  static bool initialized;
  unsigned long active_ticks;
  static int input_index;

  static SDL_Surface* createScreen(void);
  static int updateThread(void* dummy);
  static void changeFocus(void);

protected:
  enum { ScreenWidth = 640, ScreenHeight = 480 };
  static bool fullscreen;	/*!< tXN[\ǂ */
  static bool fullscreen_trigger;
  static SDL_Surface *screen;	/*!< ʎ */
  static SDL_mutex *mutex;	/*!< bN */

  typedef std::list<ComponentInterface*> drawList; /*!< R|[lgXg */
  static std::map<char,drawList> draws;	/*!< `R|[lgǗ\[X */
  static std::vector<FocusComponentInterface*> inputList;

  /*!
    \brief `惋[vɌĂ΂֐̓o^
  */
  void registerEventHandler(call_t function);

  /*!
    \overload
  */
  static void lock(void);

  /*!
    \overload
  */
  static void unlock(void);

public:
  SDL_Video(void);
  virtual ~SDL_Video(void);

  /*!
    \overload

    \param on [i] \ꍇ true
  */
  void activate(bool on);

  /*!
    \overload

    \param title [i] ^Cg
    \param icon [i] \ACR
  */
  void setTitle(const char *title, const char *icon);

  /*!
    \overload

    \param waitMsec [i] w莞ԂJ[\ړȂƂɉB [msec]
  */
  void autoHideCursor(int waitMsec);

  /*!
    \brief T[tFX̕`

    \param surface [i] T[tFX
    \param size [i] TCY
    \param pos [i] ʒu
  */
  static void blitSurface(SDL_Surface* surface,
			  const VXV::Rect& size, const VXV::Grid& pos);

  /*!
    \brief `̓hԂ

    \param rect [i] ͈
    \param color [i] F
  */
  static void fillRect(const VXV::Rect& rect, unsigned long color);

  /*!
    \brief XN[ activate Ă̎ԂԂ

    \return XN[ activate Ă̎ [msec]
  */
  unsigned long getTicks(void);

  void delInputComponent(ComponentInterface* component);

  static void toggleFocus(void);
  void setFocus(FocusComponentInterface* component);
};

#endif /* !SDL_VIDEO_H */
