#ifndef MENU_COMPONENT_H
#define MENU_COMPONENT_H

/*!
  \file
  \brief j[\̃R|[lg
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "buttonComponent.h"
#include "labelComponent.h"
#include "focusComponentInterface.h"


/*!
  \brief j[\̃R|[lg
*/
class MenuComponent : public FocusComponentInterface {
  VXV::Rect button_offset;
  VXV::Rect icon_offset;
  //std::vector<ButtonComponent*> buttons;
  class item_t {
  public:
    item_t(void);
    ~item_t(void);
    ButtonComponent* button;
    bool select_enable;
  };
  std::vector<item_t*> items;
  LabelComponent* icon;
  bool activated;
  bool draw_hide;
  bool ctrl_disable;
  bool initialized;
  bool decided;
  bool no_default;
  int now_index;

  int code_down;
  int code_n;
  int code_up;
  int code_p;
  int code_first;
  int code_last;

public:
  MenuComponent(void);
  ~MenuComponent(void);
  bool draw(unsigned long ticks, const UserInput& ui);

  /*!
    \brief {^R|[lg̓o^

    \param button [i] {^R|[lg
  */
  void add(ButtonComponent* button);

  /*!
    \brief IpACR̓o^

    \param label [i] xR|[lg
  */
  void addIcon(LabelComponent* label);

  /*!
    \brief ڊԂ̃ItZbg

    \param offset [i] ڊԂ̃ItZbg
  */
  void setOffset(const VXV::Rect& offset);

  /*!
    \brief IpACR̃ItZbg

    \param offset [i] ڊԂ̃ItZbg
  */
  void setIconOffset(const VXV::Rect& offset);

  /*!
    \brief Iڂ̋w

    \param index [i] Iڂ̔ԍ

    \attention  
  */
  void setSelectedIndex(int index);

  /*!
    \brief `

    \param on [i] `悷Ƃ true
  */
  void activate(bool on);

  /*!
    \brief \E\̐ؑւ

    \param on [i] \ꍇ true
  */
  void hide(bool on);

  /*!
    \brief ͂̋E񋖉

    \param on [i] ͂񋖉ɂꍇ true
  */
  void disable(bool on);

  /*!
    \brief IԂǂ

    \param on [i] ɑIԂɂȂ悤ɂꍇ true
  */
  void defaultSelection(bool on);

  /*!
    \brief j[p̃L[oChɕύX

    \param set_default [i] c^j[̏ꍇ true
  */
  void changeKeySettings(bool set_default);

  /*!
    \brief ڂIĂ邩ǂ

    \return ڂIĂꍇ true
  */
  bool isDecided(void);

  /*!
    \brief ڂ̋I

    \param index [i] ڔԍ
  */
  void setNowIndex(int index);

  /*!
    \brief IĂ鍀ڔԍ̎擾

    \return IĂ鍀ڔԍ
  */
  int getNowIndex(void);

  void beginFocus(void);
  void endFocus(void);

  void setIndexActive(int index, bool on);
};

#endif /* !MENU_COMPONENT_H */
