#ifndef JOYSTICK_CTRL_H
#define JOYSTICK_CTRL_H

/*!
  \file
  \brief WCXeBbN̑NX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "sdlBase.h"
#include "typeUtils.h"
#include <SDL.h>
#include <deque>
#include <vector>


/*!
  \brief WCXeBbNNX
*/
class JoystickCtrl : private SDL_Base {
  friend class UserInput;

  static bool joystick_initialized;

  class EachJoystick {
  public:
    EachJoystick(void)
      : ptr(NULL), used(false) {}
    ~EachJoystick(void) {}
    SDL_Joystick* ptr;
    bool used;
    int num_axis;
    //int num_hats;
    //int num_balls;
    int num_buttons;
    std::vector<short> axis_value;
    std::deque<bool> buttons_value;
  };

  class JoystickResource {
  public:
    JoystickResource(void) : num_max(0), used_num(0) {}
    ~JoystickResource(void) {}
    int num_max;
    int used_num;
    std::vector<EachJoystick> js;
  };
  static JoystickResource jsr;
  int own_index;

  static void initJoystickSystem(void);
  static void init(void);
  static void joyAxisEventHandler(SDL_JoyAxisEvent& event);
  static void joyBallEventHandler(SDL_JoyBallEvent& event);
  static void joyHatEventHandler(SDL_JoyHatEvent& event);
  static void joyButtonEventHandler(SDL_JoyButtonEvent& event);
  JoystickCtrl(const JoystickCtrl& rhs);

public:
  enum { FreeIndex = -1 };
  JoystickCtrl(void);
  ~JoystickCtrl(void);

  /*!
    \brief G[bZ[WԂ

    \return G[bZ[W
  */
  const char* what(void);

  /*!
    \brief Rg[̏

    index  FreeIndex w肷邱ƂɂA󂢂ĂRg[ԍp

    \param index [i] VXeɊUꂽRg[ԍ
    \retval ɐꍇ true
  */
  bool activate(int index = FreeIndex);

  /*!
    \brief oWCXeBbNԂ

    \return oWCXeBbN
  */
  static int size(void);

  /*!
    \brief WCXeBbÑCxg

    ̊֐ĂԂƂŁAWCXeBbN񂪍XV

    \param event [i] SDL_event
  */
  static void joystickEventHandler(SDL_Event& event);

  /*!
    \brief Ă邩ǂ

    \return Ăꍇ true
  */
  bool isActivated(void) const;

  /*!
    \brief ̐Ԃ

    \return ̐
  */
  int getNumAxis(void) const;

  /*!
    \brief {^̐Ԃ

    \return {^̐
  */
  int getNumButtons(void) const;

  /*!
    \brief ̒l

    \param index [i] ̔ԍ
    \return ̒l
  */
  short getAxisValue(int index) const;

  /*!
    \brief {^̏ԂԂ

    \param index [i] {^̔ԍ
    \return {^ĂƂ true
  */
  bool getButtonValue(int index) const;
};

#endif /* !JOYSTICK_CTRL_H */
