#ifndef BUTTON_COMPONENT_H
#define BUTTON_COMPONENT_H

/*!
  \file
  \brief {^\̃R|[lg
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "componentInterface.h"
#include "surfaceInterface.h"
#include "colors.h"


/*!
  \brief {^\̃R|[lg
*/
class ButtonComponent : public ComponentInterface {
  int draw_mode;
  bool pressed;
  VXV::Rect judge_rect;
  SurfaceInterface* normal_surface;
  SurfaceInterface* focused_surface;
  SurfaceInterface* clicked_surface;
  int border_width;
  unsigned long border_color;
  bool focused;

public:
  enum { Auto, Normal, Focused, Clicked };

  /*!
    \brief 傫w̃RXgN^

    \param range [i] {^TCY
  */
  ButtonComponent(const VXV::Rect& range);

  /*!
    \brief T[tFXw̃RXgN^

    \param normal [i] {T[tFX
  */
  ButtonComponent(SurfaceInterface* normal);
  virtual ~ButtonComponent(void);
  bool draw(unsigned long ticks, const UserInput& ui);

  /*!
    \brief \T[tFX̋w

    \param mode [i] \T[tFX̎
  */
  void setDrawSurface(int mode);

  /*!
    \brief {T[tFXw

    \param normal [i] {T[tFX
  */
  void setNormalSurface(SurfaceInterface* normal);

  /*!
    \brief tH[JXT[tFXw

    \param focused [i] tH[JXT[tFX
  */
  void setFocusedSurface(SurfaceInterface* focused);

  /*!
    \brief NbNT[tFXw

    \param clicked [i] NbNT[tFX
  */
  void setClickedSurface(SurfaceInterface* clicked);
  //ButtonComponent& setBorder(int width, unsigned long color = Gray8);

  /*!
    \brief tH[JX邩

    \return tH[JX true
  */
  bool isFocused(void);

  /*!
    \brief ꂽ

    \return ꂽ true
  */
  bool isPressed(void);
};

#endif /* !BUTTON_COMPONENT_H */
