/*
  {^\̃R|[lg
  Satofumi KAMIMURA
  $Id$
*/

#include "buttonComponent.h"


ButtonComponent::ButtonComponent(const VXV::Rect& range)
  : draw_mode(Auto), pressed(false), judge_rect(range),
    normal_surface(NULL), focused_surface(NULL), clicked_surface(NULL),
    border_width(0), border_color(Gray8), focused(false) {
  // ȉ̋ʕ邩H
  w = judge_rect.w;
  h = judge_rect.h;
  position = VXV::Grid(0, 0);
}


ButtonComponent::ButtonComponent(SurfaceInterface* normal)
  : draw_mode(Auto), pressed(false),
    judge_rect(VXV::Rect(normal->w, normal->h)),
    normal_surface(normal), focused_surface(NULL), clicked_surface(NULL),
    border_width(0), border_color(Gray8), focused(false) {
  w = judge_rect.w;
  h = judge_rect.h;
  position = VXV::Grid(0, 0);
}


ButtonComponent::~ButtonComponent(void) {
}


bool ButtonComponent::draw(unsigned long ticks, const UserInput& ui) {

  SurfaceInterface* surface = normal_surface;
  // tH[JX̌o
  focused = false;
  int mx = ui.mpos.x;
  int my = ui.mpos.y;
  if ((mx >= position.x + judge_rect.x) &&
      (mx <= position.x + judge_rect.x + judge_rect.w) &&
      (my >= position.y + judge_rect.y) &&
      (my <= position.y + judge_rect.y + judge_rect.h)) {
    focused = true;
    // NbŇo
    if (ui.left_release) {
      pressed = true;
      if (clicked_surface) {
	// !!! T[tFX́ANbNꂽƂɕύXׂ
	surface = clicked_surface;
      }
    } else {
      if (focused_surface) {
	surface = focused_surface;
      }
    }
  }

  // \T[tFX̋ݒ
  if (draw_mode != Auto) {
    switch (draw_mode) {
    case Normal:
      surface = normal_surface;
      break;
    case Focused:
      if (focused_surface) {
	surface = focused_surface;
      }
      break;
    case Clicked:
      if (clicked_surface) {
	surface = clicked_surface;
      }
      break;
    }
  }

  // `w
  if (!surface) {
    return false;
  } else {
    surface->draw(VXV::Rect(surface->w, surface->h), position, ticks);
    // !!! g`
    return true;
  }
}


void ButtonComponent::setDrawSurface(int mode) {
  draw_mode = mode;
}


void ButtonComponent::setNormalSurface(SurfaceInterface* normal) {
  normal_surface = normal;
}


void ButtonComponent::setFocusedSurface(SurfaceInterface* focused) {
  focused_surface = focused;
}


void ButtonComponent::setClickedSurface(SurfaceInterface* clicked) {
  clicked_surface = clicked;
}


#if 0
// !!! 
ButtonComponent& ButtonComponent::setBorder(int width, unsigned long color) {
  border_width = width;
  border_color = color;
  return *this;
}
#endif


bool ButtonComponent::isFocused(void) {
  return focused;
}


bool ButtonComponent::isPressed(void) {
  bool ret = pressed;
  pressed = false;

  return ret;
}
