#ifndef URG_VIEW_DEMO_H
#define URG_VIEW_DEMO_H

/*
  URGView ̃fNX
  Satofumi KAMIMURA
  $Id$
*/

#include "guiApplicationInterface.h"
#include "mURGCtrl.h"
#include "propertyInfo.h"

#define Monitor


class URGViewDemo : public GUI_ApplicationInterface {
  enum {
    M_LINES = 10,
    FrameWidth = 100,
    LogLevel = 1,
  };
  enum {
    BackColor = Gray3,
    LineColor = Gray13,
  };
  DrawSurface* times_text;
  LabelComponent* times_label;
  FillSurface* back;
  FillSurface* frame;
  FillSurface* button_back;
  FillSurface* button_focused_back;
  DrawSurface* larger_text;
  MultiSurface* larger_normal;
  MultiSurface* larger_focused;
  DrawSurface* smaller_text;
  MultiSurface* smaller_normal;
  MultiSurface* smaller_focused;
  DrawSurface* quit_text;
  MultiSurface* quit_normal;
  MultiSurface* quit_focused;
  DrawSurface* m_surface[M_LINES];
  DrawSurface* pause_text;
#ifdef Monitor
  mURGCtrl* urg;
#else
  URGCtrl* urg;
#endif

  ViewComponent* view;
  ViewComponent* sensed;
  LabelComponent* m_label[M_LINES];
  ButtonComponent* quit_button;
  ButtonComponent* larger_button;
  ButtonComponent* smaller_button;

  double base_magnify;
  int int_magnify;
  double magnify_max;
  double magnify_min;
  Grid view_offset;

  std::string ttf_path;
  class URGViewProperty : public PropertyInfo {
    void evaluate(void);
  public:
    std::string ttf_file;
  };
  URGViewProperty& property;

  void updateMagnify(double magnify);


public:
  URGViewDemo(void);
  ~URGViewDemo(void);

  int Initialize(int argc, char *argv[]);
  int MainLoop(void);
};

#endif /* !URG_VIEW_DEMO_H */
