#ifndef URG_MANUAL_CAPTURE_H
#define URG_MANUAL_CAPTURE_H

/*!
  \file
  \brief URG ̊{

  \author Satofumi KAMIMURA

  $Id$
*/

#include "urgCapture.h"
#include "connectionDevice.h"
#include <vector>


/*!
  \brief URG ̊{
*/
class URGManualCapture : public URGCapture {
  friend class URGCtrlTest;

  enum {
    DefaultTimeout = 240,
    BufferSize = 3072,
    //OneDataByte = 2,
    OneDataByte = 3,
  };
  ConnectionDevice* con;
  std::string error_message;
  long capture_times;
  int oneData_byte;
  char recv_buffer[BufferSize];
  int Timeout;
  bool isLF(char ch);
  unsigned char encode6bit(char ch);
  int adjustIndex(int index, int add);
  int recvScanData(long data[], int first, int last, int group,
		   const char* send_str, URGInterface::urgParams_t& params,
		   unsigned long* raw_ticks);

protected:
  bool laser_on;
  int remain_byte;
  char remain_data[3];
  bool enableTimestamp;		/*!< ^CX^vp\ */
  long decode(const char* data, int data_byte);

  std::vector<long> recv_data;
  int recvCaptureData(long* data, size_t max_size, unsigned long* timestamp,
		      URGInterface::urgParams_t& params);
  int readLine(char *buffer, int timeout);
  int addRecvData(const char buffer[]);

public:
  URGManualCapture(void);
  virtual ~URGManualCapture(void);

  const char* what(void);
  int connect(const char* device, long baudrate);
  int connectSocket(const char* host, short port);
  void disconnect(void);
  bool isConnected(void);
  void set_recvTimeout(int timeout);
  void setTimestampMode(bool withTimestamp);
  virtual int capture(long length[],
		      int first_index, int last_index, int group,
		      URGInterface::urgParams_t& params,
		      unsigned long* raw_timestamp = NULL);
  int getCaptureTimes(void);
  int send(const char* data, int size);
  int recv(char* data, int maxsize, long timeout);
  int recv_line(char* data, int maxsize, long timeout);
  int laser(bool on);
};

#endif /* !URG_MANUAL_CAPTURE_H */
