#ifndef RUN_INTERFACE_H
#define RUN_INTERFACE_H

/*!
  \file
  \brief sR}h̃C^[tF[X`

  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "objCoordinateCtrl.h"
#include "coordinateTypes.h"


/*!
  \brief sR}h̃C^[tF[X`
*/
class RunInterface {
public:
  virtual ~RunInterface(void) {}

  /*!
    \brief G[ԂԂ
  */
  virtual const char* what(void) = 0;

  /*!
    \brief |[gw̐ڑs

    ʐMɎgp|[gvOŎw肷ꍇɗp

    \param device [i] ڑfoCX
    \param baudrate [i] ڑ{[[g
    
    \retval 0 I
    \retval ߂l < 0 G[

    gp
    \code
    RunCtrl run;
    if (run.connect("/dev/ttyS0") < 0) {
      printf("RunCtrl::connect: %s\n", run.what());
      exit(1);
    }
    \endcode
  */
  virtual int connect(const char* device, long baudrate) = 0;

  /*!
    \brief ̓e]Đڑs

    ́Aargv[1] ]

    vOʐMɎgp|[g肷ꍇɗp

    \param argc [i] ̌
    \param argv [i] i[z

    gp
    \code
    include <runCtrl.h>

    int main(int argc, char *argv[]) {
      try {
        RunCtrl run;
	if (run.connect(argc, argv) < 0) {
	  printf("RunCtrl::connect: %s\n", run.what());
	  exit(1);
	}
	...

      } chatch (std::exception& e) {
        printf("exception: %s\n", e.what());
      }
      return 0;
    }
    \endcode
  */
  virtual int connect(int argc, char *argv[]) = 0;

  /*!
    \brief |[gƂ̐ڑؒf

    |[gƂ̐ڑؒf

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);
    ...
    run.disconnect();
    \endcode
  */
  virtual void disconnect(void) = 0;

  /*!
    \brief sԂ̑Ҕ

    sp[^̒lAyђOsR}hĔs邽߂̏Ҕ
  */
  virtual void push_runState(void) = 0;

  /*!
    \brief sԂ̕A

    ҔĂsԂ𕜋ABɂȂ݂sp[^ݒAyђOsR}hĔs邽߂̏񂪑ҔĂ̂ɒu
  */
  virtual void pop_runState(void) = 0;

  /*!
    \brief W[Wnɂ鐄莩ȈʒuԂ

    {bg̐莩ȈʒuԂBŕԂĺAWn̐ݒɈˑȂ

    \return {bg̐莩Ȉʒu

    \image html crd_position.png sW[ǗĂ郍{bgʒu
  */
  virtual VXV::Position3D getLocalPosition(void) = 0;

  /*!
    \brief 莩ȈʒuԂ

    wWn݂{bgʒuԂ

    \param crd [i] Wn
    
    \return wWnɂ郍{bg̐莩Ȉʒu

    \image html crd_position.png wWnɂ郍{bgʒu

    dl
    \code
    #include <runCtrl.h>
    #include <typePrint.h>
    
    int main(int argc, argv) {
      RunCtrl run;
      run.connect(argc, argv);

      std::cout << run.getRunPosition() << std::endl;
      ...
    \endcode
  */
  virtual VXV::Position getRunPosition(const CoordinateCtrl* crd) = 0;

  /*!
    \brief 莩Ȉʒu̍XV
    
    {bgʒuwWn̎wʒuɂ悤ɕύX

    \param position [i] C̈ʒu
    \param crd [i] Wn

    \image html new_position.png {bg̊ǗʒuC
  */
  virtual void adjustRunPosition(const VXV::Position& position,
				 const CoordinateCtrl* crd) = 0;

  /*!
    \brief WnύX̉eݒ

    Wn̕ύXAړ̃R}hɉe^邩ǂݒ肷B

    \param on [i] Wn̕ύXšoHɉe^ꍇ true

    gp
    \code
    run.followLine(VXV::Position(0, 0, deg(0)));
    VXV::Delay(1000);

    // {bgʒu (0, 0, 90[deg]) ƂɍĐݒ肷
    run.adjustRunPosition(VXV::Position(0, 0, deg(90)));

    // ȑO̕] run.coordinateUpdateDetect(false) ł΁A
    // {bg̈ړoH͕ύXȂ

    // ȑO̕] run.coordinateUpdateDetect(true) ł΁A
    // {bg̈ړoH͐VWn (0, 0, deg(0)) ̒
    // Ǐ]悤ɍXV
    \endcode

    \image html crd_update_detect.png ݒɂ鑖soḦႢ
  */
  virtual void coordinateUpdateDetect(bool on) = 0;

  /*!
    \brief T[{

    T[{Ԃݒ肷

    \param on [i] T[{ԂɂƂ true / T[{t[ɂƂ false

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);
    ...

    run.servoCtrl(true);	// T[{
    ...

    run.servoCtrl(false);	// T[{t[ɂ
    \endcode
  */
  virtual void servoCtrl(bool on) = 0;

  /*!
    \brief ړ~
  
    Wxőx 0 ܂Ō

    \image html move_stop.png R}hsA΂炭Ē~

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // RbOiāA~
    run.followLine(VXV::Position(0, 0, deg(0)), &run.FS);
    VXV::Delay(5000);
    run.stop();
    \endcode
  */
  virtual void stop(void) = 0;

  /*!
    \brief Ǐ]

    Wn̎w肳ꂽ_ʂwpx̒֒Ǐ]s
    
    \image html move_followLine.png w蒼oHւ̒Ǐ]

    \param position [i] Ǐ]w
    \param crd [i] Wn

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // Wn̓_ (0, 0) ʂA45x̌̒oHɑ΂ĒǏ]s
    run.followLine(VXV::Position(0, 0, deg(45)));
    \endcode
  */
  virtual void followLine(const VXV::Position& position,
			  const CoordinateCtrl* crd) = 0;

  /*!
    \brief ~ʒǏ]

    Wn̎w肳ꂽ_𒆐SƂ锼ả~֒Ǐ]s

    \image html move_followCircle.png w~ʌoHւ̒Ǐ]

    \param center [i] Ǐ]~ʂ̒Sʒu
    \param radius [i] Ǐ]~̔a [mm] (radius > 0  CW, radius < 0  CCW)
    \param crd [i] Wn

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // S (500, 500) Ŕa 500 [mm] ̉~̋OՂɎvŒǏ]s
    run.followLine(VXV::Grid(500, 500), 500);
    \endcode
  */
  virtual void followCircle(const VXV::Grid& center, int radius,
			    const CoordinateCtrl* crd) = 0;

  /*!
    \brief ڐw̉~ʂɒǏ]

    w蒼ɐڂ锼a r ̉~ʂɒǏ]

    \image html move_followCircleOnTangent.png w~ʌoHւ̒Ǐ]

    \param position [i] ړ_w
    \param radius [i] Ǐ]~̔a (radius > 0  CW, radius < 0  CCW)
    \param crd [i] Wn

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // Wn (1000, 0) ̓_ɐڂ~̋OՂɎvŒǏ]s
    // (ʓIɁA~̒S (1000, -500) ƂȂ)
    run.followCircleOnTangent(VXV::Position(1000, 0, deg(0)), 1000);
    \endcode
  */
  virtual void followCircleOnTangent(const VXV::Position& position, int radius,
				     const CoordinateCtrl* crd) = 0;

  /*!
    \brief ~̎w

    w蒼ɐȒŒ~

    \image html move_stopToLine.png w蒼ɐȒŒ~

    \param position [i] w蒼w
    \param crd [i] Wn

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // Wn (1000, 1000) Ō 45xɐȒŒ~
    run.stopToLine(Posiiton(1000, 1000, deg(45)));
    \endcode
  */
  virtual void stopToLine(const VXV::Position& position,
			  const CoordinateCtrl* crd) = 0;

  /*!
    \brief wpxɉ]

    WnŎw肳ꂽpx̕悤ɓ]񂷂
    
    \image html move_rotateToDirection.png Wn̎wpx֒Ǐ]

    \param direction [i] Ǐ]px
    \param crd [i] Wn

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // 145x̕
    run.rotateToDirection(deg(145));
    \endcode
  */
  virtual void rotateToDirection(const VXV::Direction& direction,
				 const CoordinateCtrl* crd) = 0;

  /*!
    \brief wpx]

    w肳ꂽpxΓIɓ]񂷂

    \image html move_rotateAngle.png wpx]񂷂

    \param direction [i] ]px

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // vɂP]񂷂
    run.rotateAngle(deg(-360));
    \endcode
  */
  virtual void rotateAngle(const VXV::Direction& direction) = 0;

  /*!
    \brief A]

    w葬xŉ]

    \image html move_spin.png w葬xœ]񂵑

    \param velocity [i] ]񑬓x

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // 30[deg/sec]Ŏvɉ]
    run.spin(deg(-30));
    \endcode
  */
  virtual void spin(const VXV::Direction& velocity) = 0;

  /*!
    \brief ߋ̈ړR}hĔs

    OɔsړR}hēxsBs̍ۂɂ́AߋɃR}h𔭍sƂ̍Wn݂̂mF邽߂ɁÃR}h𔭍sƂ̍Wnw肷KvB

    \param crd [i] Wn

    gp
    \code
    // ړR}h̔s
    run.followLine(VXV::Position(0, 0, deg(0)));
    VXV::Delay(1000);

    // QꍇȂǁAOɔsړR}hҔĂ~
    run.push_runState();
    run.stop();
    VXV::Delay(1000);

    // ړR}h̍Ĕs
    run.pop_runState();
    run.lastMoveCommand(&run);
    \endcode
  */
  virtual void lastMoveCommand(const CoordinateCtrl* crd) = 0;


  /*!
    \brief ړ̐Ԃ肵Ă邩Ԃ

    Ǐ]ł΁A𑖍sĂƂA~R}hł΁A~ĂƂ true ԂBݎs̃R}h̐ڕWBĂ邩ǂԂ

    \retval true 
    \retval false ɂނĐ䒆

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ړI̕ւ̉]x[߂ɂȂÄړR}h𔭍s
    run.rotateToDirection(deg(90));
    while (!run.isStable()) {
      VXV::Delay(100);
    }
    run.followLine(VXV::Position(0, 0, deg(90)));
    \endcode
  */
  virtual bool isStable(void) = 0;

  /*!
    \param wʒuƐ莩ȈʒuƂ̋Ԃ
    
    莩ȈʒuƁAwWn̓_Ƃ̋Ԃ

    \image html judge_lengthToGrid.png 

    \param grid [i] wʒu
    \param crd [i] Wn

    \return  [mm]

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ړȂAW (1000, 1000) Ƃ̋\
    VXV::Grid grid(1000, 1000);

    run.followLine(VXV::Position(0, 0, deg(0)));
    while (1) {
      printf("length: %d\n", run.getLengthToGrid(grid));
      VXV::Delay(1000);
    }
    \endcode
  */
  virtual int getLengthToGrid(const VXV::Grid& grid,
			      const CoordinateCtrl* crd) = 0;

  /*!
    \brief wʒuƐ莩ȈʒuƂ̋Ԃ

    \param grid [i] wʒu
    \param crd [i] Wn

    \return  [mm]

    \attention getLengthToGrid p邱
  */
  virtual int getLengthToBody(const VXV::Grid& grid,
			      const CoordinateCtrl* crd) = 0;

  /*!
    \brief w蒼ɐȒƐ莩ȈʒuƂ̋Ԃ
    
    ԂĺAw蒼̌̕ɎȈʒu΋Aw蒼̌Ƃ͔ΑɎȈʒu΁AɕtlԂ

    \image html judge_lengthToLine.png Ƃ̋

    \param line [i] w蒼
    \param crd [i] Wn

    \return  [mm]

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ̈ړ(1000, 0, deg(90))ɋ߂Â炻̒ւ̒Ǐ]R}h𔭍s
    VXV::Position next_line(1000, 0, deg(90));
    run.followLine(VXV::Position(0, 0, deg(0));
    while (run.getLengthToLine(next_line) < -300) {
      VXV::Delay(100);
    }
    run.followLine(next_line);
    \endcode
  */
  virtual int getLengthToLine(const VXV::Position& line,
			      const CoordinateCtrl* crd) = 0;

  /*!
    \brief wpxƂ̍Ԃ
    
    WnŎw肳ꂽpxƐ莩ȈʒůpxƂ̍Ԃ

    \image html judge_angleToDirection.png px

    \param t [i] wpx
    \param crd [i] Wn

    \return px
  */
  virtual VXV::Direction getAngleToDirection(const VXV::Direction& t,
					     const CoordinateCtrl* crd) = 0;

  /*!
    \brief wixƂ̍Ԃ
    
    w肵xƌ݂̈ړxƂ̍Ԃ

    \image html judge_straightVelDiff.png x

    \param mm_vel [i] wix [mm/sec]
    
    \return ix̍ [mm/sec]
  */
  virtual int getStraightVelDiff(int mm_vel) = 0;

  /*!
    \brief w]xƂ̍Ԃ

    w]xƌ݂̉]xƂ̍Ԃ
    
    \image html judge_rotateVelDiff.png ]x

    \param t [i] w]x [direction/sec]

    \return ]x̍ [direction/sec]
  */
  virtual VXV::Direction getRotateVelDiff(const VXV::Direction& t) = 0;

  /*!
    \brief ڕWixݒ

    Ǐ]~ʒǏ]ȂǂŎ悤Ƃixݒ肷

    \param mm_sec [i] ڕWix [mm]

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ix 100[mm/sec]ɐݒ肷
    run.setStraightRefVel(100);
    run.followLine(VXV::Position(0, 0, deg(0))); // ړx 100[mm/sec]
    \endcode
  */
  virtual void setStraightRefVel(int mm_sec) = 0;

  /*!
    \brief ڕWixݒ

    ix̐ɗppxݒ肷

    \param mm_acc [i] ڕWx [mm]

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ỉx 100[mm/sec^2]ɐݒ肷
    run.setStraightRefAcc(100);

    // ړ̉x 100[mm/sec^2]
    run.followLine(VXV::Position(0, 0, deg(0)));
    \endcode
  */
  virtual void setStraightRefAcc(int mm_acc) = 0;

  /*!
    \brief ڕWpxݒ

    ڕWpxւ̒Ǐ]R}h]R}h̍ۂɗp]xݒ肷

    \param rotate_vel [i] ڕWpx [VXV::Direction]

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ]px 90[deg/sec]ɐݒ肷
    run.setRotateRefVel(deg(90));
    run.rotateAngle(deg(360));	// ]px 90[deg/sec]
    \endcode
  */
  virtual void setRotateRefVel(const VXV::Direction& rotate_vel) = 0;

  /*!
    \brief ڕWpxݒ

    ]̍ۂɗppxݒ肷

    \param rotate_acc [i] ڕWpx [VXV::Direction]

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ]px 90[deg/sec^2]ɐݒ肷
    run.setRotateRefAcc(deg(90));
    run.rotateAngle(deg(360));	// ]px 90[deg/sec^2]
    \endcode
  */
  virtual void setRotateRefAcc(const VXV::Direction& rotate_acc) = 0;

  /*!
    \brief Ǐ]̋ȗݒ

    莩ȈʒuڕWoHɂȂꍇAŐݒ肳ȗۂȂڕWoHɒǏ]悤ƂB]āAr قǋ}ɓ]񂵂ČoHǏ]sAr 傫΂Ȃ炩ɖڕWoHɒǏ]

    \image html follow_curve.png

    \param mm [i] Ǐ]̋ȗ [mm]

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // Ǐ]̋ȗ傫߂ɐݒ
    run.setCurveRadius(600);
    \endcode
  */
  virtual void setCurveRadius(int mm) = 0;

  /*!
    \brief Ǐ]̋ȗ̐ݒ擾

    ݂̐ݒ肳ĂǏ]̋ȗ̒l擾

    \retval Ǐ]ȗ̐ݒl

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ݂̋ȗݒ擾ĕ\
    printf("curve radius: %d\n", run.getCurveRadius());
    \endcode
  */
  virtual int getCurveRadius(void) = 0;

  /*!
    \brief ix̎擾

    ix擾

    \retval ix [mm/sec]

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ړx\
    run.followLine(Position(0, 0, deg(0)));
    while (1) {
      printf("vel: %d\n", run.getStraightVel());
      VXV::Delay(100);
    }
    \endcode
  */
  virtual int getStraightVel(void) = 0;

  /*!
    \brief ]x̎擾

    ]x擾

    \retval ]px [VXV::Direction]

    gp
    \code
    RunCtrl run;
    run.connect(argc, argv);

    // ړx\
    run.spin(deg(90));
    while (1) {
      printf("vel: %d\n", run.getRotateVel().to_deg());
      VXV::Delay(100);
    }
    \endcode
  */
  virtual VXV::Direction getRotateVel(void) = 0;
};

#endif /* !RUN_INTERFACE_H */
