/*
  p[^
  Satofumi KAMIMURA
  $Id$
*/
#define C_RUNCTRL_SOURCE

#include "parameter_ctrl.h"
#include "commandCtrl.h"
#include <stdio.h>


static runParams_t *Param = NULL;


/*!
  \brief p[^̏

  \param runParam [o] \

  \attention [UĂԕKv͂Ȃ
*/
void run_initRunParam(runParams_t *params) {
  Param = params;
  Param->straight_ref_vel = STRAIGHT_MM_VEL;
  Param->straight_ref_acc = STRAIGHT_MM_ACC;
  Param->rotate_ref_vel = ROTATE_DIV16_VEL;
  Param->rotate_ref_acc = ROTATE_DIV16_ACC;
  Param->follow_r = FOLLOW_RADIUS_MM;
}


/*!
  \brief ڕWixݒ

  \param mm_vel [i] ڕWix [mm/sec]
  \retval 0 I
  \retval ߂l < 0 G[
*/
int run_setStraightVel(int mm_vel) {
  Param->straight_ref_vel = mm_vel;
  if (sendStraightRef(mm_vel, Param->straight_ref_acc) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief ixݒ

  \param mm_acc [i] x {mm/sec^2]
  \retval 0 I
  \retval ߂l < 0 G[
*/
int run_setStraightAcc(int mm_acc) {
  Param->straight_ref_acc = mm_acc;
  if (sendStraightRef(Param->straight_ref_vel, mm_acc) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief ڕW]xݒ

  \param div16_vel [i] ڕWpx [div16/sec]
  \retval 0 I
  \retval ߂l < 0 G[
*/
int run_setRotateVel(int div16_vel) {
  Param->rotate_ref_vel = div16_vel;
  if (sendRotateRef(div16_vel, Param->rotate_ref_acc) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief ]xݒ

  \param div16_acc [i] ]x {div16/sec^2]
  \retval 0 I
  \retval ߂l < 0 G[
*/
int run_setRotateAcc(int div16_acc) {
  Param->rotate_ref_acc = div16_acc;
  if (sendRotateRef(Param->rotate_ref_vel, div16_acc) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief oHǏ]ɑQߎۂ̋ȗw

  \param radius_mm [i] a [mm]
  \retval 0 I
  \retval ߂l < 0 G[
*/
int run_setCurveRadius(int radius_mm) {
  Param->follow_r = radius_mm;
  if (sendCurveRadius(radius_mm) < 0) {
    return -1;
  }
  return 0;
}


/*!
  \brief ix擾

  \param *mm_vel [o] ix [mm/sec]
  \retval 0 I
  \retval ߂l < 0 G[
*/
int run_getStraightVel(int *mm_vel) {
  return recvStraightVel(mm_vel);
}


/*!
  \brief ix擾

  \param *div16_vel [o] ]x [div16/sec]
  \retval 0 I
  \retval ߂l < 0 G[
*/
int run_getRotateVel(int *div16_vel) {
  return recvRotateVel(div16_vel);
}


/*!
  \brief Ԃ肵Ă邩

  \retval 0 
  \retval -1 s
*/
int run_is_stable(void) {
  int isStable;
  int ret_value = recvStableValue(&isStable);
  if (ret_value < 0) {
    return ret_value;
  }
  return isStable;
}
