/*
  j^p̕MC^[tF[X
  Satofumi KAMIMURA
  $Id$
*/

#include "multiConnectionDevice.h"


MultiConnectionDevice::MultiConnectionDevice(void) : sub_con(NULL) {
}


MultiConnectionDevice::~MultiConnectionDevice(void) {
  delete sub_con;
}


void MultiConnectionDevice::raw_disconnect(void) {
  SerialDevice::raw_disconnect();
  delete sub_con;
  sub_con = NULL;
}


int MultiConnectionDevice::raw_send(const char* data, int len) {
  int ret_value =  SerialDevice::raw_send(data, len);
  if (sub_con) {
    sub_con->send(data, len);
    sub_con->flush();
  }
  return ret_value;
}


int MultiConnectionDevice::subConnect(const char* host, long port) {
  delete sub_con;

  sub_con = new TcpipDevice();
  return sub_con->connect(host, port);
}
