#ifndef WINDOW_INTERFACE_H
#define WINDOW_INTERFACE_H

/*!
  \file
  \brief Window ̃C^[tF[X`
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "focusComponentInterface.h"
#include <limits.h>


/*!
  \brief Window ̃C^[tF[X
*/
class WindowInterface {
public:
  enum { All = -1 };
  int w;			/*!<  */
  int h;			/*!<  */

  virtual ~WindowInterface(void) {}

  /*!
    \brief ^Cgw

    \param title [i] ^Cg
    \param icon [i] \ACR

    \attention ̃\bh́Aactivate OɌĂ΂Kv
  */
  virtual void setTitle(const char *title, const char *icon = NULL) = 0;

  /*!
    \brief ŃJ[\Bǂ

    \param waitMsec [i] w莞ԂJ[\ړȂƂɉB [msec]

    \attention bNĂԂŌĂ΂Ȃ΂ȂȂ
  */
  virtual void autoHideCursor(int waitMsec = INT_MAX) = 0;

  /*!
    \brief \E\̐ؑւ

    \param on [i] \ꍇ true
  */
  virtual void activate(bool on) = 0;

  /*!
    \brief XN[ activate Ă̎ԂԂ

    \return XN[ activate Ă̎ [msec]
  */
  virtual unsigned long getTicks(void) = 0;

  /*!
    \brief ҋ@

    \param ticks [i] ҋ@ [msec]
  */
  virtual void delay(unsigned long ticks) = 0;

  /*!
    \brief XN[̃bN
  */
  virtual void lock(void) = 0;

  /*!
    \brief XN[̃AbN
  */
  virtual void unlock(void) = 0;

  virtual void addInputComponent(FocusComponentInterface* component,
				 char depth = 0) = 0;

  /*!
    \brief R|[lgC[ɓo^

    \param component [i] R|[lg
    \param depth [i] C[
  */
  virtual void add(ComponentInterface* component, char depth = 0) = 0;

  /*!
    \brief R|[lgC[폜

    \param component [i] R|[lg
    \param depth [i] C[
  */
  virtual void del(ComponentInterface* component, char depth = 0) = 0;

  /*!
    \brief C[̃NA

    \param depth [i] C[
  */
  virtual void clear(char depth = All) = 0;

  virtual void toggleFocus(void) = 0;
  virtual void setFocus(FocusComponentInterface* component) = 0;

  virtual void setFullscreen(bool on) = 0;
  virtual bool getNowFullscreen(void) = 0;
};

#endif /* !WINDOW_INTERFACE_H */
