#ifndef VIEW_COMPONENT_H
#define VIEW_COMPONENT_H

/*!
  \file
  \brief r[R|[lg
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "basicDraw.h"


/*!
  \brief r[R|[lg

  \todo DrawAreaComponent ÃNX폜
*/
class ViewComponent : public ComponentInterface {
  std::list<BasicDrawInterface*> objs;
  double draw_magnify;
  VXV::Rect draw_range;
  ViewComponent(void);

public:
  /*!
    \brief TCYw̃RXgN^

    \param range [i] \TCY
    \param magnify [i] \{
  */
  ViewComponent(const VXV::Rect& range, double magnify = 1.0f);
  virtual ~ViewComponent(void);
  bool draw(unsigned long ticks, const UserInput& ui);

  /*!
    \brief \{̕ύX

    \param magnify \{
  */
  ViewComponent& updateMagnify(double magnify);

  /*!
    \brief \͈͂̐ݒ

    \param view_grid [i] \ʒu
    \param range_grid [i] \͈
  */
  ViewComponent& setViewToRangeGrid(const VXV::Grid& view_grid,
				    const VXV::Grid& range_grid);

  /*!
    \brief ǂ̈ʒu\邩̕ύX

    \param pos [i] \ʒu
  */
  ViewComponent& updateViewPosition(const VXV::Grid& pos);

  /*!
    \brief \͈͂̍XV

    \param size [i] \͈
  */
  ViewComponent& updateViewSize(const VXV::Rect& size);

  /*!
    \brief o^ẽNA
  */
  ViewComponent& clear(void);

  /*!
    \brief `e̓o^

    \param obj [i] `R|[lg
  */
  ViewComponent& add(BasicDrawInterface* obj);

  /*!
    \brief `e̍폜

    \param obj [i] `R|[lg
  */
  void del(BasicDrawInterface* obj);
};

#endif /* !VIEW_COMPONENT_H */
