#ifndef USER_INPUT_H
#define USER_INPUT_H

/*!
  \file
  \brief [U͏̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "typeUtils.h"
#include <SDL.h>
#include <vector>
#include <list>


/*!
  \brief [U͏̊Ǘ
*/
class UserInput {
  friend class SDL_Video;
  friend class ButtonComponent;
  friend class MenuComponent;
  friend class ComboBoxComponent;
  friend class TextInputComponent;
  friend class OptionComponent;
  friend class CheckBoxComponent;

public:
  typedef std::vector<char> keys_t; /*!<  */
  typedef std::vector<int> sdl_keys_t; /*!< L[ */
  typedef std::list<SDLKey> now_keys_t; /*!< ĂL[ */

  /*!
    \brief J郆[U͏
  */
  class userInput_t {
  public:
    bool quit;			/*!< Iw */
    bool left_released;		/*!< }EX̍{^ꂽ */
    bool left_clicked;		/*!< }EX̍{^ꂽ */
    int wheel_moved;		/*!< zC[̈ړ */
    VXV::Grid mpos;		/*!< }EXJ[\ʒu*/
    bool mouse_moved;		/*!< }EXJ[\ړ*/
    int mxx;			/*!< }EXJ[\ X̕ψڗ */
    int myy;			/*!< }EXJ[\ Y̕ψڗ */
    keys_t keys;		/*!< ꂽL[ */
    sdl_keys_t sdl_keys;	/*!< ꂽ SDLL[Ǘ */
    now_keys_t now_keys;	/*!< Ă SDLL[Ǘ */
    bool tab_pressed;		/*!< TAB ꂽ */
    bool ctrl_pressed;		/*!< Ctrl Ă邩*/
    bool alt_pressed;		/*!< Alt Ă邩*/

    userInput_t(void)
      : quit(false), left_released(false), left_clicked(false),
	wheel_moved(0) {}
    ~userInput_t(void) {}

    /*!
      \brief ꂽ

      \param ch [i] 
    */
    bool isPressed(char ch) const;

    /*!
      \brief R[hꂽ

      \param code [i] SDL_key ̃R[h
    */
    bool isPressedCode(int code) const;

    /*!
      \brief R[hĂ邩

      \param code [i] SDL_key ̃R[h
    */
    bool nowPressedCode(int code) const;
  };

private:
  // VXe
  bool toggle_fullscreen;

  // }EX
  VXV::Grid mpos;
  bool left_release;
  keys_t keys_sys;
  sdl_keys_t sdl_keys_sys;
  typedef std::vector<SDLMod> sdl_mods_t;
  sdl_mods_t sdl_mods_sys;

  static UserInput* obj;
  static userInput_t state;
  void internal_stateClear(void);
  void internal_update(void);
  static void stateClear(void);
  void keyupHandler(SDL_KeyboardEvent& key_event);
  void keydownHandler(SDL_KeyboardEvent& key_event);
  void mousebuttonHandler(SDL_MouseButtonEvent& button_event);
  UserInput(void);

public:
  ~UserInput(void);

  /*!
    \brief NXIuWFNg̎擾

    \return NXIuWFNg
  */
  static UserInput& getObject(void);

  /*!
    \brief ͏񃊃\[X̎擾

    \return ͏񃊃\[X
  */
  static userInput_t getInputed(void);
};

#endif /* !USER_INPUT_H */
