/*
  gnuplot ŉ{邽߂̃f[^o͂
  Satofumi KAMIMURA
  $Id$
*/

#include "dumpPlotData.h"
#include <fstream>

static int FilesIndex = 0;


// Lv`f[^t@Co
void outputPlotData(URGCtrl& urg, const char* file) {
  int len = strlen(file);
  char* str = strrchr(file, '/') +1;
  char* data_file = new char[len + 13];
  sprintf(data_file, "dat_%s_%03d.dat", str, FilesIndex++);
  std::ofstream fout(data_file);
  delete [] data_file;

  // urg ̃f[^ x, y ̍sf[^Ƃďo
  for (std::vector<VXV::Grid3D>::iterator it = urg.crd_points.begin();
       it != urg.crd_points.end(); ++it) {
    fout << it->x << '\t' << it->y << std::endl;
  }
  fout.close();
}


// Sf[^ gnuplot ŕ\邽߂̃t@Co
void outputPlotFile(const char* file) {
  int len = strlen(file);
  char* str = strrchr(file, '/') +1;
  char* data_file = new char[len + 13];
  char* ps_file = new char[len + 13];
  sprintf(data_file, "dat_%s.gnu", str);
  sprintf(ps_file, "dat_%s.ps", str);
  std::ofstream fout(data_file);

  fout << "#set terminal postscript color" << std::endl;
  fout << "#set output \"" << ps_file << "\"" << std::endl;

  fout << "set xlabel '[mm]'" << std::endl;
  fout << "set ylabel '[mm]'" << std::endl;

  fout << "plot ";
  for (int i = 0; i < FilesIndex; ++i) {
    sprintf(data_file, "dat_%s_%03d.dat", str, i);
    fout << '\'' << data_file << '\'';
    if (i < FilesIndex-1) {
      fout << ", ";
    }
  }
  fout << std::endl;
  fout << "pause -1" << std::endl;
  delete [] data_file;
  fout.close();
}
