/*
    avicore
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __PIXBUF_H__
#define __PIXBUF_H__


#include "bitmap.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:GdkPixbufビットマップ変換関数                                            *
*                                                                             *
******************************************************************************/
/*  ja:ビットマップをGdkPixbufに変換する
    bmih,BitmapInfoHeader構造体へのポインタ
    RET,GdkPixbuf                                                           */
GdkPixbuf *
pixbuf_from_bitmap (const BitmapInfoHeader *bmih);


/*  ja:GdkPixbufをビットマップに変換する
    pixbuf,GdkPixbuf
       RET,BitmapInfoHeader構造体へのポインタ                               */
BitmapInfoHeader *
pixbuf_to_bitmap (GdkPixbuf *pixbuf);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __PIXBUF_H__ */
