/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "winsock.h"
#include "user32.h"


#ifdef W32LDR_HEADER
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif /* HAVE_ARPA_INET_H */
#ifdef HAVE_ARPA_NAMESER_H
# include <arpa/nameser.h>
#endif /* HAVE_ARPA_NAMESER_H */
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif /* HAVE_NETDB_H */
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif /* HAVE_NETINET_IN_H */
#ifdef HAVE_RESOLV_H
# include <resolv.h>
#endif /* HAVE_RESOLV_H */
#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif /* HAVE_SYS_SELECT_H */
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif /* HAVE_SYS_SOCKET_H */
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#endif /* HAVE_SYS_TIME_H */
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif /* HAVE_UNISTD_H */

#define ERROR_INVALID_HANDLE    6
#define ERROR_NOT_ENOUGH_MEMORY 8
#define INVALID_SOCKET          (SOCKET)(~0)
#define MAXGETHOSTSTRUCT        1024
#define SOCKET_ERROR            (-1)
#define TCP_NODELAY             1

#define FD_READ    0x00000001
#define FD_WRITE   0x00000002
#define FD_OOB     0x00000004
#define FD_ACCEPT  0x00000008
#define FD_CONNECT 0x00000010
#define FD_CLOSE   0x00000020

#define WSAGETSELECTEVENT(lParam) LOWORD(lParam)
#define WSAGETSELECTERROR(lParam) HIWORD(lParam)

typedef UINT_PTR SOCKET;

#define WSADESCRIPTION_LEN 256
#define WSASYS_STATUS_LEN 128
#include "pshpack1.h"
typedef struct _WSAData
{
  WORD wVersion;
  WORD wHighVersion;
  CHAR szDescription[WSADESCRIPTION_LEN + 1];
  CHAR szSystemStatus[WSASYS_STATUS_LEN + 1];
  WORD iMaxSockets;
  WORD iMaxUdpDg;
  LPSTR lpVendorInfo;
} WSADATA, *PWSADATA, *LPWSADATA;
#include "poppack.h"

#define WSABASEERR             10000
#define WSAEINTR               (WSABASEERR+4)
#define WSAEBADF               (WSABASEERR+9)
#define WSAEACCES              (WSABASEERR+13)
#define WSAEFAULT              (WSABASEERR+14)
#define WSAEINVAL              (WSABASEERR+22)
#define WSAEMFILE              (WSABASEERR+24)
#define WSAEWOULDBLOCK         (WSABASEERR+35)
#define WSAEINPROGRESS         (WSABASEERR+36)
#define WSAEALREADY            (WSABASEERR+37)
#define WSAENOTSOCK            (WSABASEERR+38)
#define WSAEDESTADDRREQ        (WSABASEERR+39)
#define WSAEMSGSIZE            (WSABASEERR+40)
#define WSAEPROTOTYPE          (WSABASEERR+41)
#define WSAENOPROTOOPT         (WSABASEERR+42)
#define WSAEPROTONOSUPPORT     (WSABASEERR+43)
#define WSAESOCKTNOSUPPORT     (WSABASEERR+44)
#define WSAEOPNOTSUPP          (WSABASEERR+45)
#define WSAEPFNOSUPPORT        (WSABASEERR+46)
#define WSAEAFNOSUPPORT        (WSABASEERR+47)
#define WSAEADDRINUSE          (WSABASEERR+48)
#define WSAEADDRNOTAVAIL       (WSABASEERR+49)
#define WSAENETDOWN            (WSABASEERR+50)
#define WSAENETUNREACH         (WSABASEERR+51)
#define WSAENETRESET           (WSABASEERR+52)
#define WSAECONNABORTED        (WSABASEERR+53)
#define WSAECONNRESET          (WSABASEERR+54)
#define WSAENOBUFS             (WSABASEERR+55)
#define WSAEISCONN             (WSABASEERR+56)
#define WSAENOTCONN            (WSABASEERR+57)
#define WSAESHUTDOWN           (WSABASEERR+58)
#define WSAETOOMANYREFS        (WSABASEERR+59)
#define WSAETIMEDOUT           (WSABASEERR+60)
#define WSAECONNREFUSED        (WSABASEERR+61)
#define WSAELOOP               (WSABASEERR+62)
#define WSAENAMETOOLONG        (WSABASEERR+63)
#define WSAEHOSTDOWN           (WSABASEERR+64)
#define WSAEHOSTUNREACH        (WSABASEERR+65)
#define WSAENOTEMPTY           (WSABASEERR+66)
#define WSAEPROCLIM            (WSABASEERR+67)
#define WSAEUSERS              (WSABASEERR+68)
#define WSAEDQUOT              (WSABASEERR+69)
#define WSAESTALE              (WSABASEERR+70)
#define WSAEREMOTE             (WSABASEERR+71)
#define WSAEDISCON             (WSABASEERR+101)
#define WSASYSNOTREADY         (WSABASEERR+91)
#define WSAVERNOTSUPPORTED     (WSABASEERR+92)
#define WSANOTINITIALISED      (WSABASEERR+93)
#define WSAEDISCON             (WSABASEERR+101)
#define WSAENOMORE             (WSABASEERR+102)
#define WSAECANCELLED          (WSABASEERR+103)
#define WSAEINVALIDPROCTABLE   (WSABASEERR+104)
#define WSAEINVALIDPROVIDER    (WSABASEERR+105)
#define WSAEPROVIDERFAILEDINIT (WSABASEERR+106)
#define WSASYSCALLFAILURE      (WSABASEERR+107)
#define WSASERVICE_NOT_FOUND   (WSABASEERR+108)
#define WSATYPE_NOT_FOUND      (WSABASEERR+109)
#define WSA_E_NO_MORE          (WSABASEERR+110)
#define WSA_E_CANCELLED        (WSABASEERR+111)
#define WSAEREFUSED            (WSABASEERR+112)
#define WSAHOST_NOT_FOUND      (WSABASEERR+1001)
#define WSATRY_AGAIN           (WSABASEERR+1002)
#define WSANO_RECOVERY         (WSABASEERR+1003)
#define WSANO_DATA             (WSABASEERR+1004)

#define accept(sockfd,addr,addrlen) winsock_accept(sockfd,addr,addrlen)
#define connect(sockfd,serv_addr,addrlen) winsock_connect(sockfd,serv_addr,addrlen)
#define listen(sockfd,backlog) winsock_listen(sockfd,backlog)
#define recv(sockfd,buf,len,flags) winsock_recv(sockfd,buf,len,flags)
#define recvfrom(sockfd,buf,len,flags,from,fromlen) winsock_recvfrom(sockfd,buf,len,flags,from,fromlen)
#define send(sockfd,buf,len,flags) winsock_send(sockfd,buf,len,flags)
#define sendto(sockfd,buf,len,flags,to,tolen) winsock_sendto(sockfd,buf,len,flags,to,tolen)
#endif /* W32LDR_HEADER */


#undef accept
#undef listen
#undef connect
#undef recv
#undef recvfrom
#undef send
#undef sendto


typedef struct _W32LdrWinsock
{
  GtkWidget *widget;
  gulong handler;
} W32LdrWinsock;

/* AcceptEx ordinal = 1141, argument = 32 temporary */
static DWORD WINAPI AcceptEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* EnumProtocolsA ordinal = 1111, argument = 12 temporary */
static DWORD WINAPI EnumProtocolsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumProtocolsW ordinal = 1112, argument = 12 temporary */
static DWORD WINAPI EnumProtocolsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetAcceptExSockaddrs ordinal = 1142, argument = 32 temporary */
static DWORD WINAPI GetAcceptExSockaddrs (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* GetAddressByNameA ordinal = 1109, argument = 40 temporary */
static DWORD WINAPI GetAddressByNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* GetAddressByNameW ordinal = 1110, argument = 40 temporary */
static DWORD WINAPI GetAddressByNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* GetNameByTypeA ordinal = 1115, argument = 12 temporary */
static DWORD WINAPI GetNameByTypeA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetNameByTypeW ordinal = 1116, argument = 12 temporary */
static DWORD WINAPI GetNameByTypeW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetServiceA ordinal = 1119, argument = 28 temporary */
static DWORD WINAPI GetServiceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetServiceW ordinal = 1120, argument = 28 temporary */
static DWORD WINAPI GetServiceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetTypeByNameA ordinal = 1113, argument = 8 temporary */
static DWORD WINAPI GetTypeByNameA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTypeByNameW ordinal = 1114, argument = 8 temporary */
static DWORD WINAPI GetTypeByNameW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* MigrateWinsockConfiguration ordinal = 24, argument = 12 temporary */
static DWORD WINAPI MigrateWinsockConfiguration (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* NPLoadNameSpaces ordinal = 1130, argument = 12 temporary */
static DWORD WINAPI NPLoadNameSpaces (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetServiceA ordinal = 1117, argument = 24 temporary */
static DWORD WINAPI SetServiceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetServiceW ordinal = 1118, argument = 24 temporary */
static DWORD WINAPI SetServiceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* TransmitFile ordinal = 1140, argument = 28 temporary */
static DWORD WINAPI TransmitFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* WEP ordinal = 500, argument = 0 temporary */
static DWORD WINAPI WEP (VOID)
{
  return 0;
}


/* WSAAsyncGetHostByAddr ordinal = 102, argument = 28 temporary */
static DWORD WINAPI WSAAsyncGetHostByAddr (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


typedef struct _W32LdrHostent
{
  W32LdrWinsock w32winsock;
  HWND hWnd;
  UINT wMsg;
  LPCSTR name;
  LPSTR buf;
  INT buflen;
} W32LdrHostent;


static gpointer
hostent_gethostbyname (W32LdrHostent *w32hostent)
{
  gint aliases = 0, addr_list = 0;
  gsize buflen;
  struct hostent *hostent;
  W32LdrWinsock *w32winsock;

  hostent = gethostbyname (w32hostent->name);
  w32winsock = &w32hostent->w32winsock;
  if (w32winsock->handler != 0)
    {
      if (hostent)
        {
          buflen = sizeof (struct hostent)
                            + (g_strlen (hostent->h_name) + 1) * sizeof (char);
          if (hostent->h_aliases)
            {
              for (aliases = 0; hostent->h_aliases[aliases]; aliases++)
                buflen += (g_strlen (hostent->h_aliases[aliases]) + 1)
                                                            * sizeof (char);
              aliases++;
              buflen += aliases * sizeof (char *);
            }
          if (hostent->h_addr_list)
            {
              for (addr_list = 0; hostent->h_addr_list[addr_list]; addr_list++)
                buflen += (g_strlen (hostent->h_addr_list[addr_list]) + 1)
                                                            * sizeof (char);
              addr_list++;
              buflen += addr_list * sizeof (char *);
            }
          if (w32hostent->buflen >= buflen)
            {
              char *p;
              struct hostent *ht;

              g_memmove (w32hostent->buf, hostent, sizeof (struct hostent));
              ht = (struct hostent *)w32hostent->buf;
              p = w32hostent->buf + sizeof (struct hostent);
              ht->h_name = p;
              g_strcpy (p, hostent->h_name);
              p += g_strlen (hostent->h_name) + 1;
              if (hostent->h_aliases)
                {
                  gint i;

                  ht->h_aliases = (char **)p;
                  p += aliases * sizeof (char *);
                  for (i = 0; hostent->h_aliases[i]; i++)
                    {
                      g_strcpy (p, hostent->h_aliases[i]);
                      ht->h_aliases[i] = p;
                      p += g_strlen (hostent->h_aliases[i]) + 1;
                    }
                  ht->h_aliases[i] = NULL;
                }
              if (hostent->h_addr_list)
                {
                  gint i;

                  ht->h_addr_list = (char **)p;
                  p += addr_list * sizeof (char *);
                  for (i = 0; hostent->h_addr_list[i]; i++)
                    {
                      g_strcpy (p, hostent->h_addr_list[i]);
                      ht->h_addr_list[i] = p;
                      p += g_strlen (hostent->h_addr_list[i]) + 1;
                    }
                  ht->h_addr_list[i] = NULL;
                }
              SendMessageA (w32hostent->hWnd, w32hostent->wMsg,
                            GPOINTER_TO_INT (w32hostent), MAKELPARAM (0, 0));
            }
          else
            {
              SendMessageA (w32hostent->hWnd, w32hostent->wMsg,
                                            GPOINTER_TO_INT (w32hostent),
                                                MAKELPARAM (0, WSAENOBUFS));
            }
        }
      else
        {
          SendMessageA (w32hostent->hWnd, w32hostent->wMsg,
                                            GPOINTER_TO_INT (w32hostent),
                                            MAKELPARAM (0, WSAHOST_NOT_FOUND));
        }
      g_signal_handler_disconnect (G_OBJECT (w32winsock->widget),
                                                        w32winsock->handler);
      w32winsock->handler = 0;
    }
  return NULL;
}


static void
w32winsock_destroy (GtkWidget     *widget,
                    W32LdrWinsock *w32winsock)
{
  if (w32winsock->handler != 0)
    {
      g_signal_handler_disconnect (G_OBJECT (w32winsock->widget),
                                                        w32winsock->handler);
      w32winsock->handler = 0;
    }
}


/* WSAAsyncGetHostByName ordinal = 103, argument = 20 */
HANDLE WINAPI WSAAsyncGetHostByName (HWND hWnd, UINT wMsg, LPCSTR name, LPSTR buf, INT buflen)
{
  W32LdrHostent *w32hostent;
  W32LdrWinsock *w32winsock;

  if (!hWnd || !name)
    return NULL;
  w32hostent = g_malloc (sizeof (W32LdrHostent));
  w32hostent->hWnd = hWnd;
  w32hostent->wMsg = wMsg;
  w32hostent->name = g_strdup (name);
  w32hostent->buf = buf;
  w32hostent->buflen = buflen;
  w32winsock = &w32hostent->w32winsock;
  w32winsock->widget = hWnd;
  w32winsock->handler = g_signal_connect (G_OBJECT (hWnd), "destroy",
                                G_CALLBACK (w32winsock_destroy), w32winsock);
#ifdef USE_THREAD
  g_thread_create ((GThreadFunc)hostent_gethostbyname, w32hostent, TRUE, NULL);
#else /* not USE_THREAD */
  hostent_gethostbyname (w32hostent);
#endif /* not USE_THREAD */
  return (HANDLE)w32hostent;
}


/* WSAAsyncGetProtoByName ordinal = 105, argument = 20 temporary */
static DWORD WINAPI WSAAsyncGetProtoByName (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WSAAsyncGetProtoByNumber ordinal = 104, argument = 20 temporary */
static DWORD WINAPI WSAAsyncGetProtoByNumber (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WSAAsyncGetServByName ordinal = 107, argument = 24 temporary */
static DWORD WINAPI WSAAsyncGetServByName (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* WSAAsyncGetServByPort ordinal = 106, argument = 24 temporary */
static DWORD WINAPI WSAAsyncGetServByPort (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


typedef struct _W32LdrSelect
{
  W32LdrWinsock w32winsock;
  SOCKET sockfd;
  HWND hWnd;
  UINT wMsg;
  LONG lEvent;
  LONG lMask;
} W32LdrSelect;


GList *glist_socket = NULL;


static gboolean
select_polling (gpointer data)
{
  GList *glist;
  int nfds = -1;
  fd_set rfds, wfds, efds;
  struct timeval timeout;

  FD_ZERO (&rfds);
  FD_ZERO (&wfds);
  FD_ZERO (&efds);
  for (glist = g_list_first (glist_socket); glist; glist = g_list_next (glist))
    {
      W32LdrSelect *w32select;

      w32select = glist->data;
      if (nfds < w32select->sockfd && (w32select->lEvent & w32select->lMask
                                            & (FD_READ | FD_WRITE | FD_OOB)))
        nfds = w32select->sockfd;
      if (w32select->lEvent & w32select->lMask & FD_READ)
        FD_SET (w32select->sockfd, &rfds);
      if (w32select->lEvent & w32select->lMask & FD_WRITE)
        FD_SET (w32select->sockfd, &wfds);
      if (w32select->lEvent & w32select->lMask & FD_OOB)
        FD_SET (w32select->sockfd, &efds);
    }
  timeout.tv_sec = 0;
  timeout.tv_usec = 0;
  if (nfds >= 0 && select (nfds + 1, &rfds, &wfds, &efds, &timeout) > 0)
    for (glist = g_list_first (glist_socket); glist;
                                                glist = g_list_next (glist))
      {
        W32LdrSelect *w32select;

        w32select = glist->data;
        if (FD_ISSET (w32select->sockfd, &rfds))
          SendMessageA (w32select->hWnd, w32select->wMsg,
                                w32select->sockfd, MAKELPARAM (FD_READ, 0));
        if (FD_ISSET (w32select->sockfd, &wfds))
          SendMessageA (w32select->hWnd, w32select->wMsg,
                                w32select->sockfd, MAKELPARAM (FD_WRITE, 0));
        if (FD_ISSET (w32select->sockfd, &efds))
          SendMessageA (w32select->hWnd, w32select->wMsg,
                                w32select->sockfd, MAKELPARAM (FD_OOB, 0));
        w32select->lMask &= ~(FD_READ | FD_WRITE | FD_OOB);
      }
  return TRUE;
}


static void
select_destroy (GtkWidget    *widget,
                W32LdrSelect *w32select)
{
  WSAAsyncSelect (w32select->sockfd, w32select->hWnd, 0, 0);
}


/* WSAAsyncSelect ordinal = 101, argument = 16 */
INT WINAPI WSAAsyncSelect (SOCKET sockfd, HWND hWnd, UINT wMsg, LONG lEvent)
{
  W32LdrSelect *w32select;
  static guint timer = 0;

  if (hWnd && wMsg != 0 && lEvent != 0)
    {
      w32select = g_malloc (sizeof (W32LdrSelect));
      w32select->sockfd = sockfd;
      w32select->hWnd = hWnd;
      w32select->wMsg = wMsg;
      w32select->lEvent = lEvent;
      w32select->lMask = lEvent;
      w32select->w32winsock.widget = hWnd;
      w32select->w32winsock.handler = g_signal_connect (G_OBJECT (hWnd),
                            "destroy", G_CALLBACK (select_destroy), w32select);
      glist_socket = g_list_append (glist_socket, w32select);
      if (timer == 0)
        timer = g_timeout_add (500, select_polling, NULL);
    }
  else
    {
      GList *glist;

      glist = g_list_first (glist_socket);
      while (glist)
        {
          W32LdrSelect *w32select;

          w32select = glist->data;
          glist = g_list_next (glist);
          if (w32select->sockfd == sockfd)
            {
              W32LdrWinsock *w32winsock;

              w32winsock = &w32select->w32winsock;
              glist_socket = g_list_remove (glist_socket, w32select);
              if (w32winsock->handler != 0)
                g_signal_handler_disconnect (G_OBJECT (w32winsock->widget),
                                                        w32winsock->handler);
              g_free (w32select);
            }
        }
      if (!glist_socket && timer != 0 && g_source_remove (timer))
        timer = 0;
    }
  return 0;
}


/* WSACancelAsyncRequest ordinal = 108, argument = 4 */
INT WINAPI WSACancelAsyncRequest (HANDLE hAsyncTaskHandle)
{
  if (hAsyncTaskHandle)
    {
      W32LdrWinsock *w32winsock;

      w32winsock = (W32LdrWinsock *)hAsyncTaskHandle;
      if (w32winsock->handler != 0)
        {
          g_signal_handler_disconnect (G_OBJECT (w32winsock->widget),
                                                        w32winsock->handler);
          w32winsock->handler = 0;
          return 0;
        }
    }
  return WSAEINVAL;
}


/* WSACancelBlockingCall ordinal = 113, argument = 0 temporary */
static DWORD WINAPI WSACancelBlockingCall (VOID)
{
  return 0;
}


/* WSACleanup ordinal = 116, argument = 0 */
int WINAPI WSACleanup (void)
{
  return 0;
}


/* WSAGetLastError ordinal = 111, argument = 0 */
int WINAPI WSAGetLastError (void)
{
  return WSASYSCALLFAILURE;
}


/* WSAIsBlocking ordinal = 114, argument = 0 temporary */
static DWORD WINAPI WSAIsBlocking (VOID)
{
  return 0;
}


/* WSARecvEx ordinal = 1107, argument = 16 temporary */
static DWORD WINAPI WSARecvEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* WSASetBlockingHook ordinal = 109, argument = 4 temporary */
static DWORD WINAPI WSASetBlockingHook (DWORD dwArgv0)
{
  return 0;
}


/* WSASetLastError ordinal = 112, argument = 4 temporary */
static DWORD WINAPI WSASetLastError (DWORD dwArgv0)
{
  return 0;
}


/* WSAStartup ordinal = 115, argument = 8 */
int WINAPI WSAStartup (WORD wVersionRequested, LPWSADATA lpWSAData)
{
  return 0;
}


/* WSAUnhookBlockingHook ordinal = 110, argument = 0 temporary */
static DWORD WINAPI WSAUnhookBlockingHook (VOID)
{
  return 0;
}


/* WSApSetPostRoutine ordinal = 1000, argument = 0 temporary */
static DWORD WINAPI WSApSetPostRoutine (VOID)
{
  return 0;
}


/* __WSAFDIsSet ordinal = 151, argument = 8 temporary */
static DWORD WINAPI __WSAFDIsSet (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* accept ordinal = 1, argument = 12 */
int WINAPI winsock_accept (int sockfd, struct sockaddr *addr, socklen_t *addrlen)
{
  GList *glist;

  for (glist = g_list_first (glist_socket); glist; glist = g_list_next (glist))
    {
      W32LdrSelect *w32select;

      w32select = glist->data;
      if (w32select->sockfd == sockfd && (w32select->lEvent & FD_ACCEPT))
        w32select->lMask |= FD_ACCEPT;
    }
  return accept (sockfd, addr, addrlen);
}


/* bind ordinal = 2, argument = 12 */
int WINAPI winsock_bind (int sockfd, const struct sockaddr *my_addr, socklen_t addrlen)
{
  return bind (sockfd, my_addr, addrlen);
}


/* closesocket ordinal = 3, argument = 4 */
int WINAPI closesocket (int sockfd)
{
  int result;
  GList *glist;

  result = close (sockfd);
  for (glist = g_list_first (glist_socket); glist; glist = g_list_next (glist))
    {
      W32LdrSelect *w32select;

      w32select = glist->data;
      if (w32select->sockfd == sockfd
                        && (w32select->lEvent & w32select->lMask & FD_CLOSE))
        {
          w32select->lMask &= ~FD_CLOSE;
          SendMessageA (w32select->hWnd, w32select->wMsg,
                            w32select->sockfd, MAKELPARAM (FD_CLOSE, result));
        }
    }
  WSAAsyncSelect (sockfd, NULL, 0, 0);
  return result;
}


/* connect ordinal = 4, argument = 12 */
int WINAPI winsock_connect (int sockfd, const struct sockaddr *serv_addr, socklen_t addrlen)
{
  int result;
  GList *glist;

  result = connect (sockfd, serv_addr, addrlen);
  for (glist = g_list_first (glist_socket); glist; glist = g_list_next (glist))
    {
      W32LdrSelect *w32select;

      w32select = glist->data;
      if (w32select->sockfd == sockfd
                        && (w32select->lEvent & w32select->lMask & FD_CONNECT))
        {
          w32select->lMask &= ~FD_CONNECT;
          SendMessageA (w32select->hWnd, w32select->wMsg,
                        w32select->sockfd, MAKELPARAM (FD_CONNECT, result));
        }
    }
  return result;
}


/* dn_expand ordinal = 1106, argument = 20 temporary */
static int WINAPI winsock_dn_expand (unsigned char *msg, unsigned char *eomorig, unsigned char *comp_dn, unsigned char *exp_dn, int length)
{
  return -1;
}


/* gethostbyaddr ordinal = 51, argument = 12 */
static struct hostent * WINAPI winsock_gethostbyaddr (const void *addr, int len, int type)
{
  return gethostbyaddr (addr, len, type);
}


/* gethostbyname ordinal = 52, argument = 4 */
static struct hostent * WINAPI winsock_gethostbyname (const char *name)
{
  return gethostbyname (name);
}


/* gethostname ordinal = 57, argument = 8 */
static int WINAPI winsock_gethostname (char *name, size_t len)
{
  return gethostname (name, len);
}


/* getnetbyname ordinal = 1101, argument = 4 */
static struct netent * WINAPI winsock_getnetbyname (const char *name)
{
  return getnetbyname (name);
}


/* getpeername ordinal = 5, argument = 12 */
static int WINAPI winsock_getpeername (int sockfd, struct sockaddr *name, socklen_t *namelen)
{
  return getpeername (sockfd, name, namelen);
}


/* getprotobyname ordinal = 53, argument = 4 */
static struct protoent * WINAPI winsock_getprotobyname (const char *name)
{
  return getprotobyname (name);
}


/* getprotobynumber ordinal = 54, argument = 4 */
static struct protoent * WINAPI winsock_getprotobynumber (int proto)
{
  return getprotobynumber (proto);
}


/* getservbyname ordinal = 55, argument = 8 */
static struct servent * WINAPI winsock_getservbyname (const char *name, const char *proto)
{
  return getservbyname (name, proto);
}


/* getservbyport ordinal = 56, argument = 8 */
static struct servent * WINAPI winsock_getservbyport (int port, const char *proto)
{
  return getservbyport (port, proto);
}


/* getsockname ordinal = 6, argument = 12 */
static int WINAPI winsock_getsockname (int sockfd, struct sockaddr *name, socklen_t *namelen)
{
  return getsockname (sockfd, name, namelen);
}


/* getsockopt ordinal = 7, argument = 20 */
static int WINAPI winsock_getsockopt (int sockfd, int level, int optname, void *optval, socklen_t *optlen)
{
  return getsockopt (sockfd, level, optname, optval, optlen);
}


/* htonl ordinal = 8, argument = 4 */
static uint32_t WINAPI winsock_htonl (uint32_t hostlong)
{
  return htonl (hostlong);
}


/* htons ordinal = 9, argument = 4 */
static uint16_t WINAPI winsock_htons (uint16_t hostshort)
{
  return htons (hostshort);
}


/* inet_addr ordinal = 10, argument = 4 */
static in_addr_t WINAPI winsock_inet_addr (const char *cp)
{
  return inet_addr (cp);
}


/* inet_network ordinal = 1100, argument = 4 */
static in_addr_t WINAPI winsock_inet_network (const char *cp)
{
  return inet_network (cp);
}


/* inet_ntoa ordinal = 11, argument = 4 */
static char * WINAPI winsock_inet_ntoa (struct in_addr in)
{
  return inet_ntoa (in);
}


/* ioctlsocket ordinal = 12, argument = 12 temporary */
static DWORD WINAPI ioctlsocket (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* listen ordinal = 13, argument = 8 */
int WINAPI winsock_listen (int sockfd, int backlog)
{
  int result;
  GList *glist;

  result = listen (sockfd, backlog);
  if (result == 0)
    for (glist = g_list_first (glist_socket); glist;
                                                glist = g_list_next (glist))
      {
        W32LdrSelect *w32select;

        w32select = glist->data;
        if (w32select->sockfd == sockfd
                        && (w32select->lEvent & w32select->lMask & FD_ACCEPT))
          {
            w32select->lMask &= ~FD_ACCEPT;
            SendMessageA (w32select->hWnd, w32select->wMsg,
                                w32select->sockfd, MAKELPARAM (FD_ACCEPT, 0));
          }
      }
  return result;
}


/* ntohl ordinal = 14, argument = 4 */
static uint32_t WINAPI winsock_ntohl (uint32_t netlong)
{
  return ntohl (netlong);
}


/* ntohs ordinal = 15, argument = 4 */
static uint16_t WINAPI winsock_ntohs (uint16_t netshort)
{
  return ntohs (netshort);
}


/* rcmd ordinal = 1102, argument = 24 temporary */
static DWORD WINAPI winsock_rcmd (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* recv ordinal = 16, argument = 16 */
ssize_t WINAPI winsock_recv (int sockfd, void *buf, size_t len, int flags)
{
  GList *glist;

  for (glist = g_list_first (glist_socket); glist; glist = g_list_next (glist))
    {
      W32LdrSelect *w32select;

      w32select = glist->data;
      if (w32select->sockfd == sockfd && (w32select->lEvent & FD_READ))
        w32select->lMask |= FD_READ;
    }
  return recv (sockfd, buf, len, flags);
}


/* recvfrom ordinal = 17, argument = 24 */
ssize_t WINAPI winsock_recvfrom (int sockfd, void *buf, size_t len, int flags, struct sockaddr *from, socklen_t *fromlen)
{
  GList *glist;

  for (glist = g_list_first (glist_socket); glist; glist = g_list_next (glist))
    {
      W32LdrSelect *w32select;

      w32select = glist->data;
      if (w32select->sockfd == sockfd && (w32select->lEvent & FD_READ))
        w32select->lMask |= FD_READ;
    }
  return recvfrom (sockfd, buf, len, flags, from, fromlen);
}


/* rexec ordinal = 1103, argument = 24 temporary */
static DWORD WINAPI winsock_rexec (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* rresvport ordinal = 1104, argument = 4 temporary */
static DWORD WINAPI winsock_rresvport (DWORD dwArgv0)
{
  return 0;
}


/* s_perror ordinal = 1108, argument = 8 temporary */
static DWORD WINAPI s_perror (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* select ordinal = 18, argument = 20 */
static int WINAPI winsock_select (int nfds, fd_set *rfds, fd_set *wfds, fd_set *efds, struct timeval *timeout)
{
  return select (nfds, rfds, wfds, efds, timeout);
}


/* send ordinal = 19, argument = 16 */
ssize_t WINAPI winsock_send (int sockfd, const void *buf, size_t len, int flags)
{
  GList *glist;

  for (glist = g_list_first (glist_socket); glist; glist = g_list_next (glist))
    {
      W32LdrSelect *w32select;

      w32select = glist->data;
      if (w32select->sockfd == sockfd && (w32select->lEvent & FD_WRITE))
        w32select->lMask |= FD_WRITE;
    }
  return send (sockfd, buf, len, flags);
}


/* sendto ordinal = 20, argument = 24 */
ssize_t WINAPI winsock_sendto (int sockfd, const void *buf, size_t len, int flags, const struct sockaddr *to, socklen_t tolen)
{
  GList *glist;

  for (glist = g_list_first (glist_socket); glist; glist = g_list_next (glist))
    {
      W32LdrSelect *w32select;

      w32select = glist->data;
      if (w32select->sockfd == sockfd && (w32select->lEvent & FD_WRITE))
        w32select->lMask |= FD_WRITE;
    }
  return sendto (sockfd, buf, len, flags, to, tolen);
}


/* sethostname ordinal = 1105, argument = 8 */
static int WINAPI winsock_sethostname (const char *name, size_t len)
{
  return sethostname (name, len);
}


/* setsockopt ordinal = 21, argument = 20 */
static int WINAPI winsock_setsockopt (int sockfd, int level, int optname, const void *optval, socklen_t optlen)
{
  return setsockopt (sockfd, level, optname, optval, optlen);
}


/* shutdown ordinal = 22, argument = 8 */
static int WINAPI winsock_shutdown (int sockfd, int how)
{
  return shutdown (sockfd, how);
}


/* socket ordinal = 23, argument = 12 */
static int WINAPI winsock_socket (int domain, int type, int protocol)
{
  return socket (domain, type, protocol);
}


W32LdrExport winsock_exports[] = {
{FALSE, 1141, "AcceptEx",                    AcceptEx},
{FALSE, 1111, "EnumProtocolsA",              EnumProtocolsA},
{FALSE, 1112, "EnumProtocolsW",              EnumProtocolsW},
{FALSE, 1142, "GetAcceptExSockaddrs",        GetAcceptExSockaddrs},
{FALSE, 1109, "GetAddressByNameA",           GetAddressByNameA},
{FALSE, 1110, "GetAddressByNameW",           GetAddressByNameW},
{FALSE, 1115, "GetNameByTypeA",              GetNameByTypeA},
{FALSE, 1116, "GetNameByTypeW",              GetNameByTypeW},
{FALSE, 1119, "GetServiceA",                 GetServiceA},
{FALSE, 1120, "GetServiceW",                 GetServiceW},
{FALSE, 1113, "GetTypeByNameA",              GetTypeByNameA},
{FALSE, 1114, "GetTypeByNameW",              GetTypeByNameW},
{FALSE,   24, "MigrateWinsockConfiguration", MigrateWinsockConfiguration},
{FALSE, 1130, "NPLoadNameSpaces",            NPLoadNameSpaces},
{FALSE, 1117, "SetServiceA",                 SetServiceA},
{FALSE, 1118, "SetServiceW",                 SetServiceW},
{FALSE, 1140, "TransmitFile",                TransmitFile},
{FALSE,  500, "WEP",                         WEP},
{FALSE,  102, "WSAAsyncGetHostByAddr",       WSAAsyncGetHostByAddr},
{TRUE,   103, "WSAAsyncGetHostByName",       WSAAsyncGetHostByName},
{FALSE,  105, "WSAAsyncGetProtoByName",      WSAAsyncGetProtoByName},
{FALSE,  104, "WSAAsyncGetProtoByNumber",    WSAAsyncGetProtoByNumber},
{FALSE,  107, "WSAAsyncGetServByName",       WSAAsyncGetServByName},
{FALSE,  106, "WSAAsyncGetServByPort",       WSAAsyncGetServByPort},
{TRUE,   101, "WSAAsyncSelect",              WSAAsyncSelect},
{TRUE,   108, "WSACancelAsyncRequest",       WSACancelAsyncRequest},
{FALSE,  113, "WSACancelBlockingCall",       WSACancelBlockingCall},
{TRUE,   116, "WSACleanup",                  WSACleanup},
{TRUE,   111, "WSAGetLastError",             WSAGetLastError},
{FALSE,  114, "WSAIsBlocking",               WSAIsBlocking},
{FALSE, 1107, "WSARecvEx",                   WSARecvEx},
{FALSE,  109, "WSASetBlockingHook",          WSASetBlockingHook},
{FALSE,  112, "WSASetLastError",             WSASetLastError},
{TRUE,   115, "WSAStartup",                  WSAStartup},
{FALSE,  110, "WSAUnhookBlockingHook",       WSAUnhookBlockingHook},
{FALSE, 1000, "WSApSetPostRoutine",          WSApSetPostRoutine},
{FALSE,  151, "__WSAFDIsSet",                __WSAFDIsSet},
{TRUE,     1, "accept",                      winsock_accept},
{TRUE,     2, "bind",                        winsock_bind},
{TRUE,     3, "closesocket",                 closesocket},
{TRUE,     4, "connect",                     winsock_connect},
{FALSE, 1106, "dn_expand",                   winsock_dn_expand},
{TRUE,    51, "gethostbyaddr",               winsock_gethostbyaddr},
{TRUE,    52, "gethostbyname",               winsock_gethostbyname},
{TRUE,    57, "gethostname",                 winsock_gethostname},
{TRUE,  1101, "getnetbyname",                winsock_getnetbyname},
{TRUE,     5, "getpeername",                 winsock_getpeername},
{TRUE,    53, "getprotobyname",              winsock_getprotobyname},
{TRUE,    54, "getprotobynumber",            winsock_getprotobynumber},
{TRUE,    55, "getservbyname",               winsock_getservbyname},
{TRUE,    56, "getservbyport",               winsock_getservbyport},
{TRUE,     6, "getsockname",                 winsock_getsockname},
{TRUE,     7, "getsockopt",                  winsock_getsockopt},
{TRUE,     8, "htonl",                       winsock_htonl},
{TRUE,     9, "htons",                       winsock_htons},
{TRUE,    10, "inet_addr",                   winsock_inet_addr},
{TRUE,  1100, "inet_network",                winsock_inet_network},
{TRUE,    11, "inet_ntoa",                   winsock_inet_ntoa},
{FALSE,   12, "ioctlsocket",                 ioctlsocket},
{TRUE,    13, "listen",                      winsock_listen},
{TRUE,    14, "ntohl",                       winsock_ntohl},
{TRUE,    15, "ntohs",                       winsock_ntohs},
{FALSE, 1102, "rcmd",                        winsock_rcmd},
{TRUE,    16, "recv",                        winsock_recv},
{TRUE,    17, "recvfrom",                    winsock_recvfrom},
{FALSE, 1103, "rexec",                       winsock_rexec},
{FALSE, 1104, "rresvport",                   winsock_rresvport},
{FALSE, 1108, "s_perror",                    s_perror},
{TRUE,    18, "select",                      winsock_select},
{TRUE,    19, "send",                        winsock_send},
{TRUE,    20, "sendto",                      winsock_sendto},
{TRUE,  1105, "sethostname",                 winsock_sethostname},
{TRUE,    21, "setsockopt",                  winsock_setsockopt},
{TRUE,    22, "shutdown",                    winsock_shutdown},
{TRUE,    23, "socket",                      winsock_socket},
{FALSE,    0, NULL,                          NULL}};
