/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32private.h"
#include "kernel32.h"
#include "commctrl.h"
#include <gdk/gdkkeysyms.h>


#define TVIEW_ITEM     0
#define TVIEW_EXPANDED 1
#define TVIEW_TEXT     2
#define TVIEW_LPARAM   3


static gint
w32tview_get_count_recursible (GtkTreeModel *model,
                               GtkTreeIter  *parent)
{
  gint i, count = 0;
  GtkTreeIter iter;

  for (i = 0; gtk_tree_model_iter_nth_child (model, &iter, parent, i); i++)
    count += w32tview_get_count_recursible (model, &iter);
  return count + i;
}
#define w32tview_get_count(model) w32tview_get_count_recursible(model,NULL)


static GtkTreeIter *
w32tview_get_iter_from_item_recursible (GtkTreeModel *model,
                                        GtkTreeIter  *parent,
                                        const guint   item)
{
  gint i;
  GtkTreeIter iter;

  for (i = 0; gtk_tree_model_iter_nth_child (model, &iter, parent, i); i++)
    {
      guint it;
      GtkTreeIter *result;

      gtk_tree_model_get (model, &iter, TVIEW_ITEM, &it, -1);
      if (it == item)
        return gtk_tree_iter_copy (&iter);
      result = w32tview_get_iter_from_item_recursible (model, &iter, item);
      if (result)
        return result;
    }
  return NULL;
}
#define w32tview_get_iter_from_item(model,item) \
                        w32tview_get_iter_from_item_recursible(model,NULL,item)


static LRESULT WINAPI
w32tview_DefWindowProc (HWND   hWnd,
                        UINT   Msg,
                        WPARAM wParam,
                        LPARAM lParam)
{
  GtkWidget *tview;
  W32LdrWindowData *wd;
  static guint item_count = 1;

  wd = g_object_get_data (G_OBJECT (hWnd), "user_data");
  if (!wd)
    return 0;
  tview = gtk_bin_get_child (GTK_BIN (hWnd));
  switch (Msg)
    {
      case TVM_INSERTITEMA:
        if (lParam)
          {
            gboolean expanded = TRUE;
            gchar *utf8str = NULL;
            GtkTreeIter iter, *parent, *sibling;
            GtkTreeStore *store;
            TV_INSERTSTRUCTA *tvis;

            tvis = GINT_TO_POINTER (lParam);
            store = GTK_TREE_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (tview)));
            parent = w32tview_get_iter_from_item (GTK_TREE_MODEL (store),
                                            GPOINTER_TO_UINT (tvis->hParent));
            sibling = w32tview_get_iter_from_item (GTK_TREE_MODEL (store),
                                        GPOINTER_TO_UINT (tvis->hInsertAfter));
            if (tvis->hInsertAfter == TVI_SORT)
              {
                gchar *text;
                gint i;

                utf8str = w32ldr_utf8_from_mb (tvis->item.pszText);
                for (i = 0; gtk_tree_model_iter_nth_child
                            (GTK_TREE_MODEL (store), &iter, parent, i); i++)
                  {
                    gboolean result;

                    gtk_tree_model_get (GTK_TREE_MODEL (store), &iter,
                                                        TVIEW_TEXT, &text, -1);
                    result = g_strcmp (text, utf8str);
                    g_free (text);
                    if (result > 0)
                      break;
                  }
                g_free (utf8str);
                utf8str = NULL;
                gtk_tree_store_insert (store, &iter, parent, i);
              }
            else if (sibling || tvis->hInsertAfter == TVI_FIRST)
              {
                gtk_tree_store_insert_after (store, &iter, parent, sibling);
              }
            else
              {
                gtk_tree_store_insert_before (store, &iter, parent, NULL);
              }
            if (parent)
              gtk_tree_iter_free (parent);
            if (sibling)
              gtk_tree_iter_free (sibling);
            if (tvis->item.mask & TVIF_STATE)
              {
                if (tvis->item.stateMask & LVIS_SELECTED)
                  {
                    GtkTreeSelection *select;

                    select = gtk_tree_view_get_selection
                                                    (GTK_TREE_VIEW (tview));
                    if (tvis->item.state & LVIS_SELECTED)
                      gtk_tree_selection_select_iter (select, &iter);
                    else
                      gtk_tree_selection_unselect_iter (select, &iter);
                  }
                if (!(tvis->item.state & TVIS_EXPANDEDONCE)
                                && (tvis->item.stateMask & TVIS_EXPANDEDONCE))
                  expanded = FALSE;
              }
            if (tvis->item.mask & TVIF_TEXT)
              utf8str = w32ldr_utf8_from_mb (tvis->item.pszText);
            if (!expanded || ((tvis->item.mask & TVIF_CHILDREN)
                                                && tvis->item.cChildren > 0))
              gtk_tree_model_ref_node (GTK_TREE_MODEL (store), &iter);
            gtk_tree_store_set (store, &iter,
                                        TVIEW_ITEM, item_count,
                                        TVIEW_EXPANDED, expanded,
                                        TVIEW_TEXT, utf8str,
                                        TVIEW_LPARAM, tvis->item.lParam, -1);
            g_free (utf8str);
            return item_count++;
          }
        return GPOINTER_TO_INT (NULL);
      case TVM_INSERTITEMW:
        if (lParam)
          {
            gboolean expanded = TRUE;
            gchar *utf8str = NULL;
            GtkTreeIter iter, *parent, *sibling;
            GtkTreeStore *store;
            TV_INSERTSTRUCTW *tvis;

            tvis = GINT_TO_POINTER (lParam);
            store = GTK_TREE_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (tview)));
            parent = w32tview_get_iter_from_item (GTK_TREE_MODEL (store),
                                            GPOINTER_TO_UINT (tvis->hParent));
            sibling = w32tview_get_iter_from_item (GTK_TREE_MODEL (store),
                                        GPOINTER_TO_UINT (tvis->hInsertAfter));
            if (tvis->hInsertAfter == TVI_SORT)
              {
                gchar *text;
                gint i;

                utf8str = tvis->item.pszText ? g_utf16_to_utf8
                            (tvis->item.pszText, -1, NULL, NULL, NULL) : NULL;
                for (i = 0; gtk_tree_model_iter_nth_child
                            (GTK_TREE_MODEL (store), &iter, parent, i); i++)
                  {
                    gboolean result;

                    gtk_tree_model_get (GTK_TREE_MODEL (store), &iter,
                                                        TVIEW_TEXT, &text, -1);
                    result = g_strcmp (text, utf8str);
                    g_free (text);
                    if (result > 0)
                      break;
                  }
                g_free (utf8str);
                utf8str = NULL;
                gtk_tree_store_insert (store, &iter, parent, i);
              }
            else if (sibling || tvis->hInsertAfter == TVI_FIRST)
              {
                gtk_tree_store_insert_after (store, &iter, parent, sibling);
              }
            else
              {
                gtk_tree_store_insert_before (store, &iter, parent, NULL);
              }
            if (parent)
              gtk_tree_iter_free (parent);
            if (sibling)
              gtk_tree_iter_free (sibling);
            if (tvis->item.mask & TVIF_STATE)
              {
                if (tvis->item.stateMask & LVIS_SELECTED)
                  {
                    GtkTreeSelection *select;

                    select = gtk_tree_view_get_selection
                                                    (GTK_TREE_VIEW (tview));
                    if (tvis->item.state & LVIS_SELECTED)
                      gtk_tree_selection_select_iter (select, &iter);
                    else
                      gtk_tree_selection_unselect_iter (select, &iter);
                  }
                if (!(tvis->item.state & TVIS_EXPANDEDONCE)
                                && (tvis->item.stateMask & TVIS_EXPANDEDONCE))
                  expanded = FALSE;
              }
            if (tvis->item.mask & TVIF_TEXT)
              utf8str = tvis->item.pszText ? g_utf16_to_utf8
                            (tvis->item.pszText, -1, NULL, NULL, NULL) : NULL;
            if (!expanded || ((tvis->item.mask & TVIF_CHILDREN)
                                                && tvis->item.cChildren > 0))
              gtk_tree_model_ref_node (GTK_TREE_MODEL (store), &iter);
            gtk_tree_store_set (store, &iter,
                                        TVIEW_ITEM, item_count,
                                        TVIEW_EXPANDED, expanded,
                                        TVIEW_TEXT, utf8str,
                                        TVIEW_LPARAM, tvis->item.lParam, -1);
            g_free (utf8str);
            return item_count++;
          }
        return GPOINTER_TO_INT (NULL);
      case TVM_DELETEITEM:
        {
          GtkTreeStore *store;

          store = GTK_TREE_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (tview)));
          if (GINT_TO_POINTER (lParam) == TVI_ROOT)
            {
              gtk_tree_store_clear (store);
              return TRUE;
            }
          else
            {
              GtkTreeIter  *iter;

              iter = w32tview_get_iter_from_item (GTK_TREE_MODEL (store),
                                                                    lParam);
              if (iter)
                {
                  gtk_tree_store_remove (store, iter);
                  gtk_tree_iter_free (iter);
                  return TRUE;
                }
            }
        }
        return FALSE;
      case TVM_EXPAND:
        {
          GtkTreeIter  *iter;
          GtkTreeStore *store;

          store = GTK_TREE_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (tview)));
          iter = w32tview_get_iter_from_item (GTK_TREE_MODEL (store), lParam);
          if (iter)
            {
              gboolean result = FALSE;
              GtkTreePath *path;

              path = gtk_tree_model_get_path (GTK_TREE_MODEL (store), iter);
              if (path)
                {
                  if (wParam & TVE_COLLAPSE)
                    {
                      result = gtk_tree_view_collapse_row
                                                (GTK_TREE_VIEW (tview), path);
                      if (wParam & TVE_COLLAPSERESET)
                        {
                          gint i;
                          GtkTreeIter child;

                          for (i = 0; gtk_tree_model_iter_nth_child
                                (GTK_TREE_MODEL (store), &child, iter, i); i++)
                            if (!gtk_tree_store_remove (store, &child))
                              result = FALSE;
                          gtk_tree_store_set (store, iter,
                                                    TVIEW_EXPANDED, FALSE, -1);
                          gtk_tree_model_ref_node (GTK_TREE_MODEL (store),
                                                                        iter);
                        }
                    }
                  else if (wParam & TVE_EXPAND)
                    {
                      result = gtk_tree_view_expand_row (GTK_TREE_VIEW (tview),
                                                                path, FALSE);
                    }
                  else if (wParam & TVE_TOGGLE)
                    {
                      result = gtk_tree_view_row_expanded
                                                (GTK_TREE_VIEW (tview), path)
                                ? gtk_tree_view_collapse_row
                                                (GTK_TREE_VIEW (tview), path)
                                : gtk_tree_view_expand_row
                                        (GTK_TREE_VIEW (tview), path, FALSE);
                    }
                  gtk_tree_path_free (path);
                }
              gtk_tree_iter_free (iter);
              return result;
            }
        }
        return FALSE;
      case TVM_GETITEMRECT:
        if (lParam)
          {
            guint *item;
            GtkTreeIter *iter;
            GtkTreeModel *model;

            item = GINT_TO_POINTER (lParam);
            model = gtk_tree_view_get_model (GTK_TREE_VIEW (tview));
            iter = w32tview_get_iter_from_item (model, *item);
            if (iter)
              {
                gboolean result = FALSE;
                GtkTreePath *path;

                path = gtk_tree_model_get_path (model, iter);
                if (path)
                  {
                    GdkRectangle rect;
                    LPRECT lprc;

                    lprc = GINT_TO_POINTER (lParam);
                    gtk_tree_view_get_cell_area (GTK_TREE_VIEW (tview), path,
                        gtk_tree_view_get_column (GTK_TREE_VIEW (tview), 0),
                                                                        &rect);
                    gtk_tree_path_free (path);
                    lprc->left = rect.x;
                    lprc->top = rect.y;
                    lprc->right = rect.x + rect.width;
                    lprc->bottom = rect.y + rect.height;
                    result = TRUE;
                  }
                gtk_tree_iter_free (iter);
                return result;
              }
          }
        return FALSE;
      case TVM_GETCOUNT:
        {
          GtkTreeModel *model;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (tview));
          return w32tview_get_count (model);
        }
      case TVM_GETINDENT:
        return 1;
      case TVM_SETINDENT:
        return TRUE;
      case TVM_GETIMAGELIST:
        return GPOINTER_TO_INT (NULL);
      case TVM_SETIMAGELIST:
        return GPOINTER_TO_INT (NULL);
      case TVM_GETNEXTITEM:
        {
          GtkTreeModel *model;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (tview));
          if (wParam == TVGN_ROOT || wParam == TVGN_FIRSTVISIBLE)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_get_iter_first (model, &iter))
                {
                  guint item;

                  gtk_tree_model_get (model, &iter, TVIEW_ITEM, &item, -1);
                  return item;
                }
            }
          else if (wParam == TVGN_CARET)
            {
              GtkTreeIter iter;
              GtkTreeSelection *select;

              select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tview));
              if (gtk_tree_selection_get_selected (select, NULL, &iter))
                {
                  guint item;

                  gtk_tree_model_get (model, &iter, TVIEW_ITEM, &item, -1);
                  return item;
                }
            }
          else if (lParam)
            {
              GtkTreeIter *i;

              i = w32tview_get_iter_from_item (model, lParam);
              if (i)
                {
                  guint item = 0;

                  switch (wParam)
                    {
                      case TVGN_NEXT:
                      case TVGN_NEXTVISIBLE:
                        if (gtk_tree_model_iter_next (model, i))
                          gtk_tree_model_get (model, i, TVIEW_ITEM, &item, -1);
                        break;
                      case TVGN_PREVIOUS:
                      case TVGN_PREVIOUSVISIBLE:
                        {
                          GtkTreePath *path;

                          path = gtk_tree_model_get_path (model, i);
                          if (path)
                            {
                              if (gtk_tree_path_prev (path))
                                {
                                  GtkTreeIter iter;

                                  if (gtk_tree_model_get_iter (model, &iter,
                                                                        path))
                                    gtk_tree_model_get (model, &iter,
                                                        TVIEW_ITEM, &item, -1);
                                }
                              gtk_tree_path_free (path);
                            }
                        }
                        break;
                      case TVGN_PARENT:
                        {
                          GtkTreeIter iter;

                          if (gtk_tree_model_iter_parent (model, &iter, i))
                            gtk_tree_model_get (model, &iter,
                                                        TVIEW_ITEM, &item, -1);
                        }
                        break;
                      case TVGN_CHILD:
                        {
                          GtkTreeIter iter;

                          if (gtk_tree_model_iter_children (model, &iter, i))
                            gtk_tree_model_get (model, &iter,
                                                        TVIEW_ITEM, &item, -1);
                        }
                    }
                  gtk_tree_iter_free (i);
                  return item;
                }
            }
        }
        return GPOINTER_TO_INT (NULL);
      case TVM_SELECTITEM:
        if (wParam == TVGN_CARET)
          {
            GtkTreeIter *iter;
            GtkTreeModel *model;

            model = gtk_tree_view_get_model (GTK_TREE_VIEW (tview));
            iter = w32tview_get_iter_from_item (model, lParam);
            if (iter)
              {
                GtkTreeSelection *select;

                select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tview));
                gtk_tree_selection_select_iter (select, iter);
                gtk_tree_iter_free (iter);
                return TRUE;
              }
          }
        else if (wParam == TVGN_FIRSTVISIBLE)
          {
            return w32tview_DefWindowProc (hWnd, TVM_ENSUREVISIBLE, 0, lParam);
          }
        return FALSE;
      case TVM_GETITEMA:
        if (lParam)
          {
            GtkTreeIter *iter;
            GtkTreeModel *model;
            LRESULT lResult = FALSE;
            TV_ITEMA *tvi;

            tvi = GINT_TO_POINTER (lParam);
            model = gtk_tree_view_get_model (GTK_TREE_VIEW (tview));
            iter = w32tview_get_iter_from_item (model,
                                                GPOINTER_TO_UINT (tvi->hItem));
            if (iter)
              {
                gboolean expanded;
                gchar *utf8str;
                gint param;

                lResult = TRUE;
                gtk_tree_model_get (model, iter, TVIEW_EXPANDED, &expanded,
                            TVIEW_TEXT, &utf8str, TVIEW_LPARAM, &param, -1);
                if (tvi->mask & TVIF_STATE)
                  {
                    GtkTreePath *path;
                    GtkTreeSelection *select;

                    select = gtk_tree_view_get_selection
                                                    (GTK_TREE_VIEW (tview));
                    tvi->state = (gtk_tree_selection_iter_is_selected
                                            (select, iter) ? TVIS_SELECTED : 0)
                                        | (expanded ? TVIS_EXPANDEDONCE : 0);
                    tvi->stateMask = LVIS_SELECTED | TVIS_EXPANDEDONCE;
                    path = gtk_tree_model_get_path (model, iter);
                    if (path)
                      {
                        if (gtk_tree_view_row_expanded
                                                (GTK_TREE_VIEW (tview), path))
                          tvi->state |= TVIS_EXPANDED;
                        tvi->stateMask |= TVIS_EXPANDED;
                        gtk_tree_path_free (path);
                      }
                  }
                if (tvi->mask & TVIF_TEXT)
                  {
                    gchar *mb;

                    mb = tvi->pszText && tvi->cchTextMax > 0
                                        ? w32ldr_utf8_to_mb (utf8str) : NULL;
                    if (mb)
                      {
                        g_strncpy (tvi->pszText, mb, tvi->cchTextMax);
                        g_free (mb);
                      }
                    else
                      {
                        if (tvi->pszText && tvi->cchTextMax > 0)
                          tvi->pszText[0] = '\0';
                        tvi->mask &= ~TVIF_TEXT;
                        lResult = FALSE;
                      }
                  }
                if (tvi->mask & TVIF_IMAGE)
                  {
                    tvi->iImage = 0;
                    tvi->mask &= ~TVIF_IMAGE;
                    lResult = FALSE;
                  }
                if (tvi->mask & TVIF_SELECTEDIMAGE)
                  {
                    tvi->iSelectedImage = 0;
                    tvi->mask &= ~TVIF_SELECTEDIMAGE;
                    lResult = FALSE;
                  }
                if (tvi->mask & TVIF_CHILDREN)
                  tvi->cChildren = gtk_tree_model_iter_n_children
                                                    (model, iter) > 0 ? 1 : 0;
                if (tvi->mask & TVIF_PARAM)
                  tvi->lParam = param;
                g_free (utf8str);
              }
            return lResult;
          }
        return FALSE;
      case TVM_GETITEMW:
        if (lParam)
          {
            GtkTreeIter *iter;
            GtkTreeModel *model;
            LRESULT lResult = FALSE;
            TV_ITEMW *tvi;

            tvi = GINT_TO_POINTER (lParam);
            model = gtk_tree_view_get_model (GTK_TREE_VIEW (tview));
            iter = w32tview_get_iter_from_item (model,
                                                GPOINTER_TO_UINT (tvi->hItem));
            if (iter)
              {
                gboolean expanded;
                gchar *utf8str;
                gint param;

                lResult = TRUE;
                gtk_tree_model_get (model, iter, TVIEW_EXPANDED, &expanded,
                            TVIEW_TEXT, &utf8str, TVIEW_LPARAM, &param, -1);
                if (tvi->mask & TVIF_STATE)
                  {
                    GtkTreePath *path;
                    GtkTreeSelection *select;

                    select = gtk_tree_view_get_selection
                                                    (GTK_TREE_VIEW (tview));
                    tvi->state = (gtk_tree_selection_iter_is_selected
                                            (select, iter) ? TVIS_SELECTED : 0)
                                        | (expanded ? TVIS_EXPANDEDONCE : 0);
                    tvi->stateMask = LVIS_SELECTED | TVIS_EXPANDEDONCE;
                    path = gtk_tree_model_get_path (model, iter);
                    if (path)
                      {
                        if (gtk_tree_view_row_expanded
                                                (GTK_TREE_VIEW (tview), path))
                          tvi->state |= TVIS_EXPANDED;
                        tvi->stateMask |= TVIS_EXPANDED;
                        gtk_tree_path_free (path);
                      }
                  }
                if (tvi->mask & TVIF_TEXT)
                  {
                    gunichar2 *wc;

                    wc = utf8str && tvi->pszText && tvi->cchTextMax > 0
                            ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL)
                            : NULL;
                    if (wc)
                      {
                        lstrcpynW (tvi->pszText, wc, tvi->cchTextMax);
                        g_free (wc);
                      }
                    else
                      {
                        if (tvi->pszText && tvi->cchTextMax > 0)
                          tvi->pszText[0] = '\0';
                        tvi->mask &= ~TVIF_TEXT;
                        lResult = FALSE;
                      }
                  }
                if (tvi->mask & TVIF_IMAGE)
                  {
                    tvi->iImage = 0;
                    tvi->mask &= ~TVIF_IMAGE;
                    lResult = FALSE;
                  }
                if (tvi->mask & TVIF_SELECTEDIMAGE)
                  {
                    tvi->iSelectedImage = 0;
                    tvi->mask &= ~TVIF_SELECTEDIMAGE;
                    lResult = FALSE;
                  }
                if (tvi->mask & TVIF_CHILDREN)
                  tvi->cChildren = gtk_tree_model_iter_n_children
                                                    (model, iter) > 0 ? 1 : 0;
                if (tvi->mask & TVIF_PARAM)
                  tvi->lParam = param;
                g_free (utf8str);
              }
            return lResult;
          }
        return FALSE;
      case TVM_SETITEMA:
        if (lParam)
          {
            GtkTreeIter *iter;
            GtkTreeStore *store;
            LRESULT lResult = FALSE;
            TV_ITEMA *tvi;

            tvi = GINT_TO_POINTER (lParam);
            store = GTK_TREE_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (tview)));
            iter = w32tview_get_iter_from_item (GTK_TREE_MODEL (store),
                                                GPOINTER_TO_UINT (tvi->hItem));
            if (iter)
              {
                gboolean expanded;

                lResult = TRUE;
                gtk_tree_model_get (GTK_TREE_MODEL (store), iter,
                                                TVIEW_EXPANDED, &expanded, -1);
                if (tvi->mask & TVIF_STATE)
                  {
                    if (tvi->stateMask & LVIS_SELECTED)
                      {
                        GtkTreeSelection *select;

                        select = gtk_tree_view_get_selection
                                                    (GTK_TREE_VIEW (tview));
                        if (tvi->state & LVIS_SELECTED)
                          gtk_tree_selection_select_iter (select, iter);
                        else
                          gtk_tree_selection_unselect_iter (select, iter);
                      }
                    if (tvi->stateMask & TVIS_EXPANDED)
                      {
                        GtkTreePath *path;

                        path = gtk_tree_model_get_path (GTK_TREE_MODEL (store),
                                                                        iter);
                        if (path)
                          {
                            lResult = lResult && (tvi->state & TVIS_EXPANDED
                                ? gtk_tree_view_expand_row
                                        (GTK_TREE_VIEW (tview), path, FALSE)
                                : gtk_tree_view_collapse_row
                                        (GTK_TREE_VIEW (tview), path));
                            gtk_tree_path_free (path);
                          }
                        else
                          {
                            lResult = FALSE;
                          }
                      }
                    if (tvi->stateMask & TVIS_EXPANDEDONCE)
                      {
                        if (!(tvi->state & TVIS_EXPANDEDONCE) && expanded)
                          gtk_tree_model_ref_node (GTK_TREE_MODEL (store),
                                                                        iter);
                        if ((tvi->state & TVIS_EXPANDEDONCE) && !expanded)
                          gtk_tree_model_unref_node (GTK_TREE_MODEL (store),
                                                                        iter);
                        expanded = tvi->state & TVIS_EXPANDEDONCE;
                        gtk_tree_store_set (store, iter, TVIEW_EXPANDED,
                                                                expanded, -1);
                      }
                  }
                if (tvi->mask & TVIF_TEXT)
                  {
                    gchar *utf8str;

                    utf8str = w32ldr_utf8_from_mb (tvi->pszText);
                    gtk_tree_store_set (store, iter, TVIEW_TEXT, utf8str, -1);
                    g_free (utf8str);
                  }
                if (tvi->mask & (TVIF_IMAGE | TVIF_SELECTEDIMAGE))
                  lResult = FALSE;
                if ((tvi->mask & TVIF_CHILDREN) && expanded
                                    && tvi->cChildren > 0
                                    && gtk_tree_model_iter_n_children
                                        (GTK_TREE_MODEL (store), iter) <= 0)
                  {
                    gtk_tree_model_ref_node (GTK_TREE_MODEL (store), iter);
                    gtk_tree_store_set (store, iter, TVIEW_EXPANDED,
                                                                    FALSE, -1);
                    expanded = FALSE;
                  }
                if (tvi->mask & TVIF_PARAM)
                  gtk_tree_store_set (store, iter, TVIEW_LPARAM,
                                                            tvi->lParam, -1);
              }
            return lResult;
          }
        return FALSE;
      case TVM_SETITEMW:
        if (lParam)
          {
            GtkTreeIter *iter;
            GtkTreeStore *store;
            LRESULT lResult = FALSE;
            TV_ITEMW *tvi;

            tvi = GINT_TO_POINTER (lParam);
            store = GTK_TREE_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (tview)));
            iter = w32tview_get_iter_from_item (GTK_TREE_MODEL (store),
                                                GPOINTER_TO_UINT (tvi->hItem));
            if (iter)
              {
                gboolean expanded;

                lResult = TRUE;
                gtk_tree_model_get (GTK_TREE_MODEL (store), iter,
                                                TVIEW_EXPANDED, &expanded, -1);
                if (tvi->mask & TVIF_STATE)
                  {
                    if (tvi->stateMask & LVIS_SELECTED)
                      {
                        GtkTreeSelection *select;

                        select = gtk_tree_view_get_selection
                                                    (GTK_TREE_VIEW (tview));
                        if (tvi->state & LVIS_SELECTED)
                          gtk_tree_selection_select_iter (select, iter);
                        else
                          gtk_tree_selection_unselect_iter (select, iter);
                      }
                    if (tvi->stateMask & TVIS_EXPANDED)
                      {
                        GtkTreePath *path;

                        path = gtk_tree_model_get_path (GTK_TREE_MODEL (store),
                                                                        iter);
                        if (path)
                          {
                            lResult = lResult && (tvi->state & TVIS_EXPANDED
                                ? gtk_tree_view_expand_row
                                        (GTK_TREE_VIEW (tview), path, FALSE)
                                : gtk_tree_view_collapse_row
                                        (GTK_TREE_VIEW (tview), path));
                            gtk_tree_path_free (path);
                          }
                        else
                          {
                            lResult = FALSE;
                          }
                      }
                    if (tvi->stateMask & TVIS_EXPANDEDONCE)
                      {
                        if (!(tvi->state & TVIS_EXPANDEDONCE) && expanded)
                          gtk_tree_model_ref_node (GTK_TREE_MODEL (store),
                                                                        iter);
                        if ((tvi->state & TVIS_EXPANDEDONCE) && !expanded)
                          gtk_tree_model_unref_node (GTK_TREE_MODEL (store),
                                                                        iter);
                        expanded = tvi->state & TVIS_EXPANDEDONCE;
                        gtk_tree_store_set (store, iter, TVIEW_EXPANDED,
                                                                expanded, -1);
                      }
                  }
                if (tvi->mask & TVIF_TEXT)
                  {
                    gchar *utf8str;

                    utf8str = tvi->pszText ? g_utf16_to_utf8
                                (tvi->pszText, -1, NULL, NULL, NULL) : NULL;
                    gtk_tree_store_set (store, iter, TVIEW_TEXT, utf8str, -1);
                    g_free (utf8str);
                  }
                if (tvi->mask & (TVIF_IMAGE | TVIF_SELECTEDIMAGE))
                  lResult = FALSE;
                if ((tvi->mask & TVIF_CHILDREN) && expanded
                                    && tvi->cChildren > 0
                                    && gtk_tree_model_iter_n_children
                                        (GTK_TREE_MODEL (store), iter) <= 0)
                  {
                    gtk_tree_model_ref_node (GTK_TREE_MODEL (store), iter);
                    gtk_tree_store_set (store, iter, TVIEW_EXPANDED,
                                                                    FALSE, -1);
                    expanded = FALSE;
                  }
                if (tvi->mask & TVIF_PARAM)
                  gtk_tree_store_set (store, iter, TVIEW_LPARAM,
                                                            tvi->lParam, -1);
              }
            return lResult;
          }
        return FALSE;
      case TVM_EDITLABELA:
        return GPOINTER_TO_INT (NULL);
      case TVM_EDITLABELW:
        return GPOINTER_TO_INT (NULL);
      case TVM_GETEDITCONTROL:
        return GPOINTER_TO_INT (NULL);
      case TVM_GETVISIBLECOUNT:
        return w32tview_DefWindowProc (hWnd, TVM_GETCOUNT, wParam, lParam);
      case TVM_HITTEST:
        if (lParam)
          {
            GtkTreePath *path;
            TV_HITTESTINFO *tvhi;

            tvhi = GINT_TO_POINTER (lParam);
            tvhi->flags = TVHT_NOWHERE;
            tvhi->hItem = NULL;
            if (gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW (tview),
                            tvhi->pt.x, tvhi->pt.y, &path, NULL, NULL, NULL))
              {
                GtkTreeIter iter;
                GtkTreeModel *model;

                model = gtk_tree_view_get_model (GTK_TREE_VIEW (tview));
                if (gtk_tree_model_get_iter (model, &iter, path))
                  {
                    tvhi->flags = TVHT_ONITEM;
                    gtk_tree_model_get (model, &iter,
                                                TVIEW_ITEM, &tvhi->hItem, -1);
                  }
                gtk_tree_path_free (path);
              }
            return GPOINTER_TO_INT (tvhi->hItem);
          }
        return GPOINTER_TO_INT (NULL);
      case TVM_CREATEDRAGIMAGE:
        return GPOINTER_TO_INT (NULL);
      case TVM_SORTCHILDREN:
#if GTK_CHECK_VERSION(2,2,0)
        if (lParam)
          {
            gint i;
            GtkTreeIter *parent;
            GtkTreeStore *store;

            store = GTK_TREE_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (tview)));
            parent = w32tview_get_iter_from_item (GTK_TREE_MODEL (store),
                                                                    lParam);
            for (i = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (store),
                                                    parent) - 1; i > 0; i--)
              {
                gint j;
                gchar *text1;
                GtkTreeIter iter1;

                if (!gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                            &iter1, parent, 0))
                  {
                    if (parent)
                      gtk_tree_iter_free (parent);
                    return FALSE;
                  }
                gtk_tree_model_get (GTK_TREE_MODEL (store), &iter1,
                                                    TVIEW_TEXT, &text1, -1);
                for (j = 1; j <= i; j++)
                  {
                    gchar *text2;
                    GtkTreeIter iter2;

                    if (!gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                            &iter2, parent, j))
                      return FALSE;
                    gtk_tree_model_get (GTK_TREE_MODEL (store), &iter2,
                                                    TVIEW_TEXT, &text2, -1);
                    if (g_strcmp (text1, text2) > 0)
                      {
                        gtk_tree_store_swap (store, &iter1, &iter2);
                        g_free (text2);
                      }
                    else
                      {
                        g_free (text1);
                        text1 = text2;
                        iter1 = iter2;
                      }
                  }
                g_free (text1);
              }
            if (parent)
              gtk_tree_iter_free (parent);
            return TRUE;
          }
        return FALSE;
#else /* not GTK_CHECK_VERSION(2,2,0) */
        return TRUE;
#endif /* not GTK_CHECK_VERSION(2,2,0) */
      case TVM_ENSUREVISIBLE:
        {
          GtkTreeIter *iter;
          GtkTreeModel *model;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (tview));
          iter = w32tview_get_iter_from_item (model, lParam);
          if (iter)
            {
              GtkTreePath *path;

              path = gtk_tree_model_get_path (model, iter);
              gtk_tree_iter_free (iter);
              if (path)
                {
                  gtk_tree_view_expand_row (GTK_TREE_VIEW (tview),
                                                                path, FALSE);
                  gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW (tview),
                                                    path, NULL, FALSE, 0, 0);
                  gtk_tree_path_free (path);
                  return TRUE;
                }
            }
        }
        return FALSE;
      case TVM_SORTCHILDRENCB:
#if GTK_CHECK_VERSION(2,2,0)
        if (lParam)
          {
            gint i;
            GtkTreeIter *parent;
            GtkTreeStore *store;
            TV_SORTCB *psort;

            psort = GINT_TO_POINTER (lParam);
            store = GTK_TREE_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (tview)));
            parent = w32tview_get_iter_from_item (GTK_TREE_MODEL (store),
                                            GPOINTER_TO_UINT (psort->hParent));
            for (i = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (store),
                                                    parent) - 1; i > 0; i--)
              {
                gint j;
                GtkTreeIter iter1;
                LPARAM lParam1;

                if (!gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                            &iter1, parent, 0))
                  {
                    if (parent)
                      gtk_tree_iter_free (parent);
                    return FALSE;
                  }
                gtk_tree_model_get (GTK_TREE_MODEL (store), &iter1,
                                                TVIEW_LPARAM, &lParam1, -1);
                for (j = 1; j <= i; j++)
                  {
                    GtkTreeIter iter2;
                    LPARAM lParam2;

                    if (!gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                            &iter2, parent, j))
                      return FALSE;
                    gtk_tree_model_get (GTK_TREE_MODEL (store), &iter2,
                                                TVIEW_LPARAM, &lParam2, -1);
                    if (psort->lpfnCompare (lParam1, lParam2,
                                                            psort->lParam) > 0)
                      {
                        gtk_tree_store_swap (store, &iter1, &iter2);
                      }
                    else
                      {
                        iter1 = iter2;
                        lParam1 = lParam2;
                      }
                  }
              }
            if (parent)
              gtk_tree_iter_free (parent);
            return TRUE;
          }
        return FALSE;
#else /* not GTK_CHECK_VERSION(2,2,0) */
        return TRUE;
#endif /* not GTK_CHECK_VERSION(2,2,0) */
      case TVM_ENDEDITLABELNOW:
        return TRUE;
      case TVM_GETISEARCHSTRINGA:
        if (lParam)
          {
            gchar *mb;

            mb = GINT_TO_POINTER (lParam);
            mb[0] = '\0';
          }
        return 0;
      case TVM_GETISEARCHSTRINGW:
        if (lParam)
          {
            gunichar2 *wc;

            wc = GINT_TO_POINTER (lParam);
            wc[0] = '\0';
          }
        return 0;
    }
  return wd->widechar ? DefWindowProcW (hWnd, Msg, wParam, lParam)
                       : DefWindowProcA (hWnd, Msg, wParam, lParam);
}


/* ja:列が削除されたとき */
static void
w32tview_row_deleted (GtkTreeModel *model,
                      GtkTreePath  *path,
                      GtkWidget    *widget)
{
  GtkTreeIter iter;

  if (gtk_tree_model_get_iter (model, &iter, path))
    {
      gint param;
      guint item;
      W32LdrWindowData *wd;

      wd = g_object_get_data (G_OBJECT (widget), "user_data");
      gtk_tree_model_get (model, &iter,
                                TVIEW_ITEM, &item, TVIEW_LPARAM, &param, -1);
      if (wd->widechar)
        {
          NM_TREEVIEWW nmt;

          nmt.hdr.hwndFrom = widget;
          nmt.hdr.idFrom = wd->wID;
          nmt.hdr.code = TVN_DELETEITEMW;
          nmt.action = 0;
          nmt.itemOld.mask = TVIF_HANDLE | TVIF_PARAM;
          nmt.itemOld.hItem = GINT_TO_POINTER (item);
          nmt.itemOld.state = 0;
          nmt.itemOld.stateMask = 0;
          nmt.itemOld.pszText = NULL;
          nmt.itemOld.cchTextMax = 0;
          nmt.itemOld.iImage = 0;
          nmt.itemOld.iSelectedImage = 0;
          nmt.itemOld.cChildren = 0;
          nmt.itemOld.lParam = param;
          nmt.itemNew.mask = 0;
          nmt.itemNew.hItem = NULL;
          nmt.itemNew.state = 0;
          nmt.itemNew.stateMask = 0;
          nmt.itemNew.pszText = NULL;
          nmt.itemNew.cchTextMax = 0;
          nmt.itemNew.iImage = 0;
          nmt.itemNew.iSelectedImage = 0;
          nmt.itemNew.cChildren = 0;
          nmt.itemNew.lParam = 0;
          nmt.ptDrag.x = 0;
          nmt.ptDrag.y = 0;
          SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
        }
      else
        {
          NM_TREEVIEWA nmt;

          nmt.hdr.hwndFrom = widget;
          nmt.hdr.idFrom = wd->wID;
          nmt.hdr.code = TVN_DELETEITEMA;
          nmt.action = 0;
          nmt.itemOld.mask = TVIF_HANDLE | TVIF_PARAM;
          nmt.itemOld.hItem = GINT_TO_POINTER (item);
          nmt.itemOld.state = 0;
          nmt.itemOld.stateMask = 0;
          nmt.itemOld.pszText = NULL;
          nmt.itemOld.cchTextMax = 0;
          nmt.itemOld.iImage = 0;
          nmt.itemOld.iSelectedImage = 0;
          nmt.itemOld.cChildren = 0;
          nmt.itemOld.lParam = param;
          nmt.itemNew.mask = 0;
          nmt.itemNew.hItem = NULL;
          nmt.itemNew.state = 0;
          nmt.itemNew.stateMask = 0;
          nmt.itemNew.pszText = NULL;
          nmt.itemNew.cchTextMax = 0;
          nmt.itemNew.iImage = 0;
          nmt.itemNew.iSelectedImage = 0;
          nmt.itemNew.cChildren = 0;
          nmt.itemNew.lParam = 0;
          nmt.ptDrag.x = 0;
          nmt.ptDrag.y = 0;
          SendMessageA (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
        }
    }
}


/* ja:選択が変化したとき */
static void
w32tview_changed (GtkTreeSelection *select,
                  gpointer          user_data)
{
  gboolean expand = FALSE, expanded = FALSE;
  gint param = 0;
  guint item = 0;
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkWidget *tview;
  W32LdrWindowData *wd;

  tview = GTK_WIDGET (gtk_tree_selection_get_tree_view (select));
  if (gtk_tree_selection_get_selected (select, &model, &iter))
    {
      GtkTreePath *path;

      gtk_tree_model_get (model, &iter, TVIEW_LPARAM, &param,
                            TVIEW_ITEM, &item, TVIEW_EXPANDED, &expanded, -1);
      path = gtk_tree_model_get_path (model, &iter);
      expand = gtk_tree_view_row_expanded (GTK_TREE_VIEW (tview), path);
      gtk_tree_path_free (path);
    }
  wd = g_object_get_data (G_OBJECT (tview), "user_data");
  if (wd->widechar)
    {
      NM_TREEVIEWW nmt;

      nmt.hdr.hwndFrom = tview;
      nmt.hdr.idFrom = wd->wID;
      nmt.hdr.code = TVN_SELCHANGINGW;
      nmt.action = 0;
      nmt.itemOld.mask = 0;
      nmt.itemOld.hItem = 0;
      nmt.itemOld.state = 0;
      nmt.itemOld.stateMask = 0;
      nmt.itemOld.pszText = NULL;
      nmt.itemOld.cchTextMax = 0;
      nmt.itemOld.iImage = 0;
      nmt.itemOld.iSelectedImage = 0;
      nmt.itemOld.cChildren = 0;
      nmt.itemOld.lParam = 0;
      nmt.itemNew.mask = item ? TVIF_HANDLE | TVIF_STATE | TVIF_PARAM : 0;
      nmt.itemNew.hItem = GINT_TO_POINTER (item);
      nmt.itemNew.state = (item ? TVIS_SELECTED : 0)
                                        | (expand ? TVIS_EXPANDED : 0)
                                        | (expanded ? TVIS_EXPANDEDONCE : 0);
      nmt.itemNew.stateMask = (item ? TVIS_SELECTED
                                    | TVIS_EXPANDED | TVIS_EXPANDEDONCE : 0);
      nmt.itemNew.pszText = NULL;
      nmt.itemNew.cchTextMax = 0;
      nmt.itemNew.iImage = 0;
      nmt.itemNew.iSelectedImage = 0;
      nmt.itemNew.cChildren = 0;
      nmt.itemNew.lParam = param;
      nmt.ptDrag.x = 0;
      nmt.ptDrag.y = 0;
      SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
      nmt.hdr.code = TVN_SELCHANGEDW;
      SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
    }
  else
    {
      NM_TREEVIEWA nmt;

      nmt.hdr.hwndFrom = tview;
      nmt.hdr.idFrom = wd->wID;
      nmt.hdr.code = TVN_SELCHANGINGA;
      nmt.action = 0;
      nmt.itemOld.mask = 0;
      nmt.itemOld.hItem = 0;
      nmt.itemOld.state = 0;
      nmt.itemOld.stateMask = 0;
      nmt.itemOld.pszText = NULL;
      nmt.itemOld.cchTextMax = 0;
      nmt.itemOld.iImage = 0;
      nmt.itemOld.iSelectedImage = 0;
      nmt.itemOld.cChildren = 0;
      nmt.itemOld.lParam = 0;
      nmt.itemNew.mask = item ? TVIF_HANDLE | TVIF_STATE | TVIF_PARAM : 0;
      nmt.itemNew.hItem = GINT_TO_POINTER (item);
      nmt.itemNew.state = (item ? TVIS_SELECTED : 0)
                                        | (expand ? TVIS_EXPANDED : 0)
                                        | (expanded ? TVIS_EXPANDEDONCE : 0);
      nmt.itemNew.stateMask = (item ? TVIS_SELECTED
                                    | TVIS_EXPANDED | TVIS_EXPANDEDONCE : 0);
      nmt.itemNew.pszText = NULL;
      nmt.itemNew.cchTextMax = 0;
      nmt.itemNew.iImage = 0;
      nmt.itemNew.iSelectedImage = 0;
      nmt.itemNew.cChildren = 0;
      nmt.itemNew.lParam = param;
      nmt.ptDrag.x = 0;
      nmt.ptDrag.y = 0;
      SendMessageA (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
      nmt.hdr.code = TVN_SELCHANGEDA;
      SendMessageA (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
    }
}


/* ja:縮小されるとき */
static gboolean
w32tview_test_collapse_row (GtkTreeView *tview,
                            GtkTreeIter *iter,
                            GtkTreePath *path,
                            gpointer     user_data)
{
  gboolean collapse;
  gint param;
  guint item;
  GtkTreeModel *model;
  GtkTreeSelection *select;
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (tview), "user_data");
  select = gtk_tree_view_get_selection (tview);
  model = gtk_tree_view_get_model (tview);
  gtk_tree_model_get (model, iter,
                                TVIEW_ITEM, &item, TVIEW_LPARAM, &param, -1);
  if (wd->widechar)
    {
      NM_TREEVIEWW nmt;

      nmt.hdr.hwndFrom = GTK_WIDGET (tview);
      nmt.hdr.idFrom = wd->wID;
      nmt.hdr.code = TVN_ITEMEXPANDINGW;
      nmt.action = TVE_COLLAPSE;
      nmt.itemOld.mask = 0;
      nmt.itemOld.hItem = 0;
      nmt.itemOld.state = 0;
      nmt.itemOld.stateMask = 0;
      nmt.itemOld.pszText = NULL;
      nmt.itemOld.cchTextMax = 0;
      nmt.itemOld.iImage = 0;
      nmt.itemOld.iSelectedImage = 0;
      nmt.itemOld.cChildren = 0;
      nmt.itemOld.lParam = 0;
      nmt.itemNew.mask = TVIF_HANDLE | TVIF_STATE | TVIF_PARAM;
      nmt.itemNew.hItem = GINT_TO_POINTER (item);
      nmt.itemNew.state = TVIS_EXPANDED | (gtk_tree_selection_iter_is_selected
                                        (select, iter) ? TVIS_SELECTED : 0);
      nmt.itemNew.stateMask = TVIS_SELECTED
                                        | TVIS_EXPANDED | TVIS_EXPANDEDONCE;
      nmt.itemNew.pszText = NULL;
      nmt.itemNew.cchTextMax = 0;
      nmt.itemNew.iImage = 0;
      nmt.itemNew.iSelectedImage = 0;
      nmt.itemNew.cChildren = 0;
      nmt.itemNew.lParam = param;
      nmt.ptDrag.x = 0;
      nmt.ptDrag.y = 0;
      collapse = !SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
      if (collapse)
        {
          nmt.hdr.code = TVN_ITEMEXPANDEDW;
          nmt.itemNew.state &= ~TVIS_EXPANDED;
          SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
        }
    }
  else
    {
      NM_TREEVIEWA nmt;

      nmt.hdr.hwndFrom = GTK_WIDGET (tview);
      nmt.hdr.idFrom = wd->wID;
      nmt.hdr.code = TVN_ITEMEXPANDINGA;
      nmt.action = TVE_COLLAPSE;
      nmt.itemOld.mask = 0;
      nmt.itemOld.hItem = 0;
      nmt.itemOld.state = 0;
      nmt.itemOld.stateMask = 0;
      nmt.itemOld.pszText = NULL;
      nmt.itemOld.cchTextMax = 0;
      nmt.itemOld.iImage = 0;
      nmt.itemOld.iSelectedImage = 0;
      nmt.itemOld.cChildren = 0;
      nmt.itemOld.lParam = 0;
      nmt.itemNew.mask = TVIF_HANDLE | TVIF_STATE | TVIF_PARAM;
      nmt.itemNew.hItem = GINT_TO_POINTER (item);
      nmt.itemNew.state = TVIS_EXPANDED | (gtk_tree_selection_iter_is_selected
                                        (select, iter) ? TVIS_SELECTED : 0);
      nmt.itemNew.stateMask = TVIS_SELECTED
                                        | TVIS_EXPANDED | TVIS_EXPANDEDONCE;
      nmt.itemNew.pszText = NULL;
      nmt.itemNew.cchTextMax = 0;
      nmt.itemNew.iImage = 0;
      nmt.itemNew.iSelectedImage = 0;
      nmt.itemNew.cChildren = 0;
      nmt.itemNew.lParam = param;
      nmt.ptDrag.x = 0;
      nmt.ptDrag.y = 0;
      collapse = !SendMessageA (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
      if (collapse)
        {
          nmt.hdr.code = TVN_ITEMEXPANDEDA;
          nmt.itemNew.state &= ~TVIS_EXPANDED;
          SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
        }
    }
  return collapse;
}


/* ja:展開されるとき */
static gboolean
w32tview_test_expand_row (GtkTreeView *tview,
                          GtkTreeIter *iter,
                          GtkTreePath *path,
                          gpointer     user_data)
{
  gboolean expanded;
  gint param;
  guint item;
  GtkTreeSelection *select;
  GtkTreeStore *store;
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (tview), "user_data");
  select = gtk_tree_view_get_selection (tview);
  store = GTK_TREE_STORE (gtk_tree_view_get_model (tview));
  gtk_tree_model_get (GTK_TREE_MODEL (store), iter, TVIEW_ITEM, &item,
                        TVIEW_EXPANDED, &expanded, TVIEW_LPARAM, &param, -1);
  if (!expanded)
    {
      GtkTreeSelection *select;

      select = gtk_tree_view_get_selection (tview);
      if (wd->widechar)
        {
          NM_TREEVIEWW nmt;

          nmt.hdr.hwndFrom = GTK_WIDGET (tview);
          nmt.hdr.idFrom = wd->wID;
          nmt.hdr.code = TVN_ITEMEXPANDINGW;
          nmt.action = TVE_EXPAND;
          nmt.itemOld.mask = 0;
          nmt.itemOld.hItem = 0;
          nmt.itemOld.state = 0;
          nmt.itemOld.stateMask = 0;
          nmt.itemOld.pszText = NULL;
          nmt.itemOld.cchTextMax = 0;
          nmt.itemOld.iImage = 0;
          nmt.itemOld.iSelectedImage = 0;
          nmt.itemOld.cChildren = 0;
          nmt.itemOld.lParam = 0;
          nmt.itemNew.mask = TVIF_HANDLE | TVIF_STATE | TVIF_PARAM;
          nmt.itemNew.hItem = GINT_TO_POINTER (item);
          nmt.itemNew.state = gtk_tree_selection_iter_is_selected
                                            (select, iter) ? TVIS_SELECTED : 0;
          nmt.itemNew.stateMask = TVIS_SELECTED
                                        | TVIS_EXPANDED | TVIS_EXPANDEDONCE;
          nmt.itemNew.pszText = NULL;
          nmt.itemNew.cchTextMax = 0;
          nmt.itemNew.iImage = 0;
          nmt.itemNew.iSelectedImage = 0;
          nmt.itemNew.cChildren = 0;
          nmt.itemNew.lParam = param;
          nmt.ptDrag.x = 0;
          nmt.ptDrag.y = 0;
          expanded = !SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
          if (expanded)
            {
              gtk_tree_store_set (store, iter, TVIEW_EXPANDED, TRUE, -1);
              nmt.hdr.code = TVN_ITEMEXPANDEDW;
              nmt.itemNew.state |= TVIS_EXPANDED | TVIS_EXPANDEDONCE;
              SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
            }
        }
      else
        {
          NM_TREEVIEWA nmt;

          nmt.hdr.hwndFrom = GTK_WIDGET (tview);
          nmt.hdr.idFrom = wd->wID;
          nmt.hdr.code = TVN_ITEMEXPANDINGA;
          nmt.action = TVE_EXPAND;
          nmt.itemOld.mask = 0;
          nmt.itemOld.hItem = 0;
          nmt.itemOld.state = 0;
          nmt.itemOld.stateMask = 0;
          nmt.itemOld.pszText = NULL;
          nmt.itemOld.cchTextMax = 0;
          nmt.itemOld.iImage = 0;
          nmt.itemOld.iSelectedImage = 0;
          nmt.itemOld.cChildren = 0;
          nmt.itemOld.lParam = 0;
          nmt.itemNew.mask = TVIF_HANDLE | TVIF_STATE | TVIF_PARAM;
          nmt.itemNew.hItem = GINT_TO_POINTER (item);
          nmt.itemNew.state = gtk_tree_selection_iter_is_selected
                                            (select, iter) ? TVIS_SELECTED : 0;
          nmt.itemNew.stateMask = TVIS_SELECTED
                                        | TVIS_EXPANDED | TVIS_EXPANDEDONCE;
          nmt.itemNew.pszText = NULL;
          nmt.itemNew.cchTextMax = 0;
          nmt.itemNew.iImage = 0;
          nmt.itemNew.iSelectedImage = 0;
          nmt.itemNew.cChildren = 0;
          nmt.itemNew.lParam = param;
          nmt.ptDrag.x = 0;
          nmt.ptDrag.y = 0;
          expanded = !SendMessageA (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
          if (expanded)
            {
              gtk_tree_store_set (store, iter, TVIEW_EXPANDED, TRUE, -1);
              nmt.hdr.code = TVN_ITEMEXPANDEDA;
              nmt.itemNew.state |= TVIS_EXPANDED | TVIS_EXPANDEDONCE;
              SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmt));
            }
        }
    }
  return expanded;
}


/* ja:クリックされたとき */
static gboolean
w32tview_button_press_event (GtkWidget      *widget,
                             GdkEventButton *event,
                             gpointer        user_data)
{
  W32LdrWindowData *wd;
  NMHDR nmh;

  switch (event->type)
    {
      case GDK_BUTTON_PRESS:
        switch (event->button)
          {
            case 1: nmh.code = NM_CLICK; break;
            case 3: nmh.code = NM_RCLICK; break;
            default: return FALSE;
          }
        break;
      case GDK_2BUTTON_PRESS:
        switch (event->button)
          {
            case 1: nmh.code = NM_DBLCLK; break;
            case 3: nmh.code = NM_RDBLCLK; break;
            default: return FALSE;
          }
        break;
      default: return FALSE;
    }
  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  nmh.hwndFrom = widget;
  nmh.idFrom = wd->wID;
  if (wd->widechar)
    SendMessageW (wd->hWndParent, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
  else
    SendMessageA (wd->hWndParent, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
  return FALSE;
}


/* ja:フォーカス取得 */
static gboolean
w32tview_focus_in (GtkWidget     *widget,
                   GdkEventFocus *event,
                   gpointer       user_data)
{
  W32LdrWindowData *wd;
  NMHDR nmh;

  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  nmh.hwndFrom = widget;
  nmh.idFrom = wd->wID;
  nmh.code = NM_SETFOCUS;
  if (wd->widechar)
    SendMessageW (wd->hWndParent, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
  else
    SendMessageA (wd->hWndParent, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
  return FALSE;
}


/* ja:フォーカス喪失 */
static gboolean
w32tview_focus_out (GtkWidget     *widget,
                    GdkEventFocus *event,
                    gpointer       user_data)
{
  W32LdrWindowData *wd;
  NMHDR nmh;

  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  nmh.hwndFrom = widget;
  nmh.idFrom = wd->wID;
  nmh.code = NM_KILLFOCUS;
  if (wd->widechar)
    SendMessageW (wd->hWndParent, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
  else
    SendMessageA (wd->hWndParent, WM_NOTIFY, wd->wID, GPOINTER_TO_INT (&nmh));
  return FALSE;
}


/* ja:キーが押された */
static gboolean
w32tview_key_press_event (GtkWidget   *widget,
                          GdkEventKey *event,
                          gpointer     user_data)
{
  if (event->keyval == GDK_Return)
    {
      W32LdrWindowData *wd;
      NMHDR nmh;

      wd = g_object_get_data (G_OBJECT (widget), "user_data");
      nmh.hwndFrom = widget;
      nmh.idFrom = wd->wID;
      nmh.code = NM_RETURN;
      if (wd->widechar)
        SendMessageW (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmh));
      else
        SendMessageA (wd->hWndParent, WM_NOTIFY,
                                            wd->wID, GPOINTER_TO_INT (&nmh));
    }
  return FALSE;
}


GtkWidget *
w32ldr_control_create_tview (const gchar    *windowname,
                             const guint32   style,
                             const guint32   exstyle,
                             const gint      width,
                             const gint      height,
                             const guint16   id,
                             HWND            hWndParent,
                             HINSTANCE       hInstance,
                             const gboolean  widechar)
{
  GtkCellRenderer *renderer;
  GtkTreeSelection *select;
  GtkTreeStore *store;
  GtkTreeViewColumn *column;
  GtkWidget *tview, *scroll;
  W32LdrWindowData *wd;

  /* ja:リストビュー */
  store = gtk_tree_store_new (4, G_TYPE_UINT, G_TYPE_BOOLEAN,
                                                    G_TYPE_STRING, G_TYPE_INT);
  tview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (tview), FALSE);
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (tview), FALSE);
#if GTK_CHECK_VERSION(2,12,0)
  gtk_tree_view_set_show_expanders (GTK_TREE_VIEW (tview),
                                                    style & TVS_HASBUTTONS);
#endif /* GTK_CHECK_VERSION(2,12,0) */
#if GTK_CHECK_VERSION(2,10,0)
  gtk_tree_view_set_enable_tree_lines (GTK_TREE_VIEW (tview),
                                                        style & TVS_HASLINES);
  gtk_tree_view_set_grid_lines (GTK_TREE_VIEW (tview),
                        style & TVS_HASLINES ? GTK_TREE_VIEW_GRID_LINES_BOTH
                                             : GTK_TREE_VIEW_GRID_LINES_NONE);
#endif /* GTK_CHECK_VERSION(2,10,0) */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (NULL, renderer,
                                    "text", TVIEW_TEXT,
                                    "editable", style & TVS_EDITLABELS, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tview));
  gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
  g_signal_connect (G_OBJECT (store), "row-deleted",
                            G_CALLBACK (w32tview_row_deleted), tview);
  g_signal_connect (G_OBJECT (select), "changed",
                            G_CALLBACK (w32tview_changed), NULL);
  g_signal_connect (G_OBJECT (tview), "test-collapse-row",
                            G_CALLBACK (w32tview_test_collapse_row), NULL);
  g_signal_connect (G_OBJECT (tview), "test-expand-row",
                            G_CALLBACK (w32tview_test_expand_row), NULL);
  g_signal_connect (G_OBJECT (tview), "button-press-event",
                            G_CALLBACK (w32tview_button_press_event), NULL);
  g_signal_connect (G_OBJECT (tview), "focus-in-event",
                            G_CALLBACK (w32tview_focus_in), NULL);
  g_signal_connect (G_OBJECT (tview), "focus-out-event",
                            G_CALLBACK (w32tview_focus_out), NULL);
  g_signal_connect (G_OBJECT (tview), "key-press-event",
                            G_CALLBACK (w32tview_key_press_event), NULL);
  gtk_widget_add_events (tview, GDK_BUTTON_PRESS_MASK | GDK_FOCUS_CHANGE_MASK
                                                        | GDK_KEY_PRESS_MASK);
  g_object_unref (store);
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), tview);
  wd = g_malloc (sizeof (W32LdrWindowData));
  wd->dwStyle = style;
  wd->dwExStyle = exstyle;
  wd->hInstance = hInstance;
  wd->lpfnWndProc = w32tview_DefWindowProc;
  wd->hWndParent = hWndParent;
  wd->wID = id;
  wd->dwUserData = 0;
  wd->lpDialogFunc = NULL;
  wd->lResult = -1;
  wd->dwUser = 0;
  wd->csa = NULL;
  wd->csw = NULL;
  wd->dwInitParam = 0;
  wd->widechar = widechar;
  wd->resizable = TRUE;
  wd->classname = g_strdup ("SysTreeView32");
  wd->focus = tview;
  wd->child = NULL;
  g_object_set_data (G_OBJECT (scroll), "user_data", wd);
  return scroll;
}
