/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32private.h"
#include "kernel32.h"


static LRESULT WINAPI
w32list_DefWindowProc (HWND   hWnd,
                       UINT   Msg,
                       WPARAM wParam,
                       LPARAM lParam)
{
  GtkWidget *list;
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (hWnd), "user_data");
  if (!wd)
    return 0;
  list = gtk_bin_get_child (GTK_BIN (hWnd));
  switch (Msg)
    {
      case LB_ADDSTRING:
        return w32list_DefWindowProc (hWnd, LB_INSERTSTRING, -1, lParam);
      case LB_INSERTSTRING:
        {
          gchar *utf8str;
          gint count, position;
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (list)));
          count = w32list_DefWindowProc (hWnd, LB_GETCOUNT, 0, 0);
          position = wParam < 0 || count < wParam ? count : wParam;
          gtk_list_store_insert (store, &iter, position);
          utf8str = wd->widechar
            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1, NULL, NULL, NULL)
            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          gtk_list_store_set (store, &iter, 0, utf8str, 1, 0, -1);
          g_free (utf8str);
          return position;
        }
      case LB_DELETESTRING:
        {
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (list)));
          if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, wParam))
            {
              gtk_list_store_remove (store, &iter);
              return w32list_DefWindowProc (hWnd, LB_GETCOUNT, 0, 0);
            }
        }
        return LB_ERR;
      case LB_SELITEMRANGEEX:
        {
          gint i;
          GtkTreeIter iter;
          GtkTreeModel *model;
          GtkTreeSelection *select;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          select = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
          for (i = MIN (wParam, lParam); i <= MAX (wParam, lParam); i++)
            if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
              {
                if (wParam < lParam)
                  gtk_tree_selection_select_iter (select, &iter);
                else
                  gtk_tree_selection_unselect_iter (select, &iter);
              }
        }
        return LB_OKAY;
      case LB_RESETCONTENT:
        {
          GtkListStore *store;

          store = GTK_LIST_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (list)));
          gtk_list_store_clear (store);
        }
        return LB_OKAY;
      case LB_SETSEL:
        {
          GtkTreeSelection *select;

          select = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
          if (lParam < 0)
            {
              if (wParam)
                gtk_tree_selection_select_all (select);
              else
                gtk_tree_selection_unselect_all (select);
            }
          else
            {
              GtkTreeIter iter;
              GtkTreeModel *model;

              model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, lParam))
                {
                  if (wParam)
                    gtk_tree_selection_select_iter (select, &iter);
                  else
                    gtk_tree_selection_unselect_iter (select, &iter);
                }
              else
                {
                  return LB_ERR;
                }
            }
        }
        return LB_OKAY;
      case LB_SETCURSEL:
        {
          GtkTreeSelection *select;

          select = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
          if (wParam < 0)
            {
              gtk_tree_selection_unselect_all (select);
            }
          else
            {
              GtkTreeIter iter;
              GtkTreeModel *model;

              model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
                gtk_tree_selection_select_iter (select, &iter);
              else
                return LB_ERR;
            }
        }
        return wParam >= 0 ? wParam : LB_ERR;
      case LB_GETSEL:
        {
          GtkTreeIter iter;
          GtkTreeModel *model;
          GtkTreeSelection *select;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          select = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            return gtk_tree_selection_iter_is_selected (select, &iter);
        }
        return LB_ERR;
      case LB_GETCURSEL:
        {
          gint i;
          GtkTreeIter iter;
          GtkTreeModel *model;
          GtkTreeSelection *select;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          select = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
          for (i = 0;
                    gtk_tree_model_iter_nth_child (model, &iter, NULL, i); i++)
            if (gtk_tree_selection_iter_is_selected (select, &iter))
              return i;
        }
        return LB_ERR;
      case LB_GETTEXT:
        {
          gchar *utf8str = NULL;
          GtkTreeIter iter;
          GtkTreeModel *model;
          LRESULT lResult = LB_ERR;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            gtk_tree_model_get (model, &iter, 0, &utf8str, -1);
          if (utf8str)
            {
              if (wd->widechar)
                {
                  gunichar2 *wc;

                  wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
                  lstrcpyW (GINT_TO_POINTER (lParam), wc);
                  lResult = lstrlenW (wc);
                  g_free (wc);
                }
              else
                {
                  gchar *mb;

                  mb = w32ldr_utf8_to_mb (utf8str);
                  g_strcpy (GINT_TO_POINTER (lParam), mb);
                  lResult = g_strlen (mb);
                  g_free (mb);
                }
              g_free (utf8str);
            }
          return lResult;
        }
      case LB_GETTEXTLEN:
        {
          gchar *utf8str = NULL;
          GtkTreeIter iter;
          GtkTreeModel *model;
          LRESULT lResult = LB_ERR;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            gtk_tree_model_get (model, &iter, 0, &utf8str, -1);
          if (utf8str)
            {
              if (wd->widechar)
                {
                  gunichar2 *wc;

                  wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
                  lResult = lstrlenW (wc);
                  g_free (wc);
                }
              else
                {
                  gchar *mb;

                  mb = w32ldr_utf8_to_mb (utf8str);
                  lResult = g_strlen (mb);
                  g_free (mb);
                }
              g_free (utf8str);
            }
          return lResult;
        }
      case LB_GETCOUNT:
        {
          GtkTreeModel *model;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          return gtk_tree_model_iter_n_children (model, NULL);
        }
      case LB_SELECTSTRING:
        return w32list_DefWindowProc (hWnd, LB_SETCURSEL,
            w32list_DefWindowProc (hWnd, LB_FINDSTRING, wParam, lParam), 0);
      case LB_DIR:
        return LB_ERR;
      case LB_GETTOPINDEX:
        return LB_OKAY;
      case LB_FINDSTRING:
        {
          gchar *utf8str;
          gint i, length;
          GtkTreeModel *model;

          utf8str = wd->widechar
            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1, NULL, NULL, NULL)
            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          length = gtk_tree_model_iter_n_children (model, NULL);
          for (i = wParam + 1; i < length; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strncasecmp (utf8str, tmp,
                                                        g_strlen (utf8str));
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          for (i = 0; i <= wParam; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strncasecmp (utf8str, tmp,
                                                        g_strlen (utf8str));
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          g_free (utf8str);
        }
        return LB_ERR;
      case LB_GETSELCOUNT:
        if (wd->dwStyle & LBS_MULTIPLESEL)
          {
            gint i, count = 0;
            GtkTreeIter iter;
            GtkTreeModel *model;
            GtkTreeSelection *select;

            model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
            select = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
            for (i = 0;
                    gtk_tree_model_iter_nth_child (model, &iter, NULL, i); i++)
              if (gtk_tree_selection_iter_is_selected (select, &iter))
                count++;
            return count;
          }
        return LB_ERR;
      case LB_GETSELITEMS:
        if (wd->dwStyle & LBS_MULTIPLESEL)
          {
            gint i, count = 0;
            GtkTreeIter iter;
            GtkTreeModel *model;
            GtkTreeSelection *select;

            model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
            select = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
            for (i = 0; gtk_tree_model_iter_nth_child (model, &iter, NULL, i)
                                                        && count < wParam; i++)
              if (gtk_tree_selection_iter_is_selected (select, &iter))
                ((LPINT)lParam)[count++] = i;
            return count;
          }
        return LB_ERR;
      case LB_SETTABSTOPS:
        return FALSE;
      case LB_GETHORIZONTALEXTENT:
        return LB_OKAY;
      case LB_SETHORIZONTALEXTENT:
        return LB_OKAY;
      case LB_SETCOLUMNWIDTH:
        return LB_OKAY;
      case LB_ADDFILE:
        return LB_ERR;
      case LB_SETTOPINDEX:
        return LB_OKAY;
      case LB_GETITEMRECT:
        return LB_ERR;
      case LB_GETITEMDATA:
        {
          GtkTreeIter iter;
          GtkTreeModel *model;
          LRESULT lResult = LB_ERR;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            gtk_tree_model_get (model, &iter, 1, &lResult, -1);
          return lResult;
        }
      case LB_SETITEMDATA:
        {
          GtkListStore *store;
          GtkTreeIter iter;

          store = GTK_LIST_STORE (gtk_tree_view_get_model
                                                    (GTK_TREE_VIEW (list)));
          if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                        &iter, NULL, wParam))
            {
              gtk_list_store_set (store, &iter, 1, lParam, -1);
              return LB_OKAY;
            }
        }
        return LB_ERR;
      case LB_SELITEMRANGE:
        return wParam ? w32list_DefWindowProc (hWnd, LB_SELITEMRANGEEX,
                                    MIN (LOWORD (lParam), HIWORD (lParam)),
                                    MAX (LOWORD (lParam), HIWORD (lParam)))
                      : w32list_DefWindowProc (hWnd, LB_SELITEMRANGEEX,
                                    MAX (LOWORD (lParam), HIWORD (lParam)),
                                    MIN (LOWORD (lParam), HIWORD (lParam)));
      case LB_SETANCHORINDEX:
        return LB_ERR;
      case LB_GETANCHORINDEX:
        return LB_ERR;
      case LB_SETCARETINDEX:
        {
          GtkTreeIter iter;
          GtkTreeModel *model;

          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          if (gtk_tree_model_iter_nth_child (model, &iter, NULL, wParam))
            {
              GtkTreePath *path;

              path = gtk_tree_model_get_path (model, &iter);
              if (path)
                {
                  gtk_tree_view_set_cursor (GTK_TREE_VIEW (list),
                                                            path, NULL, FALSE);
                  gtk_tree_path_free (path);
                  return wParam;
                }
            }
        }
        return LB_ERR;
      case LB_GETCARETINDEX:
        {
          gint *indices;
          GtkTreePath *path;
          LRESULT lResult;

          gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, NULL);
          indices = gtk_tree_path_get_indices (path);
          lResult = indices ? indices[0] : LB_ERR;
          gtk_tree_path_free (path);
          return lResult;
        }
      case LB_SETITEMHEIGHT:
        return LB_ERR;
      case LB_GETITEMHEIGHT:
        return LB_ERR;
      case LB_FINDSTRINGEXACT:
        {
          gchar *utf8str;
          gint i, length;
          GtkTreeModel *model;

          utf8str = wd->widechar
            ? g_utf16_to_utf8 (GINT_TO_POINTER (lParam), -1, NULL, NULL, NULL)
            : w32ldr_utf8_from_mb (GINT_TO_POINTER (lParam));
          model = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
          length = gtk_tree_model_iter_n_children (model, NULL);
          for (i = wParam + 1; i < length; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strcasecmp (utf8str, tmp);
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          for (i = 0; i <= wParam; i++)
            {
              GtkTreeIter iter;

              if (gtk_tree_model_iter_nth_child (model, &iter, NULL, i))
                {
                  gchar *tmp;
                  gint result;

                  gtk_tree_model_get (model, &iter, 0, &tmp, -1);
                  result = g_ascii_strcasecmp (utf8str, tmp);
                  g_free (tmp);
                  if (result == 0)
                    {
                      g_free (utf8str);
                      return i;
                    }
                }
            }
          g_free (utf8str);
        }
        return LB_ERR;
      case LB_SETLOCALE:
        return LB_ERR;
      case LB_GETLOCALE:
        return LB_OKAY;
      case LB_SETCOUNT:
        return LB_OKAY;
      case LB_INITSTORAGE:
        return LB_OKAY;
      case LB_ITEMFROMPOINT:
        {
          gint y;

          if (gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW (list),
                    LOWORD (lParam), HIWORD (lParam), NULL, NULL, NULL, &y))
            return y;
        }
        return LB_ERR;
    }
  return wd->widechar ? DefWindowProcW (hWnd, Msg, wParam, lParam)
                       : DefWindowProcA (hWnd, Msg, wParam, lParam);
}


/* ja:リストが変化したとき */
static void
w32list_changed (GtkTreeSelection *select,
                 gpointer          user_data)
{
  GtkWidget *list;
  W32LdrWindowData *wd;

  list = GTK_WIDGET (gtk_tree_selection_get_tree_view (select));
  wd = g_object_get_data (G_OBJECT (list), "user_data");
  if (wd->widechar)
    SendMessageW (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_SELCHANGE), GPOINTER_TO_INT (list));
  else
    SendMessageA (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_SELCHANGE), GPOINTER_TO_INT (list));
  if (!gtk_tree_selection_get_selected (select, NULL, NULL))
    {
      if (wd->widechar)
        SendMessageW (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_SELCANCEL), GPOINTER_TO_INT (list));
      else
        SendMessageA (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_SELCANCEL), GPOINTER_TO_INT (list));
    }
}


/* ja:リストがクリックされたとき */
static gboolean
w32list_button_press_event (GtkWidget      *widget,
                            GdkEventButton *event,
                            gpointer        user_data)
{
  if (event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      W32LdrWindowData *wd;

      wd = g_object_get_data (G_OBJECT (widget), "user_data");
      if (wd->widechar)
        SendMessageW (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_DBLCLK), GPOINTER_TO_INT (widget));
      else
        SendMessageA (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_DBLCLK), GPOINTER_TO_INT (widget));
    }
  return FALSE;
}


/* ja:フォーカス取得 */
static gboolean
w32list_focus_in (GtkWidget     *widget,
                  GdkEventFocus *event,
                  gpointer       user_data)
{
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  if (wd->widechar)
    SendMessageW (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_SETFOCUS), GPOINTER_TO_INT (widget));
  else
    SendMessageA (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_SETFOCUS), GPOINTER_TO_INT (widget));
  return FALSE;
}


/* ja:フォーカス喪失 */
static gboolean
w32list_focus_out (GtkWidget     *widget,
                   GdkEventFocus *event,
                   gpointer       user_data)
{
  W32LdrWindowData *wd;

  wd = g_object_get_data (G_OBJECT (widget), "user_data");
  if (wd->widechar)
    SendMessageW (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_KILLFOCUS), GPOINTER_TO_INT (widget));
  else
    SendMessageA (wd->hWndParent, WM_COMMAND,
                MAKEWPARAM (wd->wID, LBN_KILLFOCUS), GPOINTER_TO_INT (widget));
  return FALSE;
}


GtkWidget *
w32ldr_control_create_list (const gchar    *windowname,
                            const guint32   style,
                            const guint32   exstyle,
                            const gint      width,
                            const gint      height,
                            const guint16   id,
                            HWND            hWndParent,
                            HINSTANCE       hInstance,
                            const gboolean  widechar)
{
  GtkCellRenderer *renderer;
  GtkListStore *store;
  GtkTreeSelection *select;
  GtkTreeViewColumn *column;
  GtkWidget *list, *scroll;
  W32LdrWindowData *wd;

  /* ja:リストビュー */
  store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
  list = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  g_object_unref (store);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (list), FALSE);
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (list), FALSE);
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes
                                        (NULL, renderer, "text", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (list), column);
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
  gtk_tree_selection_set_mode (select,
    style & LBS_MULTIPLESEL ? GTK_SELECTION_MULTIPLE : GTK_SELECTION_SINGLE);
  if (style & LBS_NOTIFY)
    {
      g_signal_connect (G_OBJECT (select), "changed",
                                        G_CALLBACK (w32list_changed), NULL);
      g_signal_connect (G_OBJECT (list), "button-press-event",
                                G_CALLBACK (w32list_button_press_event), NULL);
      gtk_widget_add_events (list, GDK_BUTTON_PRESS_MASK);
    }
  g_signal_connect (G_OBJECT (list), "focus-in-event",
                                        G_CALLBACK (w32list_focus_in), NULL);
  g_signal_connect (G_OBJECT (list), "focus-out-event",
                                        G_CALLBACK (w32list_focus_out), NULL);
  gtk_widget_add_events (list, GDK_FOCUS_CHANGE_MASK);
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
    GTK_POLICY_AUTOMATIC, 
    style & LBS_DISABLENOSCROLL ? GTK_POLICY_ALWAYS : GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), list);
  wd = g_malloc (sizeof (W32LdrWindowData));
  wd->dwStyle = style;
  wd->dwExStyle = exstyle;
  wd->hInstance = hInstance;
  wd->lpfnWndProc = w32list_DefWindowProc;
  wd->hWndParent = hWndParent;
  wd->wID = id;
  wd->dwUserData = 0;
  wd->lpDialogFunc = NULL;
  wd->lResult = -1;
  wd->dwUser = 0;
  wd->csa = NULL;
  wd->csw = NULL;
  wd->dwInitParam = 0;
  wd->widechar = widechar;
  wd->resizable = TRUE;
  wd->classname = g_strdup ("LISTBOX");
  wd->focus = list;
  wd->child = NULL;
  g_object_set_data (G_OBJECT (scroll), "user_data", wd);
  return scroll;
}
