/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __USER32_H__
#define __USER32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "gdi32.h"
#include "w32btn.h"
#include "w32edit.h"
#include "w32stc.h"
#include "w32list.h"
#include "w32sbar.h"
#include "w32combo.h"
#include "w32dlg.h"
#include "w32wnd.h"

/* ja:システム */
#define COLOR_SCROLLBAR               0
#define COLOR_BACKGROUND              1
#define COLOR_DESKTOP                 COLOR_BACKGROUND
#define COLOR_ACTIVECAPTION           2
#define COLOR_INACTIVECAPTION         3
#define COLOR_MENU                    4
#define COLOR_WINDOW                  5
#define COLOR_WINDOWFRAME             6
#define COLOR_MENUTEXT                7
#define COLOR_WINDOWTEXT              8
#define COLOR_CAPTIONTEXT             9
#define COLOR_ACTIVEBORDER            10
#define COLOR_INACTIVEBORDER          11
#define COLOR_APPWORKSPACE            12
#define COLOR_HIGHLIGHT               13
#define COLOR_HIGHLIGHTTEXT           14
#define COLOR_BTNFACE                 15
#define COLOR_3DFACE                  COLOR_BTNFACE
#define COLOR_BTNSHADOW               16
#define COLOR_3DSHADOW                COLOR_BTNSHADOW
#define COLOR_GRAYTEXT                17
#define COLOR_BTNTEXT                 18
#define COLOR_INACTIVECAPTIONTEXT     19
#define COLOR_BTNHIGHLIGHT            20
#define COLOR_3DHIGHLIGHT             COLOR_BTNHIGHLIGHT
#define COLOR_3DHILIGHT               COLOR_BTNHIGHLIGHT
#define COLOR_BTNHILIGHT              COLOR_BTNHIGHLIGHT
#define COLOR_3DDKSHADOW              21
#define COLOR_3DLIGHT                 22
#define COLOR_INFOTEXT                23
#define COLOR_INFOBK                  24
#define COLOR_ALTERNATEBTNFACE        25
#define COLOR_HOTLIGHT                26
#define COLOR_GRADIENTACTIVECAPTION   27
#define COLOR_GRADIENTINACTIVECAPTION 28
#define COLOR_MENUHILIGHT             29
#define COLOR_MENUBAR                 30
#define SM_CXSCREEN          0
#define SM_CYSCREEN          1
#define SM_CXVSCROLL         2
#define SM_CYHSCROLL         3
#define SM_CYCAPTION         4
#define SM_CXBORDER          5
#define SM_CYBORDER          6
#define SM_CXDLGFRAME        7
#define SM_CYDLGFRAME        8
#define SM_CYVTHUMB          9
#define SM_CXHTHUMB          10
#define SM_CXICON            11
#define SM_CYICON            12
#define SM_CXCURSOR          13
#define SM_CYCURSOR          14
#define SM_CYMENU            15
#define SM_CXFULLSCREEN      16
#define SM_CYFULLSCREEN      17
#define SM_CYKANJIWINDOW     18
#define SM_MOUSEPRESENT      19
#define SM_CYVSCROLL         20
#define SM_CXHSCROLL         21
#define SM_DEBUG             22
#define SM_SWAPBUTTON        23
#define SM_RESERVED1         24
#define SM_RESERVED2         25
#define SM_RESERVED3         26
#define SM_RESERVED4         27
#define SM_CXMIN             28
#define SM_CYMIN             29
#define SM_CXSIZE            30
#define SM_CYSIZE            31
#define SM_CXFRAME           32
#define SM_CYFRAME           33
#define SM_CXMINTRACK        34
#define SM_CYMINTRACK        35
#define SM_CXDOUBLECLK       36
#define SM_CYDOUBLECLK       37
#define SM_CXICONSPACING     38
#define SM_CYICONSPACING     39
#define SM_MENUDROPALIGNMENT 40
#define SM_PENWINDOWS        41
#define SM_DBCSENABLED       42
#define SM_CMOUSEBUTTONS     43
#define SM_CXFIXEDFRAME      SM_CXDLGFRAME
#define SM_CYFIXEDFRAME      SM_CYDLGFRAME
#define SM_CXSIZEFRAME       SM_CXFRAME
#define SM_CYSIZEFRAME       SM_CYFRAME
#define SM_SECURE            44
#define SM_CXEDGE            45
#define SM_CYEDGE            46
#define SM_CXMINSPACING      47
#define SM_CYMINSPACING      48
#define SM_CXSMICON          49
#define SM_CYSMICON          50
#define SM_CYSMCAPTION       51
#define SM_CXSMSIZE          52
#define SM_CYSMSIZE          53
#define SM_CXMENUSIZE        54
#define SM_CYMENUSIZE        55
#define SM_ARRANGE           56
#define SM_CXMINIMIZED       57
#define SM_CYMINIMIZED       58
#define SM_CXMAXTRACK        59
#define SM_CYMAXTRACK        60
#define SM_CXMAXIMIZED       61
#define SM_CYMAXIMIZED       62
#define SM_NETWORK           63
#define SM_CLEANBOOT         67
#define SM_CXDRAG            68
#define SM_CYDRAG            69
#define SM_SHOWSOUNDS        70
#define SM_CXMENUCHECK       71
#define SM_CYMENUCHECK       72
#define SM_SLOWMACHINE       73
#define SM_MIDEASTENABLED    74
#define SM_MOUSEWHEELPRESENT 75
#define SM_XVIRTUALSCREEN    76
#define SM_YVIRTUALSCREEN    77
#define SM_CXVIRTUALSCREEN   78
#define SM_CYVIRTUALSCREEN   79
#define SM_CMONITORS         80
#define SM_SAMEDISPLAYFORMAT 81
#define SM_IMMENABLED        82
#define SM_CXFOCUSBORDER     83
#define SM_CYFOCUSBORDER     84
#define SM_TABLETPC          86
#define SM_MEDIACENTER       87
#define SM_STARTER           88
#define SM_SERVERR2          89
#define SM_CMETRICS          90
#define SPI_GETBEEP               1
#define SPI_SETBEEP               2
#define SPI_GETMOUSE              3
#define SPI_SETMOUSE              4
#define SPI_GETBORDER             5
#define SPI_SETBORDER             6
#define SPI_GETKEYBOARDSPEED      10
#define SPI_SETKEYBOARDSPEED      11
#define SPI_LANGDRIVER            12
#define SPI_ICONHORIZONTALSPACING 13
#define SPI_GETSCREENSAVETIMEOUT  14
#define SPI_SETSCREENSAVETIMEOUT  15
#define SPI_GETSCREENSAVEACTIVE   16
#define SPI_SETSCREENSAVEACTIVE   17
#define SPI_GETGRIDGRANULARITY    18
#define SPI_SETGRIDGRANULARITY    19
#define SPI_SETDESKWALLPAPER      20
#define SPI_SETDESKPATTERN        21
#define SPI_GETKEYBOARDDELAY      22
#define SPI_SETKEYBOARDDELAY      23
#define SPI_ICONVERTICALSPACING   24
#define SPI_GETICONTITLEWRAP      25
#define SPI_SETICONTITLEWRAP      26
#define SPI_GETMENUDROPALIGNMENT  27
#define SPI_SETMENUDROPALIGNMENT  28
#define SPI_SETDOUBLECLKWIDTH     29
#define SPI_SETDOUBLECLKHEIGHT    30
#define SPI_GETICONTITLELOGFONT   31
#define SPI_SETDOUBLECLICKTIME    32
#define SPI_SETMOUSEBUTTONSWAP    33
#define SPI_SETICONTITLELOGFONT   34
#define SPI_GETFASTTASKSWITCH     35
#define SPI_SETFASTTASKSWITCH     36
#define SPI_SETDRAGFULLWINDOWS    37
#define SPI_GETDRAGFULLWINDOWS    38
#define SPI_GETNONCLIENTMETRICS   41
#define SPI_SETNONCLIENTMETRICS   42
#define SPI_GETMINIMIZEDMETRICS   43
#define SPI_SETMINIMIZEDMETRICS   44
#define SPI_GETICONMETRICS        45
#define SPI_SETICONMETRICS        46
#define SPI_SETWORKAREA           47
#define SPI_GETWORKAREA           48
#define SPI_SETPENWINDOWS         49
#define SPI_GETFILTERKEYS         50
#define SPI_SETFILTERKEYS         51
#define SPI_GETTOGGLEKEYS         52
#define SPI_SETTOGGLEKEYS         53
#define SPI_GETMOUSEKEYS          54
#define SPI_SETMOUSEKEYS          55
#define SPI_GETSHOWSOUNDS         56
#define SPI_SETSHOWSOUNDS         57
#define SPI_GETSTICKYKEYS         58
#define SPI_SETSTICKYKEYS         59
#define SPI_GETACCESSTIMEOUT      60
#define SPI_SETACCESSTIMEOUT      61
#define SPI_GETSERIALKEYS         62
#define SPI_SETSERIALKEYS         63
#define SPI_GETSOUNDSENTRY        64
#define SPI_SETSOUNDSENTRY        65
#define SPI_GETHIGHCONTRAST       66
#define SPI_SETHIGHCONTRAST       67
#define SPI_GETKEYBOARDPREF       68
#define SPI_SETKEYBOARDPREF       69
#define SPI_GETSCREENREADER       70
#define SPI_SETSCREENREADER       71
#define SPI_GETANIMATION          72
#define SPI_SETANIMATION          73
#define SPI_GETFONTSMOOTHING      74
#define SPI_SETFONTSMOOTHING      75
#define SPI_SETDRAGWIDTH          76
#define SPI_SETDRAGHEIGHT         77
#define SPI_SETHANDHELD           78
#define SPI_GETLOWPOWERTIMEOUT    79
#define SPI_GETPOWEROFFTIMEOUT    80
#define SPI_SETLOWPOWERTIMEOUT    81
#define SPI_SETPOWEROFFTIMEOUT    82
#define SPI_GETLOWPOWERACTIVE     83
#define SPI_GETPOWEROFFACTIVE     84
#define SPI_SETLOWPOWERACTIVE     85
#define SPI_SETPOWEROFFACTIVE     86
#define SPI_SETCURSORS            87
#define SPI_SETICONS              88
#define SPI_GETDEFAULTINPUTLANG   89
#define SPI_SETDEFAULTINPUTLANG   90
#define SPI_SETLANGTOGGLE         91
#define SPI_GETWINDOWSEXTENSION   92
#define SPI_SETMOUSETRAILS        93
#define SPI_GETMOUSETRAILS        94
#define SPI_GETSNAPTODEFBUTTON    95
#define SPI_SETSNAPTODEFBUTTON    96
#define SPI_SETSCREENSAVERRUNNING 97
#define SPI_SCREENSAVERRUNNING    SPI_SETSCREENSAVERRUNNING
#define SPI_GETMOUSEHOVERWIDTH    98
#define SPI_SETMOUSEHOVERWIDTH    99
#define SPI_GETMOUSEHOVERHEIGHT   100
#define SPI_SETMOUSEHOVERHEIGHT   101
#define SPI_GETMOUSEHOVERTIME     102
#define SPI_SETMOUSEHOVERTIME     103
#define SPI_GETWHEELSCROLLLINES   104
#define SPI_SETWHEELSCROLLLINES   105
#define SPI_GETMENUSHOWDELAY      106
#define SPI_SETMENUSHOWDELAY      107
#define SPI_GETSHOWIMEUI          110
#define SPI_SETSHOWIMEUI          111
#define SPI_GETMOUSESPEED         112
#define SPI_SETMOUSESPEED         113
#define SPI_GETSCREENSAVERRUNNING 114
#define SPI_GETDESKWALLPAPER      115

/* ja:タイマ */
typedef VOID CALLBACK (*TIMERPROC)(HWND, UINT, UINT, DWORD);

/* ja:描画 */
#include "pshpack1.h"
typedef struct _POINT
{
  LONG x;
  LONG y;
} POINT, *PPOINT, *LPPOINT;
typedef struct _RECT
{
  LONG left;
  LONG top;
  LONG right;
  LONG bottom;
} RECT, *PRECT, *LPRECT;
typedef const RECT *LPCRECT;
typedef struct _PAINTSTRUCT
{
  HDC hdc;
  BOOL fErase;
  RECT rcPaint;
  BOOL fRestore;
  BOOL fIncUpdate;
  BYTE rgbReserved[32];
} PAINTSTRUCT, *PPAINTSTRUCT, *LPPAINTSTRUCT;
#include "poppack.h"

/* ja:イメージ */
#define IMAGE_BITMAP      0
#define IMAGE_ICON        1
#define IMAGE_CURSOR      2
#define IMAGE_ENHMETAFILE 3

/* ja:アイコン */
typedef LPVOID HICON;

/* ja:カーソル */
#define IDC_ARROW       MAKEINTRESOURCE(32512)
#define IDC_IBEAM       MAKEINTRESOURCE(32513)
#define IDC_WAIT        MAKEINTRESOURCE(32514)
#define IDC_CROSS       MAKEINTRESOURCE(32515)
#define IDC_UPARROW     MAKEINTRESOURCE(32516)
#define IDC_SIZE        MAKEINTRESOURCE(32640)
#define IDC_ICON        MAKEINTRESOURCE(32641)
#define IDC_SIZENWSE    MAKEINTRESOURCE(32642)
#define IDC_SIZENESW    MAKEINTRESOURCE(32643)
#define IDC_SIZEWE      MAKEINTRESOURCE(32644)
#define IDC_SIZENS      MAKEINTRESOURCE(32645)
#define IDC_SIZEALL     MAKEINTRESOURCE(32646)
#define IDC_NO          MAKEINTRESOURCE(32648)
#define IDC_HAND        MAKEINTRESOURCE(32649)
#define IDC_APPSTARTING MAKEINTRESOURCE(32650)
#define IDC_HELP        MAKEINTRESOURCE(32651)
typedef LPVOID HCURSOR;

/* ja:ビットマップ */
typedef GdkPixbuf *HBITMAP;
#include "pshpack1.h"
typedef struct _BITMAPINFOHEADER
{
  DWORD biSize;
  LONG biWidth;
  LONG biHeight;
  WORD biPlanes;
  WORD biBitCount;
  DWORD biCompression;
  DWORD biSizeImage;
  LONG biXPelsPerMeter;
  LONG biYPelsPerMeter;
  DWORD biClrUsed;
  DWORD biClrImportant;
} BITMAPINFOHEADER, *PBITMAPINFOHEADER, *LPBITMAPINFOHEADER;
#include "poppack.h"

/* ja:メニュー */
#define MF_INSERT          0x00000000
#define MF_CHANGE          0x00000080
#define MF_APPEND          0x00000100
#define MF_DELETE          0x00000200
#define MF_REMOVE          0x00001000
#define MF_BYCOMMAND       0x00000000
#define MF_BYPOSITION      0x00000400
#define MF_SEPARATOR       0x00000800
#define MF_ENABLED         0x00000000
#define MF_GRAYED          0x00000001
#define MF_DISABLED        0x00000002
#define MF_UNCHECKED       0x00000000
#define MF_CHECKED         0x00000008
#define MF_USECHECKBITMAPS 0x00000200
#define MF_STRING          0x00000000
#define MF_BITMAP          0x00000004
#define MF_OWNERDRAW       0x00000100
#define MF_POPUP           0x00000010
#define MF_MENUBARBREAK    0x00000020
#define MF_MENUBREAK       0x00000040
#define MF_UNHILITE        0x00000000
#define MF_HILITE          0x00000080
#define MF_DEFAULT         0x00001000
#define MF_SYSMENU         0x00002000
#define MF_HELP            0x00004000
#define MF_RIGHTJUSTIFY    0x00004000
#define MF_MOUSESELECT     0x00008000
#define MF_END             0x00000080
#define MIIM_STATE      0x00000001
#define MIIM_ID         0x00000002
#define MIIM_SUBMENU    0x00000004
#define MIIM_CHECKMARKS 0x00000008
#define MIIM_TYPE       0x00000010
#define MIIM_DATA       0x00000020
#define MIIM_STRING     0x00000040
#define MIIM_BITMAP     0x00000080
#define MIIM_FTYPE      0x00000100
#define TPM_LEFTBUTTON   0x0000
#define TPM_RIGHTBUTTON  0x0002
#define TPM_LEFTALIGN    0x0000
#define TPM_CENTERALIGN  0x0004
#define TPM_RIGHTALIGN   0x0008
#define TPM_TOPALIGN     0x0000
#define TPM_VCENTERALIGN 0x0010
#define TPM_BOTTOMALIGN  0x0020
#define TPM_HORIZONTAL   0x0000
#define TPM_VERTICAL     0x0040
#define TPM_RETURNCMD    0x0100
typedef LPVOID HMENU;
#include "pshpack1.h"
typedef struct _MENUITEMINFOA
{
  UINT cbSize;
  UINT fMask;
  UINT fType;
  UINT fState;
  UINT wID;
  HMENU hSubMenu;
  HBITMAP hbmpChecked;
  HBITMAP hbmpUnchecked;
  ULONG_PTR dwItemData;
  LPSTR dwTypeData;
  UINT cch;
  HBITMAP hbmpItem;
} MENUITEMINFOA, *PMENUITEMINFOA, *LPMENUITEMINFOA;
typedef struct _MENUITEMINFOW
{
  UINT cbSize;
  UINT fMask;
  UINT fType;
  UINT fState;
  UINT wID;
  HMENU hSubMenu;
  HBITMAP hbmpChecked;
  HBITMAP hbmpUnchecked;
  ULONG_PTR dwItemData;
  LPWSTR dwTypeData;
  UINT cch;
  HBITMAP hbmpItem;
} MENUITEMINFOW, *PMENUITEMINFOW, *LPMENUITEMINFOW;
#include "poppack.h"
#ifdef UNICODE
# define MENUITEMINFO MENUITEMINFOW
# define PMENUITEMINFO PMENUITEMINFOW
# define LPMENUITEMINFO LPMENUITEMINFOW
#else /* not UNICODE */
# define MENUITEMINFO MENUITEMINFOA
# define PMENUITEMINFO PMENUITEMINFOA
# define LPMENUITEMINFO LPMENUITEMINFOA
#endif /* not UNICODE */

/* ja:アクセラレータ */
typedef LPVOID HACCEL;

/* ja:クリップボード */
#define CF_TEXT        1
#define CF_BITMAP      2
#define CF_OEMTEXT     7
#define CF_DIB         8
#define CF_UNICODETEXT 13

/* ja:メッセージ */
#define PM_NOREMOVE 0x0000
#define PM_REMOVE   0x0001
#include "pshpack1.h"
typedef struct _MSG
{
  HWND hwnd;
  UINT message;
  WPARAM wParam;
  LPARAM lParam;
  DWORD time;
  POINT pt;
} MSG, *PMSG, *LPMSG;
#include "poppack.h"

/* ja:ウインドウ */
#define CreateWindowA(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExA(0,a,b,c,d,e,f,g,h,i,j,k)
#define CreateWindowW(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExW(0,a,b,c,d,e,f,g,h,i,j,k)
#ifdef UNICODE
# define CreateWindow(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExW(0,a,b,c,d,e,f,g,h,i,j,k)
#else /* not UNICODE */
# define CreateWindow(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExA(0,a,b,c,d,e,f,g,h,i,j,k)
#endif /* not UNICODE */
#define HWND_DESKTOP NULL
#define CW_USEDEFAULT ((INT)0x80000000)
#define GWL_USERDATA   (-21)
#define GWL_EXSTYLE    (-20)
#define GWL_STYLE      (-16)
#define GWL_ID         (-12)
#define GWL_HWNDPARENT (-8)
#define GWL_HINSTANCE  (-6)
#define GWL_WNDPROC    (-4)
#define DWL_MSGRESULT 0
#define DWL_DLGPROC   4
#define DWL_USER      8
#define GW_HWNDFIRST 0
#define GW_HWNDLAST  1
#define GW_HWNDNEXT  2
#define GW_HWNDPREV  3
#define GW_OWNER     4
#define GW_CHILD     5
#define SW_HIDE            0
#define SW_SHOWNORMAL      1
#define SW_NORMAL          1
#define SW_SHOWMINIMIZED   2
#define SW_SHOWMAXIMIZED   3
#define SW_MAXIMIZE        3
#define SW_SHOWNOACTIVATE  4
#define SW_SHOW            5
#define SW_MINIMIZE        6
#define SW_SHOWMINNOACTIVE 7
#define SW_SHOWNA          8
#define SW_RESTORE         9
#define SW_SHOWDEFAULT     10
#define SW_FORCEMINIMIZE   11
#define SW_MAX             11
#define SW_NORMALNA        0xcc
#define HWND_TOP       ((HWND)0)
#define HWND_BOTTOM    ((HWND)1)
#define HWND_TOPMOST   ((HWND)-1)
#define HWND_NOTOPMOST ((HWND)-2)
#define HWND_MESSAGE   ((HWND)-3)
#define SWP_NOSIZE         0x0001
#define SWP_NOMOVE         0x0002
#define SWP_NOZORDER       0x0004
#define SWP_NOREDRAW       0x0008
#define SWP_NOACTIVATE     0x0010
#define SWP_FRAMECHANGED   0x0020
#define SWP_SHOWWINDOW     0x0040
#define SWP_HIDEWINDOW     0x0080
#define SWP_NOCOPYBITS     0x0100
#define SWP_NOOWNERZORDER  0x0200
#define SWP_DRAWFRAME      SWP_FRAMECHANGED
#define SWP_NOREPOSITION   SWP_NOOWNERZORDER
#define SWP_NOSENDCHANGING 0x0400
#define SWP_DEFERERASE     0x2000
#define SWP_ASYNCWINDOWPOS 0x4000
typedef LRESULT (CALLBACK *WNDPROC)(HWND, UINT, WPARAM, LPARAM);
typedef INT_PTR (CALLBACK *DLGPROC)(HWND, UINT, WPARAM, LPARAM);
typedef BOOL CALLBACK (*WNDENUMPROC)(HWND, LPARAM);
#include "pshpack1.h"
typedef struct _WNDCLASSA
{
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCSTR lpszMenuName;
  LPCSTR lpszClassName;
} WNDCLASSA, *PWNDCLASSA, *LPWNDCLASSA;
typedef struct _WNDCLASSW
{
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCWSTR lpszMenuName;
  LPCWSTR lpszClassName;
} WNDCLASSW, *PWNDCLASSW, *LPWNDCLASSW;
#include "poppack.h"
#ifdef UNICODE
# define WNDCLASS WNDCLASSW
# define PWNDCLASS PWNDCLASSW
# define LPWNDCLASS LPWNDCLASSW
#else /* not UNICODE */
# define WNDCLASS WNDCLASSA
# define PWNDCLASS PWNDCLASSA
# define LPWNDCLASS LPWNDCLASSA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _WNDCLASSEXA
{
  UINT cbSize;
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCSTR lpszMenuName;
  LPCSTR lpszClassName;
  HICON hIconSm;
} WNDCLASSEXA, *PWNDCLASSEXA, *LPWNDCLASSEXA;
typedef struct _WNDCLASSEXW
{
  UINT cbSize;
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCWSTR lpszMenuName;
  LPCWSTR lpszClassName;
  HICON hIconSm;
} WNDCLASSEXW, *PWNDCLASSEXW, *LPWNDCLASSEXW;
#include "poppack.h"
#ifdef UNICODE
# define WNDCLASSEX WNDCLASSEXW
# define PWNDCLASSEX PWNDCLASSEXW
# define LPWNDCLASSEX LPWNDCLASSEXW
#else /* not UNICODE */
# define WNDCLASSEX WNDCLASSEXA
# define PWNDCLASSEX PWNDCLASSEXA
# define LPWNDCLASSEX LPWNDCLASSEXA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _CREATESTRUCTA
{
  LPVOID lpCreateParams;
  HINSTANCE hInstance;
  HMENU hMenu;
  HWND hwndParent;
  INT cy;
  INT cx;
  INT y;
  INT x;
  LONG style;
  LPCSTR lpszName;
  LPCSTR lpszClass;
  DWORD dwExStyle;
} CREATESTRUCTA, *PCREATESTRUCTA, *LPCREATESTRUCTA;
typedef struct _CREATESTRUCTW
{
  LPVOID lpCreateParams;
  HINSTANCE hInstance;
  HMENU hMenu;
  HWND hwndParent;
  INT cy;
  INT cx;
  INT y;
  INT x;
  LONG style;
  LPCWSTR lpszName;
  LPCWSTR lpszClass;
  DWORD dwExStyle;
} CREATESTRUCTW, *PCREATESTRUCTW, *LPCREATESTRUCTW;
#include "poppack.h"
#ifdef UNICODE
# define CREATESTRUCT CREATESTRUCTW
# define PCREATESTRUCT PCREATESTRUCTW
# define LPCREATESTRUCT LPCREATESTRUCTW
#else /* not UNICODE */
# define CREATESTRUCT CREATESTRUCTA
# define PCREATESTRUCT PCREATESTRUCTA
# define LPCREATESTRUCT LPCREATESTRUCTA
#endif /* not UNICODE */

/* ja:ダイアログ */
#define CreateDialogA(a,b,c,d) CreateDialogParamA(a,b,c,d,0)
#define CreateDialogW(a,b,c,d) CreateDialogParamW(a,b,c,d,0)
#define DialogBoxA(a,b,c,d) DialogBoxParamA(a,b,c,d,0)
#define DialogBoxW(a,b,c,d) DialogBoxParamW(a,b,c,d,0)
#ifdef UNICODE
# define CreateDialog(a,b,c,d) CreateDialogParamW(a,b,c,d,0)
# define DialogBox(a,b,c,d) DialogBoxParamW(a,b,c,d,0)
#else /* not UNICODE */
# define CreateDialog(a,b,c,d) CreateDialogParamA(a,b,c,d,0)
# define DialogBox(a,b,c,d) DialogBoxParamA(a,b,c,d,0)
#endif /* not UNICODE */
#include "pshpack2.h"
typedef struct _DLGTEMPLATE
{
  DWORD style;
  DWORD exstyle;
  WORD cdit;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
} DLGTEMPLATE, *PDLGTEMPLATE, *LPDLGTEMPLATE;
typedef CONST DLGTEMPLATE *PCDLGTEMPLATE, *LPCDLGTEMPLATE;
typedef struct _DLGITEMTEMPLATE
{
  DWORD style;
  DWORD exstyle;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
  WORD ID;
} DLGITEMTEMPLATE, *PDLGITEMTEMPLATE, *LPDLGITEMTEMPLATE;
typedef CONST DLGITEMTEMPLATE *PCDLGITEMTEMPLATE, *LCPDLGITEMTEMPLATE;
typedef struct _DLGTEMPLATEEX
{
  WORD dlgVer;
  WORD signature;
  DWORD helpID;
  DWORD exstyle;
  DWORD style;
  WORD cdit;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
} DLGTEMPLATEEX, *PDLGTEMPLATEEX, *LPDLGTEMPLATEEX;
typedef CONST DLGTEMPLATEEX *PCDLGTEMPLATEEX, *LPCDLGTEMPLATEEX;
typedef struct _DLGITEMTEMPLATEEX
{
  DWORD helpID;
  DWORD exstyle;
  DWORD style;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
  WORD ID;
} DLGITEMTEMPLATEEX, *PDLGITEMTEMPLATEEX, *LPDLGITEMTEMPLATEEX;
typedef CONST DLGITEMTEMPLATEEX *PCDLGITEMTEMPLATEEX, *LPCDLGITEMTEMPLATEEX;
#include "poppack.h"
/* ja:メッセージボックス */
#define MB_OK                   0x00000000
#define MB_OKCANCEL             0x00000001
#define MB_ABORTRETRYIGNORE     0x00000002
#define MB_YESNOCANCEL          0x00000003
#define MB_YESNO                0x00000004
#define MB_RETRYCANCEL          0x00000005
#define MB_TYPEMASK             0x0000000F
#define MB_ICONHAND             0x00000010
#define MB_ICONQUESTION         0x00000020
#define MB_ICONEXCLAMATION      0x00000030
#define MB_ICONASTERISK         0x00000040
#define MB_USERICON             0x00000080
#define MB_ICONMASK             0x000000F0
#define MB_ICONINFORMATION      MB_ICONASTERISK
#define MB_ICONSTOP             MB_ICONHAND
#define MB_ICONWARNING          MB_ICONEXCLAMATION
#define MB_ICONERROR            MB_ICONHAND
#define MB_DEFBUTTON1           0x00000000
#define MB_DEFBUTTON2           0x00000100
#define MB_DEFBUTTON3           0x00000200
#define MB_DEFBUTTON4           0x00000300
#define MB_DEFMASK              0x00000f00
#define MB_APPLMODAL            0x00000000
#define MB_SYSTEMMODAL          0x00001000
#define MB_TASKMODAL            0x00002000
#define MB_MODEMASK             0x00003000
#define MB_HELP                 0x00004000
#define MB_NOFOCUS              0x00008000
#define MB_MISCMASK             0x0000C000
#define MB_SETFOREGROUND        0x00010000
#define MB_DEFAULT_DESKTOP_ONLY 0x00020000
#define MB_SERVICE_NOTIFICATION 0x00040000
#define MB_TOPMOST              0x00040000
#define MB_RIGHT                0x00080000
#define MB_RTLREADING           0x00100000
/* en:ID */
#define IDOK       1
#define IDCANCEL   2
#define IDABORT    3
#define IDRETRY    4
#define IDIGNORE   5
#define IDYES      6
#define IDNO       7
#define IDCLOSE    8
#define IDHELP     9
#define IDTRYAGAIN 10
#define IDCONTINUE 11


extern W32LdrExport user32_exports[];


HDC WINAPI BeginPaint (HWND hWnd, LPPAINTSTRUCT lpPaint);
LRESULT WINAPI CallWindowProcA (WNDPROC lpPrevWndFunc, HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI CallWindowProcW (WNDPROC lpPrevWndFunc, HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LPSTR WINAPI CharLowerA (LPSTR lpsz);
LPWSTR WINAPI CharLowerW (LPWSTR lpsz);
LPSTR WINAPI CharUpperA (LPSTR lpsz);
LPWSTR WINAPI CharUpperW (LPWSTR lpsz);
BOOL WINAPI CheckDlgButton (HWND hDlg, INT nIDButton, UINT uCheck);
BOOL WINAPI CheckRadioButton (HWND hDlg, INT nIDFirstButton, INT nIDLastButton, INT nIDCheckButton);
BOOL WINAPI ClientToScreen (HWND hWnd, LPPOINT lpPoint);
BOOL WINAPI ClipCursor (CONST LPRECT lpRect);
BOOL WINAPI CloseClipboard (VOID);
BOOL WINAPI CopyRect (LPRECT lprcDst, CONST LPRECT lprcSrc);
HWND WINAPI CreateDialogIndirectParamA (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HWND WINAPI CreateDialogIndirectParamW (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HWND WINAPI CreateDialogParamA (HINSTANCE hInstance, LPCSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HWND WINAPI CreateDialogParamW (HINSTANCE hInstance, LPCWSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HWND WINAPI CreateWindowExA (DWORD dwExStyle, LPCSTR lpClassName, LPCSTR lpWindowName, DWORD dwStyle, INT x, INT y, INT nWidth, INT nHeight, HWND hWndParent, HMENU hMenu, HINSTANCE hInstance, LPVOID lpParam);
HWND WINAPI CreateWindowExW (DWORD dwExStyle, LPCWSTR lpClassName, LPCWSTR lpWindowName, DWORD dwStyle, INT x, INT y, INT nWidth, INT nHeight, HWND hWndParent, HMENU hMenu, HINSTANCE hInstance, LPVOID lpParam);
LRESULT WINAPI DefWindowProcA (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI DefWindowProcW (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
BOOL WINAPI DestroyWindow (HWND hWnd);
INT WINAPI DialogBoxIndirectParamA (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT WINAPI DialogBoxIndirectParamW (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT WINAPI DialogBoxParamA (HINSTANCE hInstance, LPCSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT WINAPI DialogBoxParamW (HINSTANCE hInstance, LPCWSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
BOOL WINAPI EmptyClipboard (VOID);
BOOL WINAPI EnableWindow (HWND hWnd, BOOL bEnable);
BOOL WINAPI EndDialog (HWND hDlg, INT nResult);
BOOL WINAPI EndPaint (HWND hWnd, LPPAINTSTRUCT lpPaint);
BOOL WINAPI EnumThreadWindows (DWORD dwThreadId, WNDENUMPROC lpEnumFunc, LPARAM lParam);
BOOL WINAPI EnumWindows (WNDENUMPROC lpEnumFunc, LPARAM lParam);
BOOL WINAPI EqualRect (CONST LPRECT lprc1, CONST LPRECT lprc2);
INT WINAPI GetClassNameA (HWND hWnd, LPSTR lpClassName, INT nMaxCount);
INT WINAPI GetClassNameW (HWND hWnd, LPWSTR lpClassName, INT nMaxCount);
BOOL WINAPI GetClientRect (HWND hWnd, LPRECT lpRect);
BOOL WINAPI GetCursorPos (LPPOINT lpPoint);
HDC WINAPI GetDC (HWND hWnd);
HWND WINAPI GetDesktopWindow (VOID);
INT WINAPI GetDlgCtrlID (HWND hWndCtl);
HWND WINAPI GetDlgItem (HWND hDlg, INT nIDDlgItem);
UINT WINAPI GetDlgItemInt (HWND hDlg, INT nIDDlgItem, BOOL *lpTranslated, BOOL bSigned);
HWND WINAPI GetFocus (VOID);
INT WINAPI GetKeyboardType (INT nTypeFlag);
HWND WINAPI GetParent (HWND hWnd);
INT WINAPI GetScrollPos (HWND hWnd, INT nBar);
BOOL WINAPI GetScrollRange (HWND hWnd, INT nBar, LPINT lpMinPos, LPINT lpMaxPos);
DWORD WINAPI GetSysColor (int nIndex);
HMENU WINAPI GetSystemMenu (HWND hWnd, BOOL bRevert);
INT WINAPI GetSystemMetrics (INT nIndex);
HWND WINAPI GetWindow (HWND hWnd, UINT uCmd);
LONG WINAPI GetWindowLongA (HWND hWnd, INT nIndex);
LONG WINAPI GetWindowLongW (HWND hWnd, INT nIndex);
BOOL WINAPI GetWindowRect (HWND hWnd, LPRECT lpRect);
INT WINAPI GetWindowTextA (HWND hWnd, LPSTR lpString, INT nMaxCount);
INT WINAPI GetWindowTextLengthA (HWND hWnd);
INT WINAPI GetWindowTextLengthW (HWND hWnd);
INT WINAPI GetWindowTextW (HWND hWnd, LPWSTR lpString, INT nMaxCount);
BOOL WINAPI InflateRect (LPRECT lprc, INT dx, INT dy);
BOOL WINAPI IntersectRect (LPRECT lprcDst, CONST LPRECT lprcSrc1, CONST LPRECT lprcSrc2);
BOOL WINAPI InvalidateRect (HWND hWnd, CONST RECT *lpRect, BOOL bErase);
UINT WINAPI IsDlgButtonChecked (HWND hDlg, INT nIDButton);
BOOL WINAPI IsRectEmpty (CONST LPRECT lprc);
BOOL WINAPI IsWindowEnabled (HWND hWnd);
BOOL WINAPI IsWindowUnicode (HWND hWnd);
BOOL WINAPI KillTimer (HWND hWnd, UINT uIDEvent);
HBITMAP WINAPI LoadBitmapA (HINSTANCE hInstance, LPCSTR lpBitmapName);
HBITMAP WINAPI LoadBitmapW (HINSTANCE hInstance, LPCWSTR lpBitmapName);
INT WINAPI LoadStringA (HINSTANCE hInstance, UINT uID, LPSTR lpBuffer, INT nBufferMax);
INT WINAPI LoadStringW (HINSTANCE hInstance, UINT uID, LPWSTR lpBuffer, INT nBufferMax);
INT WINAPI MapWindowPoints (HWND hWndFrom, HWND hWndTo, LPPOINT lpPoints, UINT cPoints);
BOOL WINAPI MessageBeep (UINT uType);
INT WINAPI MessageBoxA (HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType);
INT WINAPI MessageBoxExA (HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType, WORD wLanguageId);
INT WINAPI MessageBoxExW (HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType, WORD wLanguageId);
INT WINAPI MessageBoxW (HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType);
BOOL WINAPI MoveWindow (HWND hWnd, INT x, INT y, INT nWidth, INT nHeight, BOOL bRepaint);
BOOL WINAPI OffsetRect (LPRECT lprc, INT dx, INT dy);
BOOL WINAPI OpenClipboard (HWND hWndNewOwner);
BOOL WINAPI PtInRect (CONST LPRECT lprc, POINT pt);
ATOM WINAPI RegisterClassA (CONST LPWNDCLASSA lpWndClass);
ATOM WINAPI RegisterClassExA (CONST LPWNDCLASSEXA lpWndClassEx);
ATOM WINAPI RegisterClassExW (CONST LPWNDCLASSEXW lpWndClassEx);
ATOM WINAPI RegisterClassW (CONST LPWNDCLASSW lpWndClass);
BOOL WINAPI ReleaseCapture (VOID);
INT WINAPI ReleaseDC (HWND hWnd, HDC hDC);
BOOL WINAPI ScreenToClient (HWND hWnd, LPPOINT lpPoint);
LONG WINAPI SendDlgItemMessageA (HWND hDlg, INT nIDDlgItem, UINT Msg, WPARAM wParam, LPARAM lParam);
LONG WINAPI SendDlgItemMessageW (HWND hDlg, INT nIDDlgItem, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI SendMessageA (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI SendMessageW (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
HWND WINAPI SetCapture (HWND hWnd);
HANDLE WINAPI SetClipboardData (UINT uFormat, HANDLE hMem);
BOOL WINAPI SetDlgItemInt (HWND hDlg, INT nIDDlgItem, UINT uValue, BOOL bSigned);
BOOL WINAPI SetDlgItemTextA (HWND hDlg, INT nIDDlgItem, LPCSTR lpString);
BOOL WINAPI SetDlgItemTextW (HWND hDlg, INT nIDDlgItem, LPCWSTR lpString);
HWND WINAPI SetFocus (HWND hWnd);
BOOL WINAPI SetForegroundWindow (HWND hWnd);
BOOL WINAPI SetRect (LPRECT lprc, int xLeft, int yTop, int xRight, int yBottom);
BOOL WINAPI SetRectEmpty (LPRECT lprc);
INT WINAPI SetScrollPos (HWND hWnd, INT nBar, INT nPos, BOOL bRedraw);
BOOL WINAPI SetScrollRange (HWND hWnd, INT nBar, INT nMinPos, INT nMaxPos, BOOL bRedraw);
UINT WINAPI SetTimer (HWND hWnd, UINT uIDEvent, UINT uElapse, TIMERPROC lpTimerFunc);
LONG WINAPI SetWindowLongA (HWND hWnd, INT nIndex, LONG dwNewLong);
LONG WINAPI SetWindowLongW (HWND hWnd, INT nIndex, LONG dwNewLong);
BOOL WINAPI SetWindowPos (HWND hWnd, HWND hWndInsertAfter, INT x, INT y, INT cx, INT cy, UINT uFlags);
BOOL WINAPI SetWindowTextA (HWND hWnd, LPCSTR lpString);
BOOL WINAPI SetWindowTextW (HWND hWnd, LPCWSTR lpString);
BOOL WINAPI ShowWindow (HWND hWnd, INT nCmdShow);
BOOL WINAPI SubtractRect (LPRECT lprcDst, CONST LPRECT lprcSrc1, CONST LPRECT lprcSrc2);
BOOL WINAPI SystemParametersInfoA (UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni);
BOOL WINAPI SystemParametersInfoW (UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni);
BOOL WINAPI UnionRect (LPRECT lprcDst, CONST LPRECT lprcSrc1, CONST LPRECT lprcSrc2);
BOOL WINAPI UnregisterClassA (LPCSTR lpClassName, HINSTANCE hInstance);
BOOL WINAPI UnregisterClassW (LPCWSTR lpClassName, HINSTANCE hInstance);
BOOL WINAPI UpdateWindow (HWND hWnd);
BOOL WINAPI WinHelpA (HWND hWndMain, LPCSTR lpszHelp, UINT uCommand, DWORD dwData);
BOOL WINAPI WinHelpW (HWND hWndMain, LPCWSTR lpszHelp, UINT uCommand, DWORD dwData);
HWND WINAPI WindowFromPoint (POINT Point);
INT WINAPIV wsprintfA (LPSTR lpOutput, LPCSTR lpFormat, ...);
INT WINAPIV wsprintfW (LPWSTR lpOutput, LPCWSTR lpFormat, ...);
INT WINAPI wvsprintfA (LPSTR lpOutput, LPCSTR lpFormat, va_list arglist);
INT WINAPI wvsprintfW (LPSTR lpOutput, LPCSTR lpFormat, va_list arglist);


#ifdef UNICODE
# define CallWindowProc CallWindowProcW
# define CharLower CharLowerW
# define CharUpper CharUpperW
# define CreateDialogIndirectParam CreateDialogIndirectParamW
# define CreateDialogParam CreateDialogParamW
# define CreateWindowEx CreateWindowExW
# define DefWindowProc DefWindowProcW
# define DialogBoxIndirectParam DialogBoxIndirectParamW
# define DialogBoxParam DialogBoxParamW
# define GetClassName GetClassNameW
# define GetWindowLong GetWindowLongW
# define GetWindowText GetWindowTextW
# define GetWindowTextLength GetWindowTextLengthW
# define LoadBitmap LoadBitmapW
# define LoadString LoadStringW
# define MessageBox MessageBoxW
# define MessageBoxEx MessageBoxExW
# define RegisterClass RegisterClassW
# define RegisterClassEx RegisterClassExW
# define SendDlgItemMessage SendDlgItemMessageW
# define SendMessage SendMessageW
# define SetDlgItemText SetDlgItemTextW
# define SetWindowLong SetWindowLongW
# define SetWindowText SetWindowTextW
# define SystemParametersInfo SystemParametersInfoW
# define UnregisterClass UnregisterClassW
# define WinHelp WinHelpW
# define wsprintf wsprintfW
# define wvsprintf wvsprintfW
#else /* not UNICODE*/
# define CallWindowProc CallWindowProcA
# define CharLower CharLowerA
# define CharUpper CharUpperA
# define CreateDialogIndirectParam CreateDialogIndirectParamA
# define CreateDialogParam CreateDialogParamA
# define CreateWindowEx CreateWindowExA
# define DefWindowProc DefWindowProcA
# define DialogBoxIndirectParam DialogBoxIndirectParamA
# define DialogBoxParam DialogBoxParamA
# define GetClassName GetClassNameA
# define GetWindowLong GetWindowLongA
# define GetWindowText GetWindowTextA
# define GetWindowTextLength GetWindowTextLengthA
# define LoadBitmap LoadBitmapA
# define LoadString LoadStringA
# define MessageBox MessageBoxA
# define MessageBoxEx MessageBoxExA
# define RegisterClass RegisterClassA
# define RegisterClassEx RegisterClassExA
# define SendDlgItemMessage SendDlgItemMessageA
# define SendMessage SendMessageA
# define SetDlgItemText SetDlgItemTextA
# define SetWindowLong SetWindowLongA
# define SetWindowText SetWindowTextA
# define SystemParametersInfo SystemParametersInfoA
# define UnregisterClass UnregisterClassA
# define WinHelp WinHelpA
# define wsprintf wsprintfA
# define wvsprintf wvsprintfA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __USER32_H__ */
