/*
    dllloader
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __WINUSER_H__
#define __WINUSER_H__


#include "pe_image.h"


#ifdef __cplusplus
extern "C" {
#endif


/* Standard dialog button IDs */
#define IDOK				1
#define IDCANCEL			2
#define IDABORT				3
#define IDRETRY				4
#define IDIGNORE			5
#define IDYES				6
#define IDNO				7
#define IDCLOSE				8
#define IDHELP				9


/******************************************************************************
*                                                                             *
* ɥ                                                                  *
*                                                                             *
******************************************************************************/
typedef struct WindowExtraData_Tag {
	DWORD dwStyle;
	DWORD dwExStyle;
	WNDPROC lpfnWndProc;
	HINSTANCE hInstance;
	HWND hWndParent;
	WORD wID;
	DWORD dwUserData;
	DLGPROC lpDialogFunc;
	LRESULT lResult;
	DWORD dwUser;
	GtkWidget **child,**sister;
} WindowExtraData;


/******************************************************************************
*                                                                             *
* å                                                                  *
*                                                                             *
******************************************************************************/
/* Win32 button control messages */
#define BM_GETCHECK					0x00f0
#define BM_SETCHECK					0x00f1
#define BM_GETSTATE					0x00f2
#define BM_SETSTATE					0x00f3
#define BM_SETSTYLE					0x00f4
#define BM_CLICK					0x00f5
#define BM_GETIMAGE					0x00f6
#define BM_SETIMAGE					0x00f7

/* Combo box messages */
#define CB_GETEDITSEL				0x0140
#define CB_LIMITTEXT				0x0141
#define CB_SETEDITSEL				0x0142
#define CB_ADDSTRING				0x0143
#define CB_DELETESTRING				0x0144
#define CB_DIR						0x0145
#define CB_GETCOUNT					0x0146
#define CB_GETCURSEL				0x0147
#define CB_GETLBTEXT				0x0148
#define CB_GETLBTEXTLEN				0x0149
#define CB_INSERTSTRING				0x014a
#define CB_RESETCONTENT				0x014b
#define CB_FINDSTRING				0x014c
#define CB_SELECTSTRING				0x014d
#define CB_SETCURSEL				0x014e
#define CB_SHOWDROPDOWN				0x014f
#define CB_GETITEMDATA				0x0150
#define CB_SETITEMDATA				0x0151
#define CB_GETDROPPEDCONTROLRECT	0x0152
#define CB_SETITEMHEIGHT			0x0153
#define CB_GETITEMHEIGHT			0x0154
#define CB_SETEXTENDEDUI			0x0155
#define CB_GETEXTENDEDUI			0x0156
#define CB_GETDROPPEDSTATE			0x0157
#define CB_FINDSTRINGEXACT			0x0158
#define CB_SETLOCALE				0x0159
#define CB_GETLOCALE				0x015a
#define CB_GETTOPINDEX				0x015b
#define CB_SETTOPINDEX				0x015c
#define CB_GETHORIZONTALEXTENT		0x015d
#define CB_SETHORIZONTALEXTENT		0x015e
#define CB_GETDROPPEDWIDTH			0x015f
#define CB_SETDROPPEDWIDTH			0x0160
#define CB_INITSTORAGE				0x0161

/* Combo box message return values */
#define CB_OKAY						0
#define CB_ERR						(-1)
#define CB_ERRSPACE					(-2)

/* Scrollbar messages */
#define SBM_SETPOS					0x00e0
#define SBM_GETPOS					0x00e1
#define SBM_SETRANGE				0x00e2
#define SBM_GETRANGE				0x00e3
#define SBM_ENABLE_ARROWS			0x00e4
#define SBM_SETRANGEREDRAW			0x00e6
#define SBM_SETSCROLLINFO			0x00e9
#define SBM_GETSCROLLINFO			0x00ea

/* WM_GETDLGCODE values */
#define WM_NULL						0x0000
#define WM_CREATE					0x0001
#define WM_DESTROY					0x0002
#define WM_MOVE						0x0003
#define WM_SIZEWAIT					0x0004
#define WM_SIZE						0x0005
#define WM_ACTIVATE					0x0006
#define WM_SETFOCUS					0x0007
#define WM_KILLFOCUS				0x0008
#define WM_SETVISIBLE				0x0009
#define WM_ENABLE					0x000a
#define WM_SETREDRAW				0x000b
#define WM_SETTEXT					0x000c
#define WM_GETTEXT					0x000d
#define WM_GETTEXTLENGTH			0x000e
#define WM_PAINT					0x000f
#define WM_CLOSE					0x0010
#define WM_QUERYENDSESSION			0x0011
#define WM_QUIT						0x0012
#define WM_QUERYOPEN				0x0013
#define WM_ERASEBKGND				0x0014
#define WM_SYSCOLORCHANGE			0x0015
#define WM_ENDSESSION				0x0016
#define WM_SYSTEMERROR				0x0017
#define WM_SHOWWINDOW				0x0018
#define WM_CTLCOLOR					0x0019
#define WM_WININICHANGE				0x001a
#define WM_SETTINGCHANGE			WM_WININICHANGE
#define WM_DEVMODECHANGE			0x001b
#define WM_ACTIVATEAPP				0x001c
#define WM_FONTCHANGE				0x001d
#define WM_TIMECHANGE				0x001e
#define WM_CANCELMODE				0x001f
#define WM_SETCURSOR				0x0020
#define WM_MOUSEACTIVATE			0x0021
#define WM_CHILDACTIVATE			0x0022
#define WM_QUEUESYNC				0x0023
#define WM_GETMINMAXINFO			0x0024

#define WM_PAINTICON				0x0026
#define WM_ICONERASEBKGND			0x0027
#define WM_NEXTDLGCTL				0x0028
#define WM_ALTTABACTIVE				0x0029
#define WM_SPOOLERSTATUS			0x002a
#define WM_DRAWITEM					0x002b
#define WM_MEASUREITEM				0x002c
#define WM_DELETEITEM				0x002d
#define WM_VKEYTOITEM				0x002e
#define WM_CHARTOITEM				0x002f
#define WM_SETFONT					0x0030
#define WM_GETFONT					0x0031
#define WM_SETHOTKEY				0x0032
#define WM_GETHOTKEY				0x0033
#define WM_FILESYSCHANGE			0x0034
#define WM_ISACTIVEICON				0x0035
#define WM_QUERYPARKICON			0x0036
#define WM_QUERYDRAGICON			0x0037
#define WM_QUERYSAVESTATE			0x0038
#define WM_COMPAREITEM				0x0039
#define WM_TESTING					0x003a

#define WM_OTHERWINDOWCREATED		0x003c
#define WM_OTHERWINDOWDESTROYED		0x003d
#define WM_ACTIVATESHELLWINDOW		0x003e

#define WM_COMPACTING				0x0041

#define WM_COMMNOTIFY				0x0044
#define WM_WINDOWPOSCHANGING 		0x0046
#define WM_WINDOWPOSCHANGED 		0x0047
#define WM_POWER					0x0048

/* Win32 4.0 messages */
#define WM_COPYDATA					0x004a
#define WM_CANCELJOURNAL			0x004b
#define WM_NOTIFY					0x004e
#define WM_INPUTLANGCHANGEREQUEST	0x0050
#define WM_INPUTLANGCHANGE			0x0051
#define WM_TCARD					0x0052
#define WM_HELP						0x0053
#define WM_USERCHANGED				0x0054
#define WM_NOTIFYFORMAT				0x0055

#define WM_CONTEXTMENU				0x007b
#define WM_STYLECHANGING 			0x007c
#define WM_STYLECHANGED				0x007d
#define WM_DISPLAYCHANGE			0x007e
#define WM_GETICON					0x007f
#define WM_SETICON					0x0080

/* Non-client system messages */
#define WM_NCCREATE					0x0081
#define WM_NCDESTROY				0x0082
#define WM_NCCALCSIZE				0x0083
#define WM_NCHITTEST				0x0084
#define WM_NCPAINT					0x0085
#define WM_NCACTIVATE				0x0086

#define WM_GETDLGCODE				0x0087
#define WM_SYNCPAINT				0x0088
#define WM_SYNCTASK					0x0089

/* Non-client mouse messages */
#define WM_NCMOUSEMOVE				0x00a0
#define WM_NCLBUTTONDOWN			0x00a1
#define WM_NCLBUTTONUP				0x00a2
#define WM_NCLBUTTONDBLCLK			0x00a3
#define WM_NCRBUTTONDOWN			0x00a4
#define WM_NCRBUTTONUP				0x00a5
#define WM_NCRBUTTONDBLCLK			0x00a6
#define WM_NCMBUTTONDOWN			0x00a7
#define WM_NCMBUTTONUP				0x00a8
#define WM_NCMBUTTONDBLCLK			0x00a9

#define WM_NCXBUTTONDOWN			0x00ab
#define WM_NCXBUTTONUP				0x00ac
#define WM_NCXBUTTONDBLCLK			0x00ad

/* Keyboard messages */
#define WM_KEYDOWN					0x0100
#define WM_KEYUP					0x0101
#define WM_CHAR						0x0102
#define WM_DEADCHAR					0x0103
#define WM_SYSKEYDOWN				0x0104
#define WM_SYSKEYUP					0x0105
#define WM_SYSCHAR					0x0106
#define WM_SYSDEADCHAR				0x0107
#define WM_KEYFIRST					WM_KEYDOWN
#define WM_KEYLAST					0x0108

/* Win32 4.0 messages for IME */
#define WM_IME_STARTCOMPOSITION		0x010d
#define WM_IME_ENDCOMPOSITION		0x010e
#define WM_IME_COMPOSITION			0x010f
#define WM_IME_KEYLAST				0x010f

#define WM_INITDIALOG				0x0110
#define WM_COMMAND					0x0111
#define WM_SYSCOMMAND				0x0112
#define WM_TIMER					0x0113
#define WM_SYSTIMER					0x0118

/* scroll messages */
#define WM_HSCROLL					0x0114
#define WM_VSCROLL					0x0115

/* Menu messages */
#define WM_INITMENU					0x0116
#define WM_INITMENUPOPUP			0x0117

#define WM_MENUSELECT				0x011F
#define WM_MENUCHAR					0x0120
#define WM_ENTERIDLE				0x0121

#define WM_MENURBUTTONUP			0x0122
#define WM_MENUDRAG					0x0123
#define WM_MENUGETOBJECT			0x0124
#define WM_UNINITMENUPOPUP			0x0125
#define WM_MENUCOMMAND				0x0126

#define WM_CHANGEUISTATE			0x0127
#define WM_UPDATEUISTATE			0x0128
#define WM_QUERYUISTATE				0x0129

#define WM_LBTRACKPOINT				0x0131

  /* Win32 CTLCOLOR messages */
#define WM_CTLCOLORMSGBOX			0x0132
#define WM_CTLCOLOREDIT				0x0133
#define WM_CTLCOLORLISTBOX			0x0134
#define WM_CTLCOLORBTN				0x0135
#define WM_CTLCOLORDLG				0x0136
#define WM_CTLCOLORSCROLLBAR		0x0137
#define WM_CTLCOLORSTATIC			0x0138

  /* Mouse messages */
#define WM_MOUSEMOVE				0x0200
#define WM_LBUTTONDOWN				0x0201
#define WM_LBUTTONUP				0x0202
#define WM_LBUTTONDBLCLK			0x0203
#define WM_RBUTTONDOWN				0x0204
#define WM_RBUTTONUP				0x0205
#define WM_RBUTTONDBLCLK			0x0206
#define WM_MBUTTONDOWN				0x0207
#define WM_MBUTTONUP				0x0208
#define WM_MBUTTONDBLCLK			0x0209
#define WM_MOUSEWHEEL				0x020A
#define WM_XBUTTONDOWN				0x020B
#define WM_XBUTTONUP				0x020C
#define WM_XBUTTONDBLCLK			0x020D

#define WM_MOUSEFIRST				0x0200
#define WM_MOUSELAST				0x020D

#define WHEEL_DELTA					120
#define WHEEL_PAGESCROLL			(G_MAXINT)
#define WM_PARENTNOTIFY				0x0210
#define WM_ENTERMENULOOP			0x0211
#define WM_EXITMENULOOP				0x0212
#define WM_NEXTMENU					0x0213

  /* Win32 4.0 messages */
#define WM_SIZING					0x0214
#define WM_CAPTURECHANGED			0x0215
#define WM_MOVING					0x0216
#define WM_POWERBROADCAST			0x0218
#define WM_DEVICECHANGE				0x0219

/* wParam for WM_SIZING message */
#define WMSZ_LEFT					1
#define WMSZ_RIGHT					2
#define WMSZ_TOP					3
#define WMSZ_TOPLEFT				4
#define WMSZ_TOPRIGHT				5
#define WMSZ_BOTTOM					6
#define WMSZ_BOTTOMLEFT				7
#define WMSZ_BOTTOMRIGHT			8

  /* MDI messages */
#define WM_MDICREATE				0x0220
#define WM_MDIDESTROY				0x0221
#define WM_MDIACTIVATE				0x0222
#define WM_MDIRESTORE				0x0223
#define WM_MDINEXT					0x0224
#define WM_MDIMAXIMIZE				0x0225
#define WM_MDITILE					0x0226
#define WM_MDICASCADE				0x0227
#define WM_MDIICONARRANGE			0x0228
#define WM_MDIGETACTIVE				0x0229
#define WM_MDIREFRESHMENU			0x0234

  /* D&D messages */
#define WM_DROPOBJECT				0x022A
#define WM_QUERYDROPOBJECT			0x022B
#define WM_BEGINDRAG				0x022C
#define WM_DRAGLOOP					0x022D
#define WM_DRAGSELECT				0x022E
#define WM_DRAGMOVE					0x022F
#define WM_MDISETMENU				0x0230

#define WM_ENTERSIZEMOVE			0x0231
#define WM_EXITSIZEMOVE				0x0232
#define WM_DROPFILES				0x0233


/* Win32 4.0 messages for IME */
#define WM_IME_SETCONTEXT			0x0281
#define WM_IME_NOTIFY				0x0282
#define WM_IME_CONTROL				0x0283
#define WM_IME_COMPOSITIONFULL		0x0284
#define WM_IME_SELECT				0x0285
#define WM_IME_CHAR					0x0286
/* Win32 5.0 messages for IME */
#define WM_IME_REQUEST				0x0288

/* Win32 4.0 messages for IME */
#define WM_IME_KEYDOWN				0x0290
#define WM_IME_KEYUP				0x0291

/* Clipboard command messages */
#define WM_CUT						0x0300
#define WM_COPY						0x0301
#define WM_PASTE					0x0302
#define WM_CLEAR					0x0303
#define WM_UNDO						0x0304

/* Clipboard owner messages */
#define WM_RENDERFORMAT				0x0305
#define WM_RENDERALLFORMATS			0x0306
#define WM_DESTROYCLIPBOARD			0x0307

/* Clipboard viewer messages */
#define WM_DRAWCLIPBOARD			0x0308
#define WM_PAINTCLIPBOARD			0x0309
#define WM_VSCROLLCLIPBOARD			0x030A
#define WM_SIZECLIPBOARD			0x030B
#define WM_ASKCBFORMATNAME			0x030C
#define WM_CHANGECBCHAIN			0x030D
#define WM_HSCROLLCLIPBOARD			0x030E

#define WM_QUERYNEWPALETTE			0x030F
#define WM_PALETTEISCHANGING		0x0310
#define WM_PALETTECHANGED			0x0311
#define WM_HOTKEY					0x0312

#define WM_PRINT					0x0317
#define WM_PRINTCLIENT				0x0318

#define WM_PENWINFIRST				0x0380
#define WM_PENWINLAST				0x038F


/******************************************************************************
*                                                                             *
*                                                                   *
*                                                                             *
******************************************************************************/
/* Button control styles */
#define BS_PUSHBUTTON			0x00000000L
#define BS_DEFPUSHBUTTON		0x00000001L
#define BS_CHECKBOX				0x00000002L
#define BS_AUTOCHECKBOX			0x00000003L
#define BS_RADIOBUTTON			0x00000004L
#define BS_3STATE				0x00000005L
#define BS_AUTO3STATE			0x00000006L
#define BS_GROUPBOX				0x00000007L
#define BS_USERBUTTON			0x00000008L
#define BS_AUTORADIOBUTTON		0x00000009L
#define BS_OWNERDRAW			0x0000000BL
#define BS_LEFTTEXT				0x00000020L
#define BS_RIGHTBUTTON			BS_LEFTTEXT
#define BS_TEXT					0x00000000L
#define BS_ICON					0x00000040L
#define BS_BITMAP				0x00000080L
#define BS_LEFT					0x00000100L
#define BS_RIGHT				0x00000200L
#define BS_CENTER				0x00000300L
#define BS_TOP					0x00000400L
#define BS_BOTTOM				0x00000800L
#define BS_VCENTER				0x00000C00L
#define BS_PUSHLIKE				0x00001000L
#define BS_MULTILINE			0x00002000L
#define BS_NOTIFY				0x00004000L
#define BS_FLAT					0x00008000L

/* Button notification codes */
#define BN_CLICKED					0
#define BN_PAINT					1
#define BN_HILITE					2
#define BN_UNHILITE					3
#define BN_DISABLE					4
#define BN_DOUBLECLICKED			5
#define BN_DBLCLK					BN_DOUBLECLICKED

/* Button states */
#define BST_UNCHECKED				0x0000
#define BST_CHECKED					0x0001
#define BST_INDETERMINATE			0x0002
#define BST_PUSHED					0x0004
#define BST_FOCUS					0x0008

/* Combo box styles */
#define CBS_SIMPLE					0x0001L
#define CBS_DROPDOWN				0x0002L
#define CBS_DROPDOWNLIST			0x0003L
#define CBS_OWNERDRAWFIXED			0x0010L
#define CBS_OWNERDRAWVARIABLE		0x0020L
#define CBS_AUTOHSCROLL				0x0040L
#define CBS_OEMCONVERT				0x0080L
#define CBS_SORT					0x0100L
#define CBS_HASSTRINGS				0x0200L
#define CBS_NOINTEGRALHEIGHT		0x0400L
#define CBS_DISABLENOSCROLL			0x0800L

 /* Dialog styles */
#define DS_ABSALIGN					0x0001
#define DS_SYSMODAL					0x0002
#define DS_3DLOOK					0x0004	/* win95 */
#define DS_FIXEDSYS					0x0008	/* win95 */
#define DS_NOFAILCREATE				0x0010	/* win95 */
#define DS_LOCALEDIT				0x0020
#define DS_SETFONT					0x0040
#define DS_MODALFRAME				0x0080
#define DS_NOIDLEMSG				0x0100
#define DS_SETFOREGROUND			0x0200	/* win95 */
#define DS_CONTROL					0x0400	/* win95 */
#define DS_CENTER					0x0800	/* win95 */
#define DS_CENTERMOUSE				0x1000	/* win95 */
#define DS_CONTEXTHELP				0x2000	/* win95 */
#define DS_SHELLFONT				(DS_SETFONT | DS_FIXEDSYS)

/* Scrollbar styles */
#define SBS_HORZ					0x0000L
#define SBS_VERT					0x0001L
#define SBS_TOPALIGN				0x0002L
#define SBS_LEFTALIGN				0x0002L
#define SBS_BOTTOMALIGN				0x0004L
#define SBS_RIGHTALIGN				0x0004L
#define SBS_SIZEBOXTOPLEFTALIGN		0x0002L
#define SBS_SIZEBOXBOTTOMRIGHTALIGN	0x0004L
#define SBS_SIZEBOX					0x0008L
#define SBS_SIZEGRIP				0x0010L

/* Static Control Styles */
#define SS_LEFT						0x00000000L
#define SS_CENTER					0x00000001L
#define SS_RIGHT					0x00000002L
#define SS_ICON						0x00000003L
#define SS_BLACKRECT				0x00000004L
#define SS_GRAYRECT					0x00000005L
#define SS_WHITERECT				0x00000006L
#define SS_BLACKFRAME				0x00000007L
#define SS_GRAYFRAME				0x00000008L
#define SS_WHITEFRAME				0x00000009L
#define SS_SIMPLE					0x0000000BL
#define SS_LEFTNOWORDWRAP			0x0000000CL
#define SS_OWNERDRAW				0x0000000DL
#define SS_BITMAP					0x0000000EL
#define SS_ENHMETAFILE				0x0000000FL
#define SS_ETCHEDHORZ				0x00000010L
#define SS_ETCHEDVERT				0x00000011L
#define SS_ETCHEDFRAME				0x00000012L
#define SS_NOPREFIX					0x00000080L
#define SS_NOTIFY					0x00000100L
#define SS_CENTERIMAGE				0x00000200L
#define SS_RIGHTJUST				0x00000400L
#define SS_REALSIZEIMAGE			0x00000800L
#define SS_SUNKEN					0x00001000L

/* Window Styles */
#define WS_OVERLAPPED				0x00000000L
#define WS_POPUP					0x80000000L
#define WS_CHILD					0x40000000L
#define WS_MINIMIZE					0x20000000L
#define WS_VISIBLE					0x10000000L
#define WS_DISABLED					0x08000000L
#define WS_CLIPSIBLINGS				0x04000000L
#define WS_CLIPCHILDREN				0x02000000L
#define WS_MAXIMIZE					0x01000000L
#define WS_CAPTION					0x00C00000L
#define WS_BORDER					0x00800000L
#define WS_DLGFRAME					0x00400000L
#define WS_VSCROLL					0x00200000L
#define WS_HSCROLL					0x00100000L
#define WS_SYSMENU					0x00080000L
#define WS_THICKFRAME				0x00040000L
#define WS_GROUP					0x00020000L
#define WS_TABSTOP					0x00010000L
#define WS_MINIMIZEBOX				0x00020000L
#define WS_MAXIMIZEBOX				0x00010000L
#define WS_TILED					WS_OVERLAPPED
#define WS_ICONIC					WS_MINIMIZE
#define WS_SIZEBOX					WS_THICKFRAME
#define WS_OVERLAPPEDWINDOW			(WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU \
											| WS_THICKFRAME| WS_MINIMIZEBOX	\
															| WS_MAXIMIZEBOX)
#define WS_POPUPWINDOW				(WS_POPUP | WS_BORDER | WS_SYSMENU)
#define WS_CHILDWINDOW				(WS_CHILD)
#define WS_TILEDWINDOW				(WS_OVERLAPPEDWINDOW)


/******************************************************************************
*                                                                             *
* Хå                                                                *
*                                                                             *
******************************************************************************/
LRESULT CALLBACK DefWindowProc(HWND hWnd,UINT Msg,WPARAM wParam,LPARAM lParam);


#ifdef __cplusplus
}
#endif
#endif
