/*
    common
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __COMMON_H__
#define __COMMON_H__


#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef _MSC_VER
# include "config.h.msc"
#endif /* _MSC_VER */


#include <stdio.h>
#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#elif HAVE_STRINGS_H
# include <strings.h>
#endif /* HAVE_STRINGS_H */
#include <gtk/gtk.h>


#define SPACING 5


#if defined USE_THREAD && ! defined G_THREADS_ENABLED
# undef USE_THREAD
#endif


#ifdef G_HAVE_GINT64
typedef gint64 goffset;
#else /* not G_HAVE_GINT64 */
typedef gint32 goffset;
#endif /* not G_HAVE_GINT64 */


#define g_strlen(s) ((s)!=NULL?strlen(s):0)
#define g_strcmp(s1,s2) ((s1)!=NULL && (s2)!=NULL?strcmp(s1,s2):0)
#define g_strncmp(s1,s2,n) ((s1)!=NULL && (s2)!=NULL?strncmp(s1,s2,n):0)
#define g_strchr(s,c) strchr(s,c)
#define g_strrchr(s,c) strrchr(s,c)
#define g_strtok(s,delim) strtok(s,delim)
#define g_memset(s,c,n) memset(s,c,n)
#define g_memcmp(s1,s2,n) memcmp(s1,s2,n)
#define g_strcpy(dest,src) g_strlcpy(dest,src,G_MAXINT)
#define g_strcat(dest,src) g_strlcat(dest,src,G_MAXINT)
#define g_strncpy(dest,src,dest_size) g_strlcpy(dest,src,dest_size)
#define g_strncat(dest,src,dest_size) g_strlcat(dest,src,dest_size)
#define g_strstr(haystack,needle) g_strstr_len(haystack,g_strlen(haystack),needle)
#ifdef G_OS_WIN32
# define g_strfilecmp(s1,s2) g_strcasecmp(s1,s2)
# define g_strfilencmp(s1,s2,n) g_strncasecmp(s1,s2,n)
#else /* not G_OS_WIN32 */
# define g_strfilecmp(s1,s2) g_strcmp(s1,s2)
# define g_strfilencmp(s1,s2,n) g_strncmp(s1,s2,n)
#endif /* not G_OS_WIN32 */

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(String) dgettext(PACKAGE,String)
# ifdef gettext_noop
#   define N_(String) gettext_noop(String)
# else
#   define N_(String) (String)
# endif
#else
# define _(String) (String)
# define N_(String) (String)
# define textdomain(String) (String)
# define gettext(String) (String)
# define dgettext(Domain,String) (String)
# define dcgettext(Domain,String,Type) (String)
# define bindtextdomain(Domain,Directory) (Domain)
#endif


#endif
