/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.helium;

import java.awt.Window;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mirrg.swing.helium.logging.HLog;

public class MenuLookAndFeel
extends JMenu {
    private ButtonGroup buttonGroup = new ButtonGroup();
    private Hashtable<String, JRadioButtonMenuItem> hashClassNameToRadio = new Hashtable();

    public MenuLookAndFeel() {
        super("LookAndFeel(L)");
        this.setMnemonic('L');
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            JRadioButtonMenuItem radio = this.createRadio(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName());
            this.add(radio);
            this.hashClassNameToRadio.put(lookAndFeelInfo.getClassName(), radio);
        }
        this.addActionListener(e -> this.buttonGroup.setSelected(this.hashClassNameToRadio.get(UIManager.getLookAndFeel().getClass()).getModel(), true));
    }

    protected JRadioButtonMenuItem createRadio(String name, String className) {
        JRadioButtonMenuItem radioButtonMenuItem = new JRadioButtonMenuItem();
        radioButtonMenuItem.setText(name);
        radioButtonMenuItem.setActionCommand(className);
        radioButtonMenuItem.setHideActionText(true);
        radioButtonMenuItem.addActionListener(e -> {
            ButtonModel m = this.buttonGroup.getSelection();
            try {
                this.setLookAndFeel(m.getActionCommand());
            }
            catch (Exception e1) {
                HLog.processException(e1);
            }
        });
        this.buttonGroup.add(radioButtonMenuItem);
        return radioButtonMenuItem;
    }

    public void setLookAndFeel(String lookAndFeel) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(lookAndFeel);
        this.updateLookAndFeel();
    }

    private void updateLookAndFeel() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }
}

