/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public class ToolCursorSelectArea
extends ToolCursor {
    private Point begin;
    private Point end;

    public ToolCursorSelectArea(IFrameGameAlmandine frameGameAlmandine) {
        super(frameGameAlmandine);
        this.eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
            this.begin = this.getCoord(e.mouseEvent);
            this.mouseDragged(e.mouseEvent);
        });
        this.eventManager.register(NitrogenEventMouse.Released.class, e -> {
            this.mouseDragged(e.mouseEvent);
            if (this.begin == null) {
                return;
            }
            if (this.end == null) {
                return;
            }
            Rectangle area = new Rectangle(Math.min(this.begin.x, this.end.x), Math.min(this.begin.y, this.end.y), Math.abs(this.end.x - this.begin.x), Math.abs(this.end.y - this.begin.y));
            this.begin = null;
            this.end = null;
            if (e.mouseEvent.isControlDown()) {
                Factory.filterClass(this.getFactory().getEntities(), Primary.class).filter(primary -> {
                    try {
                        return primary.isContained(area);
                    }
                    catch (IllegalEntityIdException e1) {
                        return false;
                    }
                }).forEach(furniture -> {
                    furniture.selected = !furniture.selected;
                });
            } else {
                this.getFactory().resetSelection();
                Factory.filterClass(this.getFactory().getEntities(), Primary.class).filter(primary -> {
                    try {
                        return primary.isContained(area);
                    }
                    catch (IllegalEntityIdException e1) {
                        return false;
                    }
                }).forEach(furniture -> {
                    furniture.selected = true;
                });
            }
        });
        this.eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> this.mouseDragged(e.mouseEvent));
        this.eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
            if (this.begin == null) {
                return;
            }
            if (this.end == null) {
                return;
            }
            Rectangle area = new Rectangle(Math.min(this.begin.x, this.end.x), Math.min(this.begin.y, this.end.y), Math.abs(this.end.x - this.begin.x), Math.abs(this.end.y - this.begin.y));
            frameGameAlmandine.doTranslate(e.graphics, () -> {
                Factory.filterClass(this.getFactory().getEntities(), Primary.class).filter(primary -> {
                    try {
                        return primary.isContained(area);
                    }
                    catch (IllegalEntityIdException e1) {
                        return false;
                    }
                }).forEach(furniture -> {
                    try {
                        furniture.drawHover(render.graphics);
                    }
                    catch (IllegalEntityIdException illegalEntityIdException) {
                        // empty catch block
                    }
                });
                render.graphics.setColor(new Color(1079951715, true));
                render.graphics.fill(area);
                render.graphics.setColor(new Color(-799096477, true));
                render.graphics.draw(area);
            });
        });
    }

    public void mouseDragged(MouseEvent e) {
        this.end = this.getCoord(e);
    }

    @Override
    public String getLocalizedName() {
        return "\u7bc4\u56f2\u9078\u629e";
    }

    @Override
    public String getLocalizedDescription() {
        return "\u5de6\u30c9\u30e9\u30c3\u30b0\u3067\u7bc4\u56f2\u306b\u5b8c\u5168\u306b\u542b\u307e\u308c\u308b\u30a2\u30a4\u30c6\u30e0\u3092\u9078\u629e\u3001Ctrl\u3067\u9078\u629e\u5207\u308a\u66ff\u3048";
    }
}

