/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Stroke;
import javax.swing.SwingUtilities;
import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.HRender;

public class ToolCursorScreen
extends ToolCursor {
    private Point beginLeft;
    private Point beginRight;
    private Point endLeft;
    private Point endRight;

    public ToolCursorScreen(IFrameGameAlmandine frameGameAlmandine) {
        super(frameGameAlmandine);
        this.eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
            if (e.mouseEvent.getButton() == 1) {
                this.beginLeft = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());
                this.endLeft = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());
            } else if (e.mouseEvent.getButton() == 3) {
                this.beginRight = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());
                this.endRight = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());
            }
        });
        this.eventManager.register(NitrogenEventMouse.Released.class, e -> {
            if (e.mouseEvent.getButton() == 1) {
                this.beginLeft = null;
                this.endLeft = null;
            } else if (e.mouseEvent.getButton() == 3) {
                this.beginRight = null;
                this.endRight = null;
            }
        });
        this.eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> {
            if (this.beginLeft != null) {
                Point now = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());
                this.getGame().getOffsetX().value += now.x - this.endLeft.x;
                this.getGame().getOffsetY().value += now.y - this.endLeft.y;
                this.endLeft = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());
            }
            if (this.beginRight != null) {
                this.endRight = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());
            }
        });
        this.eventManager.register(NitrogenEventToolCursor.Tick.class, e -> {
            if (this.beginRight != null) {
                SwingUtilities.invokeLater(() -> {
                    if (this.beginRight == null) {
                        return;
                    }
                    if (this.endRight == null) {
                        return;
                    }
                    this.getGame().getOffsetX().value += (int)((double)(this.endRight.x - this.beginRight.x) * 0.1);
                    this.getGame().getOffsetY().value += (int)((double)(this.endRight.y - this.beginRight.y) * 0.1);
                });
            }
        });
        this.eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
            if (this.beginLeft != null) {
                e.graphics.setColor(Color.red);
                e.graphics.drawLine(this.beginLeft.x, this.beginLeft.y, this.endLeft.x, this.endLeft.y);
            }
            if (this.beginRight != null) {
                e.graphics.setColor(Color.red);
                Stroke stroke = e.graphics.getStroke();
                e.graphics.setStroke(new BasicStroke(2.0f));
                e.graphics.drawOval(this.beginRight.x - 6, this.beginRight.y - 6, 12, 12);
                e.graphics.setStroke(stroke);
                HRender.drawLine(e.graphics, this.beginRight, this.endRight, 7.0, 0.0, 0.0, 1.0);
            }
        });
    }

    @Override
    public String getLocalizedName() {
        return "\u753b\u9762";
    }

    @Override
    public String getLocalizedDescription() {
        return "\u5de6\u30c9\u30e9\u30c3\u30b0\u3067\u753b\u9762\u79fb\u52d5\u3001\u53f3\u30c9\u30e9\u30c3\u30b0\u30db\u30fc\u30eb\u30c9\u3067\u6ed1\u3089\u304b\u306b\u753b\u9762\u79fb\u52d5";
    }
}

