/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Map;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.ManagerEnvironment;

public class ToolCursorEnvironment
extends ToolCursor {
    private Point point;
    private Point pointCoord;

    public ToolCursorEnvironment(IFrameGameAlmandine frameGameAlmandine) {
        super(frameGameAlmandine);
        this.eventManager.register(NitrogenEventMouseMotion.Moved.class, e -> this.mouseMoved(e.mouseEvent));
        this.eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> this.mouseMoved(e.mouseEvent));
        this.eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
            if (this.point == null) {
                return;
            }
            if (this.pointCoord == null) {
                return;
            }
            e.graphics.setColor(Color.black);
            e.graphics.setFont(new Font("SansSerif", 0, 14));
            int i = 1;
            Environment environment = ManagerEnvironment.getEnvironment(this.getGame(), this.pointCoord);
            for (Map.Entry<String, Integer> entry : environment.integers.entrySet()) {
                e.graphics.drawString("" + entry.getKey() + ": " + entry.getValue(), this.point.x + 20, this.point.y + e.graphics.getFont().getSize() * i);
                ++i;
            }
            for (Map.Entry<String, Number> entry : environment.doubles.entrySet()) {
                e.graphics.drawString("" + entry.getKey() + ": " + entry.getValue(), this.point.x + 20, this.point.y + e.graphics.getFont().getSize() * i);
                ++i;
            }
            for (Map.Entry<String, Object> entry : environment.strings.entrySet()) {
                e.graphics.drawString("" + entry.getKey() + ": " + (String)entry.getValue(), this.point.x + 20, this.point.y + e.graphics.getFont().getSize() * i);
                ++i;
            }
            for (Map.Entry<String, Object> entry : environment.booleans.entrySet()) {
                e.graphics.drawString("" + entry.getKey() + ": " + entry.getValue(), this.point.x + 20, this.point.y + e.graphics.getFont().getSize() * i);
                ++i;
            }
        });
    }

    public void mouseMoved(MouseEvent e) {
        this.point = this.getPoint(e);
        this.pointCoord = this.getCoord(e);
    }

    @Override
    public String getLocalizedName() {
        return "\u74b0\u5883\u8abf\u67fb";
    }

    @Override
    public String getLocalizedDescription() {
        return "\u30de\u30a6\u30b9\u30aa\u30fc\u30d0\u30fc\u3067\u5730\u70b9\u306e\u74b0\u5883\u5b9a\u6570\u3092\u8868\u793a";
    }
}

