/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public class ModuleClickEntity<E extends Entity> {
    protected IFrameGameAlmandine frameGameAlmandine;
    protected IntPredicate predicateButton;
    protected BiConsumer<MouseEvent, E> listener;
    protected IGetEntities<E> getEntities;
    protected E entity;

    public ModuleClickEntity(IFrameGameAlmandine frameGameAlmandine, IntPredicate predicateButton, BiConsumer<MouseEvent, E> listener, IGetEntities<E> getEntities) {
        this.frameGameAlmandine = frameGameAlmandine;
        this.predicateButton = predicateButton;
        this.listener = listener;
        this.getEntities = getEntities;
    }

    public void apply(ToolCursor toolCursor) {
        toolCursor.eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
            this.update(e.mouseEvent);
            if (this.predicateButton.test(e.mouseEvent.getButton()) && this.entity != null) {
                this.listener.accept(e.mouseEvent, this.entity);
                this.entity = null;
            }
        });
        toolCursor.eventManager.register(NitrogenEventMouseMotion.Moved.class, e -> this.update(e.mouseEvent));
        toolCursor.eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
            if (this.entity != null) {
                this.frameGameAlmandine.doTranslate(e.graphics, () -> {
                    try {
                        ((Entity)this.entity).drawHover(render.graphics);
                    }
                    catch (IllegalEntityIdException illegalEntityIdException) {
                        // empty catch block
                    }
                });
            }
        });
    }

    private Factory getFactory() {
        return this.frameGameAlmandine.getGame().factory;
    }

    public void update(MouseEvent e) {
        this.entity = this.getEntities.apply(this.getFactory(), new Point(this.frameGameAlmandine.getXCoord(e.getX()), this.frameGameAlmandine.getYCoord(e.getY()))).stream().findFirst().orElse(null);
    }

    public static interface IGetEntities<E> {
        public ArrayList<? extends E> apply(Factory var1, Point var2);
    }
}

