/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.stations;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;

public class StationThrough
extends StationBase {
    @Deprecated
    public StationThrough() {
    }

    public StationThrough(GameAlmandine game, Point point, int radius) {
        super(game, point, radius);
    }

    @Override
    protected int getColor() {
        return 2449;
    }

    @Override
    public void tick(double deltaSecond) throws IllegalEntityIdException {
        Cart cart = this.getCartPrimary().orElse(null);
        if (cart == null) {
            return;
        }
        this.getRailRandom(cart).ifPresent(rail -> this.emitCart(cart, (RailBase)rail));
    }

    protected Optional<RailBase> getRailRandom(Cart cart) {
        ArrayList rails = this.getRails().collect(Collectors.toCollection(ArrayList::new));
        if (rails.size() == 0) {
            return Optional.empty();
        }
        if (rails.size() == 1) {
            return Optional.of(rails.get(0));
        }
        rails = rails.stream().filter(rail -> rail.getId() != ((Cart.PositionStation)cart.position).idRailFrom).collect(Collectors.toCollection(ArrayList::new));
        return Optional.of(rails.get((int)(Math.random() * (double)rails.size())));
    }

    protected void drawMarkerDirection(Graphics2D graphics, String direction, boolean coming) {
        StationBase.Direction direction2 = StationBase.Direction.valueOf(direction);
        if (direction2 == null) {
            return;
        }
        if (direction2 != StationBase.Direction.UNDEFINED) {
            graphics.translate(this.x, this.y);
            graphics.rotate(direction2.angle);
            graphics.setColor(Color.red);
            int a = coming ? -5 : 5;
            graphics.fillPolygon(new int[]{this.radius + 9 - a, this.radius + 9 - a, this.radius + 9 + a, this.radius + 9 - a}, new int[]{4, -4, 0, 4}, 4);
            graphics.rotate(-direction2.angle);
            graphics.translate(-this.x, -this.y);
        }
    }
}

