/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.stations;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.stream.Stream;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;
import mirrg.simulation.cart.almandine.mods.vanilla.stations.StationThrough;

public class StationIntegrate
extends StationThrough {
    public String direction;

    @Deprecated
    public StationIntegrate() {
    }

    public StationIntegrate(GameAlmandine game, Point point, int radius) {
        super(game, point, radius);
    }

    @Override
    protected int getColor() {
        return 2449;
    }

    @Override
    public void draw(Graphics2D graphics) {
        super.draw(graphics);
        graphics.setFont(new Font("SansSerif", 0, 12));
        graphics.setColor(Color.black);
        String text = "Integrate";
        int width = graphics.getFontMetrics().stringWidth(text);
        graphics.drawString(text, this.x - width / 2, this.y - this.radius - 6);
        this.drawMarkerDirection(graphics, this.direction, false);
    }

    @Override
    public void tick(double deltaSecond) throws IllegalEntityIdException {
        Cart cart;
        if (this.direction == null) {
            this.direction = "UNDEFINED";
        }
        if ((cart = (Cart)this.getCartPrimary().orElse(null)) == null) {
            return;
        }
        StationBase.Direction direction2 = StationBase.Direction.valueOf(this.direction);
        if (direction2 == null || direction2 == StationBase.Direction.UNDEFINED) {
            return;
        }
        RailBase rail = this.getRail(direction2).orElse(null);
        if (rail == null) {
            return;
        }
        if (rail.getId() == ((Cart.PositionStation)cart.position).idRailFrom) {
            super.tick(deltaSecond);
            return;
        }
        this.emitCart(cart, rail);
    }

    @Override
    protected void addProperty(IDialogProperty dialogProperty) {
        super.addProperty(dialogProperty);
        dialogProperty.addPropertyComboBox("Direction", Stream.of(StationBase.Direction.values()), () -> StationBase.Direction.valueOf(this.direction), direction -> {
            this.direction = direction.name();
            return true;
        });
    }
}

