/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.stackslabs.basic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;

public class StackSlabBasic
implements IStackSlab {
    public int amount;

    @Deprecated
    public StackSlabBasic() {
    }

    public StackSlabBasic(int amount) {
        this.amount = amount;
    }

    @Override
    public IStackSlab tryPop(int amount) {
        if (this.amount < amount) {
            this.amount = 0;
            return new StackSlabBasic(this.amount);
        }
        this.amount -= amount;
        return new StackSlabBasic(amount);
    }

    @Override
    public void push(IStackSlab stack) {
        this.amount += stack.getAmount();
        stack.clear();
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void clear() {
        this.amount = 0;
    }

    @Override
    public void addProperty(Factory factory, IDialogProperty dialogProperty) {
        dialogProperty.addPropertyInt("Amount", "\u500b", () -> this.amount, amount -> {
            if (amount <= 0) {
                return false;
            }
            this.amount = amount;
            return true;
        });
    }

    @Override
    public void renderGauge(Graphics2D graphics, Rectangle bound, int capacity) {
        graphics.setColor(new Color(0x800000));
        int h = (int)(bound.getHeight() * (double)this.amount / (double)capacity);
        graphics.fillRect((int)bound.getMinX(), (int)bound.getMaxY() - h, (int)bound.getWidth(), h);
    }

    @Override
    public void tick(Factory factory, double deltaSecond, Environment environment) {
    }
}

