/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.rails;

import java.awt.Point;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;

public class RailAutoDistance
extends RailBase {
    public double distancePerPixel;

    @Deprecated
    public RailAutoDistance() {
    }

    public RailAutoDistance(GameAlmandine game, StationBase begin, StationBase end, double distancePerPixel) {
        super(game, begin, end);
        this.distancePerPixel = distancePerPixel;
    }

    @Override
    protected int getColor() {
        return 9194752;
    }

    @Override
    protected void addProperty(IDialogProperty dialogProperty) {
        super.addProperty(dialogProperty);
        dialogProperty.addPropertyDouble("DistancePerPixel", "m/px", () -> this.distancePerPixel, distancePerPixel -> {
            if (distancePerPixel < 0.0) {
                return false;
            }
            this.distancePerPixel = distancePerPixel;
            return true;
        });
        dialogProperty.addPropertyDouble("Distance", "m", () -> {
            try {
                return this.getDistance();
            }
            catch (IllegalEntityIdException e) {
                return 0.0;
            }
        }, distancePerPixel -> false);
    }

    @Override
    public double getDistance() throws IllegalEntityIdException {
        Point pointBegin = ((StationBase)this.getEntity(this.idBegin)).getPoint();
        Point pointEnd = ((StationBase)this.getEntity(this.idEnd)).getPoint();
        return pointBegin.distance(pointEnd) * this.distancePerPixel;
    }
}

