/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import java.awt.Graphics2D;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Part;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Gauge;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.PrimaryRectangleBase;

public abstract class Furniture
extends PrimaryRectangleBase {
    @Deprecated
    public Furniture() {
    }

    public Furniture(GameAlmandine game, Bound bound) {
        super(game, bound);
    }

    @Override
    public void move(int dx, int dy) {
        super.move(dx, dy);
        this.getSlots().forEach(slot -> slot.move(dx, dy));
        this.getGauges().forEach(gauge -> gauge.move(dx, dy));
        this.getStations().forEach(station -> station.move(dx, dy));
    }

    @Override
    public void tick(double deltaSecond) throws IllegalEntityIdException {
        Consumer<Entity> consumer = entity -> {
            try {
                entity.tick(deltaSecond);
            }
            catch (IllegalEntityIdException illegalEntityIdException) {
                // empty catch block
            }
        };
        this.getSlots().forEach(consumer);
        this.getGauges().forEach(consumer);
        this.getStations().forEach(consumer);
    }

    @Override
    public void draw(Graphics2D graphics) throws IllegalEntityIdException {
        super.draw(graphics);
        this.getSlots().forEach(entity -> this.draw((Entity)entity, graphics));
        this.getGauges().forEach(entity -> this.draw((Entity)entity, graphics));
        this.getStations().forEach(entity -> this.draw((Entity)entity, graphics));
    }

    private void draw(Entity entity, Graphics2D graphics) {
        try {
            entity.draw(graphics);
        }
        catch (IllegalEntityIdException illegalEntityIdException) {
            // empty catch block
        }
    }

    protected Stream<SlotBase> getSlots() {
        return Stream.empty();
    }

    protected Stream<Gauge> getGauges() {
        return Stream.empty();
    }

    protected Stream<StationBase> getStations() {
        return Stream.empty();
    }

    @Override
    public Stream<Part> getChildren() {
        return Stream.of(this.getSlots(), this.getGauges(), this.getStations()).flatMap(stream -> stream);
    }
}

