/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Optional;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.mods.vanilla.enchant.EnchantCart;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.ManagerEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.SlotSlab;

public class Cart
extends Primary {
    public SlotSlab slot;
    public IPosition position;
    public double speed;
    public ArrayList<EnchantCart> enchants = new ArrayList();

    @Deprecated
    public Cart() {
    }

    public Cart(GameAlmandine game, IPosition position, int capacity, double speed) throws IllegalEntityIdException {
        super(game);
        this.position = position;
        this.slot = new SlotSlab(capacity);
        this.speed = speed;
    }

    @Override
    public void draw(Graphics2D graphics) throws IllegalEntityIdException {
        Point point = this.getPoint();
        double angle = this.position.getAngle(this.game.factory);
        graphics.translate(point.x, point.y);
        graphics.rotate(angle);
        graphics.setColor(new Color(this.getEnvironment().getInteger("colorBackground").orElse(0x886644)));
        graphics.fillRect(-20, -8, 40, 16);
        graphics.setColor(new Color(0x444444));
        graphics.drawRect(-21, -9, 41, 17);
        graphics.rotate(1.5707963267948966);
        this.slot.render(graphics, new Rectangle(-5, -17, 10, 34));
        graphics.rotate(-1.5707963267948966);
        graphics.rotate(-angle);
        graphics.translate(-point.x, -point.y);
    }

    @Override
    public void drawOverlay(Graphics2D graphics) throws IllegalEntityIdException {
        if (this.selected) {
            Point point = this.getPoint();
            int radius = 18;
            Stroke stroke = graphics.getStroke();
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.setColor(new Color(255, 128, 0));
            graphics.draw(new Ellipse2D.Double(point.x - radius, point.y - radius, radius * 2, radius * 2));
            graphics.setStroke(stroke);
        }
    }

    @Override
    public void drawHover(Graphics2D graphics) throws IllegalEntityIdException {
        Point point = this.getPoint();
        int radius = 18;
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(new Color(8125570));
        graphics.draw(new Ellipse2D.Double(point.x - radius, point.y - radius, radius * 2, radius * 2));
        graphics.setStroke(stroke);
    }

    @Override
    public boolean isContained(Rectangle rectangle) throws IllegalEntityIdException {
        return rectangle.contains(this.getPoint());
    }

    @Override
    public boolean isHover(int x, int y) throws IllegalEntityIdException {
        return this.getPoint().distanceSq(x, y) < 196.0;
    }

    @Override
    public void tick(double deltaSecond) throws IllegalEntityIdException {
        if (this.position instanceof PositionRail) {
            PositionRail positionRail = (PositionRail)this.position;
            double deltaX = this.speed * deltaSecond;
            RailBase rail = positionRail.getRail(this.game.factory);
            double deltaRate = deltaX / rail.getDistance();
            positionRail.position = positionRail.position + deltaRate * (double)(positionRail.direction ? 1 : -1);
            if (positionRail.position <= 0.0) {
                StationBase stationBase = (StationBase)rail.getEntity(rail.idBegin);
                this.position = new PositionStation(stationBase.getId(), stationBase.freeOrder(), rail.getId());
            } else if (positionRail.position >= 1.0) {
                StationBase station = (StationBase)rail.getEntity(rail.idEnd);
                this.position = new PositionStation(station.getId(), station.freeOrder(), rail.getId());
            }
        }
        if (this.slot.stack != null) {
            this.slot.stack.tick(this.game.factory, deltaSecond, this.getEnvironment());
        }
    }

    public Environment getEnvironment() throws IllegalEntityIdException {
        Environment environment = ManagerEnvironment.getEnvironment(this.game, this.getPoint());
        this.enchants.forEach(enchant -> {
            if (enchant instanceof IProviderEnvironment) {
                ((IProviderEnvironment)((Object)enchant)).getEnvironment(environment);
            }
        });
        return environment;
    }

    @Override
    public Point getPoint() throws IllegalEntityIdException {
        Point2D.Double point = this.position.getPoint(this.game.factory);
        return new Point((int)point.x, (int)point.y);
    }

    @Override
    protected void addProperty(IDialogProperty dialogProperty) {
        super.addProperty(dialogProperty);
        this.slot.addProperty(this.game.factory, dialogProperty);
        dialogProperty.addPropertyDouble("Speed", "m/s", () -> this.speed, speed -> {
            if (speed < 0.0) {
                return false;
            }
            this.speed = speed;
            return true;
        });
        dialogProperty.addPropertyInt("IdRail (Rail)", "id", () -> {
            if (this.position instanceof PositionRail) {
                return ((PositionRail)this.position).idRail;
            }
            return -1;
        }, idRail -> {
            if (this.position instanceof PositionRail) {
                if (!this.game.factory.getEntity(idRail, RailBase.class).isPresent()) {
                    return false;
                }
                ((PositionRail)this.position).idRail = idRail;
                return true;
            }
            return false;
        });
        dialogProperty.addPropertyDouble("Position (Rail)", "ratio", () -> {
            if (this.position instanceof PositionRail) {
                return ((PositionRail)this.position).position;
            }
            return -1.0;
        }, position -> {
            if (this.position instanceof PositionRail) {
                if (position < 0.0) {
                    return false;
                }
                if (position > 1.0) {
                    return false;
                }
                ((PositionRail)this.position).position = position;
                return true;
            }
            return false;
        });
        dialogProperty.addPropertyBoolean("Direction == POSITIVE (Rail)", () -> {
            if (this.position instanceof PositionRail) {
                return ((PositionRail)this.position).direction;
            }
            return false;
        }, direction -> {
            if (this.position instanceof PositionRail) {
                ((PositionRail)this.position).direction = direction;
                return true;
            }
            return false;
        });
        dialogProperty.addPropertyInt("IdStation (Station)", "id", () -> {
            if (this.position instanceof PositionStation) {
                return ((PositionStation)this.position).idStation;
            }
            return -1;
        }, idStation -> {
            if (this.position instanceof PositionStation) {
                if (!this.game.factory.getEntity(idStation, StationBase.class).isPresent()) {
                    return false;
                }
                ((PositionStation)this.position).idStation = idStation;
                return true;
            }
            return false;
        });
        dialogProperty.addPropertyInt("Order (Station)", "int:0~", () -> {
            if (this.position instanceof PositionStation) {
                return ((PositionStation)this.position).order;
            }
            return -1;
        }, order -> {
            if (this.position instanceof PositionStation) {
                ((PositionStation)this.position).order = order;
                return true;
            }
            return false;
        });
        dialogProperty.addPropertyInt("IdRailFrom (Station)", "id", () -> {
            if (this.position instanceof PositionStation) {
                return ((PositionStation)this.position).idRailFrom;
            }
            return -1;
        }, idRailFrom -> {
            if (this.position instanceof PositionStation) {
                if (!this.game.factory.getEntity(idRailFrom, RailBase.class).isPresent()) {
                    return false;
                }
                ((PositionStation)this.position).idRailFrom = idRailFrom;
                return true;
            }
            return false;
        });
        this.enchants.forEach(enchant -> enchant.addProperty(dialogProperty));
    }

    public static class PositionRail
    implements IPosition {
        public int idRail;
        public double position;
        public boolean direction;

        public PositionRail() {
        }

        public PositionRail(int idRail, double position, boolean direction) {
            this.idRail = idRail;
            this.position = position;
            this.direction = direction;
        }

        @Override
        public Point2D.Double getPoint(Factory factory) throws IllegalEntityIdException {
            return this.getRail(factory).getPoint(this.position);
        }

        @Override
        public double getAngle(Factory factory) throws IllegalEntityIdException {
            return this.getRail(factory).getAngle();
        }

        public RailBase getRail(Factory factory) throws IllegalEntityIdException {
            return factory.getEntityOrThrow(this.idRail, RailBase.class);
        }
    }

    public static class PositionStation
    implements IPosition {
        public int idStation;
        public int order;
        public int idRailFrom;

        public PositionStation() {
        }

        public PositionStation(int idStation, int order) {
            this(idStation, order, -1);
        }

        public PositionStation(int idStation, int order, int idRailFrom) {
            this.idStation = idStation;
            this.order = order;
            this.idRailFrom = idRailFrom;
        }

        @Override
        public Point2D.Double getPoint(Factory factory) throws IllegalEntityIdException {
            StationBase station = this.getStation(factory);
            Point point = station.getPoint();
            point.translate(0, station.radius + 2);
            point.translate(0, 20 * this.order);
            return new Point2D.Double(point.x, point.y);
        }

        @Override
        public double getAngle(Factory factory) throws IllegalEntityIdException {
            return 0.0;
        }

        public StationBase getStation(Factory factory) throws IllegalEntityIdException {
            return factory.getEntityOrThrow(this.idStation, StationBase.class);
        }

        public Optional<RailBase> getRailFrom(Factory factory) {
            Entity entity = factory.getEntity(this.idRailFrom).orElse(null);
            if (entity == null) {
                return Optional.empty();
            }
            if (!(entity instanceof RailBase)) {
                return Optional.empty();
            }
            return Optional.of((RailBase)entity);
        }
    }

    public static interface IPosition {
        public Point2D.Double getPoint(Factory var1) throws IllegalEntityIdException;

        public double getAngle(Factory var1) throws IllegalEntityIdException;
    }
}

