/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.PrimaryConnection;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.ManagerEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.SlotSlab;

public class Arm
extends PrimaryConnection<SlotBase> {
    public double position = 0.0;
    public double duration;
    public SlotSlab slot;

    @Deprecated
    public Arm() {
    }

    public Arm(GameAlmandine game, SlotBase begin, SlotBase end, double duration) throws IllegalEntityIdException {
        super(game, begin, end);
        this.duration = duration;
        this.slot = new SlotSlab(1);
    }

    @Override
    protected Class<SlotBase> getClassEntity() {
        return SlotBase.class;
    }

    @Override
    public void tick(double deltaSecond) throws IllegalEntityIdException {
        super.tick(deltaSecond);
        if (!this.slot.isEmpty()) {
            this.position += deltaSecond;
            if (this.position >= this.duration) {
                ((SlotBase)this.getEntity(this.idEnd)).getSlotSlab().ifPresent(slotSlab -> slotSlab.tryPush(this.slot));
                this.position = this.duration;
            }
        } else {
            this.position -= deltaSecond;
            if (this.position <= 0.0) {
                ((SlotBase)this.getEntity(this.idBegin)).getSlotSlab().ifPresent(slotSlab -> {
                    this.slot.stack = slotSlab.tryPop(1);
                });
                this.position = 0.0;
            }
        }
        if (this.slot.stack != null) {
            this.slot.stack.tick(this.game.factory, deltaSecond, ManagerEnvironment.getEnvironment(this.game, this.getPoint()));
        }
    }

    @Override
    public void drawBody(Graphics2D graphics) throws IllegalEntityIdException {
        Point begin = ((SlotBase)this.getEntity(this.idBegin)).getPoint();
        Point end = ((SlotBase)this.getEntity(this.idEnd)).getPoint();
        Color c = new Color(35071);
        graphics.setColor(c);
        this.drawMargined(graphics, begin, end, 0.0, 1.0);
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(c);
        graphics.draw(new Ellipse2D.Double(begin.x - 5, begin.y - 5, 10.0, 10.0));
        graphics.setStroke(stroke);
        double angle = Math.atan2(end.y - begin.y, end.x - begin.x);
        Stroke stroke2 = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(c);
        graphics.draw(new Line2D.Double(end.x, end.y, (double)end.x - 5.0 * Math.sin(angle) - 8.0 * Math.cos(angle), (double)end.y - 8.0 * Math.sin(angle) + 5.0 * Math.cos(angle)));
        graphics.draw(new Line2D.Double(end.x, end.y, (double)end.x + 5.0 * Math.sin(angle) - 8.0 * Math.cos(angle), (double)end.y - 8.0 * Math.sin(angle) - 5.0 * Math.cos(angle)));
        graphics.setStroke(stroke2);
        double radius = 3.0;
        graphics.setColor(new Color(0xDD9900));
        graphics.fill(new Ellipse2D.Double((double)begin.x + this.position / this.duration * (double)(end.x - begin.x) - radius, (double)begin.y + this.position / this.duration * (double)(end.y - begin.y) - radius, radius * 2.0, radius * 2.0));
    }

    @Override
    protected void addProperty(IDialogProperty dialogProperty) {
        super.addProperty(dialogProperty);
        dialogProperty.addPropertyDouble("Position", "s", () -> this.position, position -> {
            if (position < 0.0) {
                return false;
            }
            this.position = position;
            return true;
        });
        dialogProperty.addPropertyDouble("Duration", "s", () -> this.duration, duration -> {
            if (duration < 0.0) {
                return false;
            }
            this.duration = duration;
            return true;
        });
        this.slot.addProperty(this.game.factory, dialogProperty);
    }

    @Override
    protected double getMarginBegin() {
        return 5.0;
    }

    @Override
    protected double getMarginEnd() {
        return 0.0;
    }
}

