/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.parts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Part;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;

public abstract class PartRectangleBase
extends Part {
    public Bound bound;

    @Deprecated
    public PartRectangleBase() {
    }

    public PartRectangleBase(GameAlmandine game, Bound bound) {
        super(game);
        this.bound = bound;
    }

    @Override
    public boolean isContained(Rectangle rectangle) throws IllegalEntityIdException {
        return this.bound.contained(rectangle);
    }

    @Override
    public boolean isHover(int x, int y) {
        return this.bound.contains(x, y);
    }

    public void move(int dx, int dy) {
        this.bound = this.bound.translate(dx, dy);
    }

    @Override
    public void drawHover(Graphics2D graphics) {
        graphics.setColor(new Color(8125570));
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.draw(this.bound.grow(5).createShape());
        graphics.setStroke(stroke);
    }

    @Override
    protected void addProperty(IDialogProperty dialogProperty) {
        super.addProperty(dialogProperty);
        dialogProperty.addPropertyInt("X", "px", () -> this.bound.getX(), x -> {
            this.bound = new Bound(x, this.bound.getY(), this.bound.getWidth(), this.bound.getHeight());
            return true;
        });
        dialogProperty.addPropertyInt("Y", "px", () -> this.bound.getY(), y -> {
            this.bound = new Bound(this.bound.getX(), y, this.bound.getWidth(), this.bound.getHeight());
            return true;
        });
        dialogProperty.addPropertyInt("Width", "px", () -> this.bound.getWidth(), width -> {
            this.bound = new Bound(this.bound.getX(), this.bound.getY(), width, this.bound.getHeight());
            return true;
        });
        dialogProperty.addPropertyInt("Height", "px", () -> this.bound.getHeight(), height -> {
            this.bound = new Bound(this.bound.getX(), this.bound.getY(), this.bound.getWidth(), height);
            return true;
        });
    }

    @Override
    public Point getPoint() throws IllegalEntityIdException {
        return this.bound.getCenter();
    }
}

