/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.parts;

import java.awt.Point;
import java.awt.Rectangle;

public class Bound {
    private int x;
    private int y;
    private int width;
    private int height;

    @Deprecated
    public Bound() {
    }

    public Bound(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Bound(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Bound grow(int margin) {
        return new Bound(this.x - margin, this.y - margin, this.width + margin * 2, this.height + margin * 2);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Bound translate(int dx, int dy) {
        return new Bound(this.x + dx, this.y + dy, this.width, this.height);
    }

    public Bound resize(int width, int height) {
        return new Bound(this.x, this.y, width, height);
    }

    public Rectangle createShape() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public boolean contains(int x, int y) {
        if (x < this.x) {
            return false;
        }
        if (x > this.x + this.width) {
            return false;
        }
        if (y < this.y) {
            return false;
        }
        return y <= this.y + this.height;
    }

    public boolean contains(Bound bound) {
        return this.contains(bound.x, bound.y) && this.contains(bound.x + bound.width, bound.y + bound.height);
    }

    public boolean contained(Rectangle rectangle) {
        return rectangle.contains(this.x, this.y) && rectangle.contains(this.x + this.width, this.y + this.height);
    }

    public boolean contained(Bound bound) {
        return bound.contains(this);
    }

    public Bound grow(int left, int top, int right, int bottom) {
        return new Bound(this.x - left, this.y - top, this.width + left + right, this.height + top + bottom);
    }

    public Point getCenter() {
        return new Point(this.x + this.width / 2, this.y + this.height / 2);
    }
}

