/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.furnitures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.stream.Stream;
import javax.swing.JButton;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Furniture;
import mirrg.simulation.cart.almandine.mods.vanilla.slots.SlotModule;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslabs.thermo.IStackSlabThermo;
import mirrg.swing.helium.GroupBuilder;

public class FurnitureThermometer
extends Furniture {
    public double sumTemperature;
    public int count;
    public SlotModule slotA;
    public SlotModule slotB;

    @Deprecated
    public FurnitureThermometer() {
    }

    public FurnitureThermometer(GameAlmandine game, Point point) throws IllegalEntityIdException {
        super(game, new Bound(point.x - 50, point.y - 20, 100, 40));
        this.slotA = new SlotModule(game, new Bound(point.x - 48, point.y - 18, 16, 16), 1);
        this.slotB = new SlotModule(game, new Bound(point.x - 48, point.y + 2, 16, 16), 1);
    }

    @Override
    protected Stream<SlotBase> getSlots() {
        return Stream.of(this.slotA, this.slotB);
    }

    @Override
    protected void drawBody(Graphics2D graphics) {
        graphics.setColor(new Color(16767214));
        graphics.fill(this.bound.createShape());
        graphics.setColor(new Color(0));
        graphics.draw(this.bound.grow(1, 1, 0, 0).createShape());
        graphics.setFont(new Font("SansSerif", 0, 14));
        graphics.drawString(String.format("\u6e29\u5ea6: %.1f", this.count == 0 ? 0.0 : this.sumTemperature / (double)this.count), this.bound.getX() + 20, this.bound.getY() + this.bound.getHeight() / 2 + graphics.getFont().getSize() * 0);
        graphics.drawString("\u500b\u6570: " + this.count, this.bound.getX() + 20, this.bound.getY() + this.bound.getHeight() / 2 + graphics.getFont().getSize() * 1);
    }

    @Override
    public void tick(double deltaSecond) throws IllegalEntityIdException {
        super.tick(deltaSecond);
        this.analyze();
    }

    protected void analyze() {
        int amount;
        if (!this.slotB.slot.isEmpty()) {
            return;
        }
        if (this.slotA.slot.isEmpty()) {
            return;
        }
        double temperature = 0.0;
        if (this.slotA.slot.stack instanceof IStackSlabThermo) {
            temperature = ((IStackSlabThermo)this.slotA.slot.stack).getTemperatureMean();
        }
        if ((amount = this.slotB.slot.tryPush(this.slotA.slot)) >= 1) {
            this.count += amount;
            this.sumTemperature += temperature;
        }
    }

    @Override
    protected void addProperty(IDialogProperty dialogProperty) {
        super.addProperty(dialogProperty);
        dialogProperty.addPropertyDouble("Sum Temperature", "C\u30fb\u500b", () -> this.sumTemperature, sumTemperature -> {
            this.sumTemperature = sumTemperature;
            return true;
        });
        dialogProperty.addPropertyDouble("Average Temperature", "C", () -> this.count == 0 ? 0.0 : this.sumTemperature / (double)this.count, temperature -> {
            if (temperature <= 0.0) {
                return false;
            }
            this.sumTemperature = temperature * (double)this.count;
            return true;
        });
        dialogProperty.addPropertyInt("Count", "\u500b", () -> this.count, count -> {
            if (count < 0) {
                return false;
            }
            this.count = count;
            return true;
        });
        JButton button = new JButton("\u30ea\u30bb\u30c3\u30c8");
        button.addActionListener(e -> {
            this.sumTemperature = 0.0;
            this.count = 0;
        });
        dialogProperty.addComponent(GroupBuilder.group(button));
    }
}

