/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla;

import java.awt.Color;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Vector;
import java.util.function.BooleanSupplier;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.swing.helium.DialogMirrg;
import mirrg.swing.helium.GroupBuilder;

public class DialogPropertyToolCursor
extends DialogMirrg
implements IDialogProperty {
    private String name;
    private ArrayList<GroupBuilder> groupBuilders = new ArrayList();

    public DialogPropertyToolCursor(JFrame frame, String name) {
        super((Frame)frame, "\u30d7\u30ed\u30d1\u30c6\u30a3: " + name);
        this.name = name;
        this.enabledTick = true;
        this.setDefaultCloseOperation(2);
    }

    @Override
    protected void componentShown() {
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.groupBuilders.add(0, GroupBuilder.group(new JLabel(this.name)));
        GroupBuilder.group(this.groupBuilders.toArray(new GroupBuilder[0])).apply(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.setLayout(layout);
        this.pack();
        Point mouse = MouseInfo.getPointerInfo().getLocation();
        mouse.translate(-this.getWidth() / 2, -this.getHeight() / 2);
        this.setLocation(mouse);
    }

    @Override
    public void addComponent(GroupBuilder groupBuilder) {
        this.groupBuilders.add(groupBuilder);
    }

    @Override
    public void addPropertyInt(String name, String unit, IntSupplier getter, IntPredicate setter) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel((Number)0, null, null, (Number)1));
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(10);
        this.onTick.add(() -> {
            if (!spinner.isFocusOwner()) {
                spinner.setValue(getter.getAsInt());
            }
        });
        spinner.addChangeListener(e -> {
            int value = ((Number)spinner.getValue()).intValue();
            if (setter.test(value)) {
                spinner.setBackground(Color.white);
            } else {
                spinner.setBackground(new Color(0xFFBABA));
            }
            spinner.setValue(value);
        });
        this.groupBuilders.add(GroupBuilder.group(new JLabel(name), spinner, new JLabel(" [" + unit + "]")));
    }

    @Override
    public void addPropertyDouble(String name, String unit, DoubleSupplier getter, DoublePredicate setter) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel((Number)0.0, null, null, (Number)1.0));
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(10);
        this.onTick.add(() -> {
            if (!spinner.isFocusOwner()) {
                spinner.setValue(getter.getAsDouble());
            }
        });
        spinner.addChangeListener(e -> {
            double value = ((Number)spinner.getValue()).doubleValue();
            if (setter.test(value)) {
                spinner.setBackground(Color.white);
            } else {
                spinner.setBackground(new Color(0xFFBABA));
            }
            spinner.setValue(value);
        });
        this.groupBuilders.add(GroupBuilder.group(new JLabel(name), spinner, new JLabel(" [" + unit + "]")));
    }

    @Override
    public void addPropertyString(String name, Supplier<String> getter, Predicate<String> setter) {
        JTextField textField = new JTextField();
        textField.setColumns(10);
        this.onTick.add(() -> {
            if (!textField.isFocusOwner()) {
                textField.setText((String)getter.get());
            }
        });
        textField.addActionListener(e -> {
            if (setter.test(textField.getText())) {
                textField.setBackground(Color.white);
            } else {
                textField.setBackground(new Color(0xFFBABA));
            }
        });
        this.groupBuilders.add(GroupBuilder.group(new JLabel(name), textField));
    }

    @Override
    public void addPropertyBoolean(String name, BooleanSupplier getter, Predicate<Boolean> setter) {
        JCheckBox checkBox = new JCheckBox(name);
        this.onTick.add(() -> {
            if (!checkBox.isFocusOwner()) {
                checkBox.setSelected(getter.getAsBoolean());
            }
        });
        checkBox.addActionListener(e -> {
            if (setter.test(checkBox.isSelected())) {
                checkBox.setBackground(Color.white);
            } else {
                checkBox.setBackground(new Color(0xFFBABA));
            }
        });
        this.groupBuilders.add(GroupBuilder.group(checkBox));
    }

    @Override
    public <T> void addPropertyComboBox(String name, Stream<T> items, Supplier<T> getter, Predicate<T> setter) {
        ArrayList listItem = items.collect(Collectors.toCollection(ArrayList::new));
        JComboBox comboBox = new JComboBox(new Vector(listItem));
        comboBox.addActionListener(e -> setter.test(comboBox.getSelectedItem()));
        this.onTick.add(() -> {
            if (!comboBox.isFocusOwner()) {
                comboBox.setSelectedItem(getter.get());
            }
        });
        this.groupBuilders.add(GroupBuilder.group(new JLabel(name), comboBox));
    }

    @Override
    public void open() {
        this.setVisible(true);
    }
}

