/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui.toolcursors;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.entities.Entity;
import mirrg.simulation.cart.almandine.gui.FrameMain;
import mirrg.simulation.cart.almandine.gui.ToolCursor;

public abstract class ToolCursorPutConnectionBase<E extends Entity>
extends ToolCursor {
    private E begin;
    private Point pointEnd;
    private E end;

    public ToolCursorPutConnectionBase(FrameMain frameMain) {
        super(frameMain);
    }

    public abstract ArrayList<E> getEntities(Factory var1, int var2, int var3);

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseMoved(e);
        this.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.begin = this.getEntities(this.frameMain.getFactory(), this.frameMain.getXCoord(e), this.frameMain.getYCoord(e)).stream().findFirst().orElse(null);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.begin == null) {
            return;
        }
        this.pointEnd = new Point(this.frameMain.getXCoord(e), this.frameMain.getYCoord(e));
        this.end = this.getEntities(this.frameMain.getFactory(), this.frameMain.getXCoord(e), this.frameMain.getYCoord(e)).stream().findFirst().orElse(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (this.begin == null) {
                return;
            }
            this.mouseDragged(e);
            if (this.end == null) {
                return;
            }
            if (this.begin == this.end) {
                return;
            }
            this.add(this.begin, this.end);
        }
        finally {
            this.begin = null;
            this.pointEnd = null;
            this.end = null;
        }
    }

    protected abstract void add(E var1, E var2);

    @Override
    public void render(Graphics2D graphics) {
        if (this.begin == null) {
            return;
        }
        this.frameMain.pushTanslate(graphics);
        if (this.end != null) {
            graphics.setColor(new Color(0xFF0000));
            try {
                Point pointBegin = this.begin.getPoint(this.frameMain.getFactory());
                Point pointEnd = this.end.getPoint(this.frameMain.getFactory());
                graphics.drawLine(pointBegin.x, pointBegin.y, pointEnd.x, pointEnd.y);
            }
            catch (IllegalEntityIdException e) {
                // empty catch block
            }
            try {
                this.begin.renderHover(this.frameMain.getFactory(), graphics);
                this.end.renderHover(this.frameMain.getFactory(), graphics);
            }
            catch (IllegalEntityIdException e) {}
        } else if (this.pointEnd != null) {
            graphics.setColor(new Color(0xFF0000));
            try {
                Point pointBegin = this.begin.getPoint(this.frameMain.getFactory());
                graphics.drawLine(pointBegin.x, pointBegin.y, this.pointEnd.x, this.pointEnd.y);
            }
            catch (IllegalEntityIdException e) {
                // empty catch block
            }
            try {
                this.begin.renderHover(this.frameMain.getFactory(), graphics);
            }
            catch (IllegalEntityIdException e) {}
        } else {
            try {
                this.begin.renderHover(this.frameMain.getFactory(), graphics);
            }
            catch (IllegalEntityIdException illegalEntityIdException) {
                // empty catch block
            }
        }
        this.frameMain.popTanslate(graphics);
    }
}

