/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import mirrg.applet.nitrogen.AppletNitrogen;
import mirrg.applet.nitrogen.HAppletNitrogen;
import mirrg.applet.nitrogen.events.NitrogenEventApplet;
import mirrg.applet.nitrogen.events.NitrogenEventGameThread;
import mirrg.applet.nitrogen.events.NitrogenEventKey;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.RegistryToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.TabItem;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public class PanelAlmandine
extends AppletNitrogen {
    private IFrameGameAlmandine frameGameAlmandine;
    public ToolCursor toolCursor;
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("M\u6708d\u65e5 H\u6642m\u5206s\u79d2 SSS");

    public PanelAlmandine(IFrameGameAlmandine frameGameAlmandine) {
        this.frameGameAlmandine = frameGameAlmandine;
        HAppletNitrogen.ResponceApplyStandard responce = HAppletNitrogen.applyStandard(this);
        this.toolCursor = new ToolCursor(frameGameAlmandine){

            @Override
            public String getLocalizedName() {
                return "\u306a\u3057";
            }

            @Override
            public String getLocalizedDescription() {
                return "";
            }
        };
        this.getEventManager().register(NitrogenEventGameThread.Tick.class, event -> {
            frameGameAlmandine.getGame().tick();
            this.toolCursor.eventManager.post(new NitrogenEventToolCursor.Tick());
        });
        this.getEventManager().register(NitrogenEventGameThread.Render.class, event -> {
            responceApplyStandard.gameThread.objectiveFps = iFrameGameAlmandine.getGame().getFPS().value;
            this.repaint();
        });
        this.getEventManager().register(NitrogenEventApplet.Paint.class, event -> {
            this.renderAll(responce);
            responceApplyStandard.tripleBuffer.flip();
            event.graphics.drawImage(responceApplyStandard.tripleBuffer.getBufferSafety().getBuffer(), 0, 0, this);
        });
        this.getEventManager().register(Object.class, e -> this.toolCursor.eventManager.post(e));
        this.getEventManager().register(NitrogenEventKey.Released.class, e -> RegistryToolCursor.instance.find(e.keyEvent).ifPresent(TabItem::action));
        this.getEventManager().register(NitrogenEventKey.class, e -> frameGameAlmandine.getFrame().getContentPane().dispatchEvent(e.keyEvent));
        this.setPreferredSize(new Dimension(600, 600));
    }

    private void renderAll(HAppletNitrogen.ResponceApplyStandard responce) {
        Graphics2D graphics = responce.tripleBuffer.getBufferDirty().getGraphics();
        graphics.setTransform(new AffineTransform());
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.setBackground(Color.white);
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.frameGameAlmandine.getGame().render(graphics, this.frameGameAlmandine);
        this.toolCursor.eventManager.post(new NitrogenEventToolCursor.Render(graphics));
        this.renderGUI(graphics, responce);
    }

    private void renderGUI(Graphics2D graphics, HAppletNitrogen.ResponceApplyStandard responce) {
        graphics.setFont(new Font("SansSerif", 0, 14));
        int size = graphics.getFont().getSize();
        graphics.setColor(Color.black);
        int row = 1;
        graphics.drawString(String.format("\u30ab\u30fc\u30bd\u30eb\u30c4\u30fc\u30eb: %s", this.toolCursor.getLocalizedName()), 0, size * row);
        graphics.drawString(String.format("\u30ab\u30fc\u30bd\u30eb\u30c4\u30fc\u30eb\u8aac\u660e: %s", this.toolCursor.getLocalizedDescription()), 0, size * ++row);
        graphics.drawString(String.format("TickPerFrame: %s, SecondPerTick: %s", this.frameGameAlmandine.getGame().getTickPerFrame().value, this.frameGameAlmandine.getGame().getSecondPerTick().value), 0, size * ++row);
        Instant base = LocalDateTime.of(2000, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC);
        LocalDateTime time = LocalDateTime.ofInstant(base.plusMillis((long)(this.frameGameAlmandine.getGame().getTime().value * 1000.0)), ZoneOffset.UTC);
        graphics.drawString(String.format("\u6642\u9593: %s \u5e74 %s", time.getYear() - 2000, time.format(this.formatter)), 0, size * ++row);
        graphics.drawString(String.format("FPS: %.2f", responce.fpsAdjuster.getFPS()), 0, this.getHeight());
        graphics.drawString(String.format("CPU: %.2f%%", responce.fpsAdjuster.getLoadFactor() * 100.0), 0, this.getHeight() - size);
    }
}

