/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui;

import java.awt.CardLayout;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.ICreatorDialogProperty;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.facroty.property.RegistryDialogProperty;
import mirrg.simulation.cart.almandine.gui.DialogPrimaries;
import mirrg.simulation.cart.almandine.gui.DialogTools;
import mirrg.simulation.cart.almandine.gui.PanelAlmandine;
import mirrg.simulation.cart.almandine.gui.toolcursor.ShortcutKey;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mod.HAlmandineForge;
import mirrg.simulation.cart.almandine.mod.NitrogenEventAlmandine;
import mirrg.swing.helium.FrameMirrg;
import mirrg.swing.helium.logging.FrameLog;
import mirrg.swing.helium.logging.HLog;
import mirrg.swing.helium.property.DialogProperties;
import mirrg.util.HString;

public class FrameAlmandine
extends FrameMirrg
implements IFrameGameAlmandine {
    private DialogProperties dialogProperties = null;
    private DialogTools dialogTools = null;
    private DialogPrimaries dialogPrimaries = null;
    private final PanelAlmandine panel;
    private GameAlmandine game;
    private String suffixTitle = "Almandine Cart Simulator";
    private static final FileNameExtensionFilter FILTER = new FileNameExtensionFilter("Almandine\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb(*.alm)", "alm");
    private JFileChooser _fileChooser = null;
    private File file = null;

    public FrameAlmandine() {
        this.resetGame();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        menuBar.add(menu);
        menu.setMnemonic('F');
        final JMenuItem menuItem = new JMenuItem("\u958b\u304f...(O)");
        menu.add(menuItem);
        menuItem.setAccelerator(new ShortcutKey(79).control().toKeyStroke());
        menuItem.setMnemonic('O');
        menuItem.addActionListener(e -> this.showDialogLoad());
        menuItem = new JMenuItem("\u4e0a\u66f8\u304d\u4fdd\u5b58(S)");
        menu.add(menuItem);
        menuItem.setAccelerator(new ShortcutKey(83).control().toKeyStroke());
        menuItem.setMnemonic('S');
        menuItem.addActionListener(e -> {
            if (this.file != null) {
                this.getGame().save(this.file);
            } else {
                this.showDialogSave();
            }
        });
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                menuItem.setEnabled(FrameAlmandine.this.file != null);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        menuItem = new JMenuItem("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58...(A)");
        menu.add(menuItem);
        menuItem.setAccelerator(new ShortcutKey(65).control().toKeyStroke());
        menuItem.setMnemonic('A');
        menuItem.addActionListener(e -> this.showDialogSave());
        menu.addSeparator();
        menuItem = new JMenuItem("\u30d5\u30a1\u30af\u30c8\u30ea\u30fc\u306e\u521d\u671f\u5316...(N)");
        menu.add(menuItem);
        menuItem.setAccelerator(new ShortcutKey(78).control().toKeyStroke());
        menuItem.setMnemonic('N');
        menuItem.addActionListener(e -> {
            this.resetGame();
            HLog.fine("\u30d5\u30a1\u30af\u30c8\u30ea\u3092\u521d\u671f\u5316\u3057\u307e\u3057\u305f\u3002");
        });
        menu = new JMenu("\u30a6\u30a3\u30f3\u30c9\u30a6(W)");
        menuBar.add(menu);
        menu.setMnemonic('W');
        menuItem = new JMenuItem("\u30c4\u30fc\u30eb...(T)");
        menu.add(menuItem);
        menuItem.setAccelerator(new ShortcutKey(84).control().toKeyStroke());
        menuItem.setMnemonic('T');
        menuItem.addActionListener(e -> {
            if (this.dialogTools == null) {
                this.dialogTools = new DialogTools(this);
            }
            this.dialogTools.setVisible(true);
        });
        this.hookDisposed(e -> {
            if (this.dialogTools != null) {
                this.dialogTools.dispose();
            }
        });
        menuItem = new JMenuItem("\u30d7\u30e9\u30a4\u30de\u30ea\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3...(E)");
        menu.add(menuItem);
        menuItem.setAccelerator(new ShortcutKey(69).control().toKeyStroke());
        menuItem.setMnemonic('E');
        menuItem.addActionListener(e -> {
            if (this.dialogPrimaries == null) {
                this.dialogPrimaries = new DialogPrimaries(this);
            }
            this.dialogPrimaries.setVisible(true);
        });
        this.hookDisposed(e -> {
            if (this.dialogPrimaries != null) {
                this.dialogPrimaries.dispose();
            }
        });
        menuItem = new JMenuItem("\u30d7\u30ed\u30d1\u30c6\u30a3\u30de\u30cd\u30fc\u30b8\u30e3...(P)");
        menu.add(menuItem);
        menuItem.setAccelerator(new ShortcutKey(80).control().toKeyStroke());
        menuItem.setMnemonic('P');
        menuItem.addActionListener(e -> {
            if (this.dialogProperties == null) {
                this.dialogProperties = new DialogProperties((Frame)this, () -> this.getGame().managerProperty);
            }
            this.dialogProperties.setVisible(true);
        });
        this.hookDisposed(e -> {
            if (this.dialogProperties != null) {
                this.dialogProperties.dispose();
            }
        });
        menuItem = new JMenuItem("\u30ed\u30b0\u30a6\u30a3\u30f3\u30c9\u30a6...(L)");
        menu.add(menuItem);
        menuItem.setAccelerator(new ShortcutKey(76).control().toKeyStroke());
        menuItem.setMnemonic('L');
        menuItem.addActionListener(e -> {
            FrameLog frame = new FrameLog(200);
            this.hookDisposed(e2 -> frame.dispose());
            frame.setVisible(true);
        });
        menu.addSeparator();
        menuItem = new JMenuItem("\u30c4\u30fc\u30eb\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u521d\u671f\u5316(R)");
        menu.add(menuItem);
        menuItem.setMnemonic('R');
        menuItem.addActionListener(e -> {
            if (this.dialogProperties != null) {
                this.dialogProperties.dispose();
                this.dialogProperties = null;
            }
            if (this.dialogTools != null) {
                this.dialogTools.dispose();
                this.dialogTools = null;
            }
            if (this.dialogPrimaries != null) {
                this.dialogPrimaries.dispose();
                this.dialogPrimaries = null;
            }
        });
        menu = new JMenu("\u9032\u884c\u901f\u5ea6(S)");
        menuBar.add(menu);
        menu.setMnemonic('S');
        this.addMenuItemSpped(menu, "\u505c\u6b62", '0', 48, 1.0, 0);
        this.addMenuItemSpped(menu, ">", '1', 49, 1.0, 1);
        this.addMenuItemSpped(menu, ">", '2', 50, 1.0, 3);
        this.addMenuItemSpped(menu, ">", '3', 51, 1.0, 10);
        this.addMenuItemSpped(menu, ">", '4', 52, 1.0, 30);
        this.addMenuItemSpped(menu, ">", '5', 53, 1.0, 60);
        this.addMenuItemSpped(menu, ">", '6', 54, 1.0, 100);
        this.addMenuItemSpped(menu, ">>", '7', 55, 3.0, 60);
        this.addMenuItemSpped(menu, ">>", '8', 56, 10.0, 60);
        this.addMenuItemSpped(menu, ">>", '9', 57, 60.0, 60);
        this.setLayout(new CardLayout());
        this.panel = new PanelAlmandine(this);
        this.getContentPane().add(this.panel);
        this.hookInitialized(e -> this.panel.init());
        this.hookShown(e -> this.panel.start());
        this.hookHidden(e -> this.panel.stop());
        this.hookDisposed(e -> this.panel.destroy());
        URL url = this.getClass().getResource("icon.png");
        if (url != null) {
            this.setIconImage(new ImageIcon(url).getImage());
        } else {
            HLog.warning("\u30a2\u30a4\u30b3\u30f3\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        this.hookShown(e -> this.updateTitle());
        this.prepareFrame();
    }

    public void resetGame() {
        this.game = new GameAlmandine();
        HAlmandineForge.eventManager.post(new NitrogenEventAlmandine.CreatedGame(this.game));
        this.game.getTickPerFrame().value = 0;
        this.file = null;
        this.updateTitle();
    }

    private void addMenuItemSpped(JMenu menu, String title, char mnemonic, int keyCode, double secondPerTick, int tickPerFrame) {
        JMenuItem menuItem = new JMenuItem(String.format("%s (spt=%s, tpf=%s)(%s)", title, secondPerTick, tickPerFrame, Character.valueOf(mnemonic)));
        menu.add(menuItem);
        menuItem.setAccelerator(new ShortcutKey(keyCode).toKeyStroke());
        menuItem.setMnemonic(mnemonic);
        menuItem.addActionListener(e -> {
            this.game.getSecondPerTick().value = secondPerTick;
            this.game.getTickPerFrame().value = tickPerFrame;
        });
    }

    public void updateTitle() {
        StringBuilder sb = new StringBuilder();
        if (this.file != null) {
            sb.append(HString.deleteExtension(this.file.getName()));
        }
        if (sb.length() != 0) {
            sb.append(" - ");
        }
        sb.append(this.suffixTitle);
        this.setTitle(sb.toString());
    }

    private JFileChooser getFileChooser() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.addChoosableFileFilter(FILTER);
            this._fileChooser.setAcceptAllFileFilterUsed(true);
            this._fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        return this._fileChooser;
    }

    private void showDialogLoad() {
        JFileChooser fileChooser = this.getFileChooser();
        int res = fileChooser.showOpenDialog(this);
        if (res == 1) {
            HLog.info("\u30c0\u30a4\u30a2\u30ed\u30b0\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
            return;
        }
        if (res == -1) {
            HLog.error("\u30c0\u30a4\u30a2\u30ed\u30b0\u4e0a\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff01: " + res);
            return;
        }
        File file = fileChooser.getSelectedFile();
        GameAlmandine game = GameAlmandine.load(file);
        if (game != null) {
            this.game = game;
            HLog.fine("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u6b63\u5e38\u306b\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f\u3002: " + file.getPath());
            this.file = file;
            this.updateTitle();
            game.getTickPerFrame().value = 0;
        }
    }

    private void showDialogSave() {
        JFileChooser fileChooser = this.getFileChooser();
        int res = fileChooser.showSaveDialog(this);
        if (res == 1) {
            HLog.info("\u30c0\u30a4\u30a2\u30ed\u30b0\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
            return;
        }
        if (res == -1) {
            HLog.error("\u30c0\u30a4\u30a2\u30ed\u30b0\u4e0a\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff01: " + res);
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (fileChooser.getFileFilter() == FILTER) {
            String path = file.getAbsolutePath();
            if (path.equals(HString.deleteExtension(path))) {
                path = path + ".alm";
            }
            file = new File(path);
        }
        this.file = file;
        this.updateTitle();
        this.getGame().save(file);
    }

    @Override
    public GameAlmandine getGame() {
        return this.game;
    }

    @Override
    public int getScreenWidth() {
        return this.panel.getWidth();
    }

    @Override
    public int getScreenHeight() {
        return this.panel.getHeight();
    }

    @Override
    public FrameMirrg getFrame() {
        return this;
    }

    @Override
    public ToolCursor getToolCursor() {
        return this.panel.toolCursor;
    }

    @Override
    public void setToolCursor(ToolCursor toolCursor) {
        this.panel.toolCursor = toolCursor;
    }

    @Override
    public Optional<IDialogProperty> createDialogProperty(String name) {
        String idDialogProperty = this.game.getIdDialogProperty().value;
        Optional<ICreatorDialogProperty> optionalCreatorDialogProperty = RegistryDialogProperty.instance.get(idDialogProperty);
        if (!optionalCreatorDialogProperty.isPresent()) {
            HLog.warning("unknown DialogProperty ID: " + idDialogProperty);
        }
        return optionalCreatorDialogProperty.map(creatorDialogProperty -> creatorDialogProperty.create(this, name));
    }
}

