/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;

public abstract class Entity {
    @XStreamOmitField
    protected GameAlmandine game;
    private int id;

    @Deprecated
    public Entity() {
    }

    public Entity(GameAlmandine game) {
        this.game = game;
        this.id = game.factory.freeId();
    }

    public void setFactoryAll(GameAlmandine game) {
        this.game = game;
    }

    public int getId() {
        return this.id;
    }

    public void tick(double deltaSecond) throws IllegalEntityIdException {
    }

    public double getDurationVoid() throws IllegalEntityIdException {
        return 1.0;
    }

    public abstract void draw(Graphics2D var1) throws IllegalEntityIdException;

    public abstract void drawOverlay(Graphics2D var1) throws IllegalEntityIdException;

    public abstract void drawHover(Graphics2D var1) throws IllegalEntityIdException;

    public abstract boolean isContained(Rectangle var1) throws IllegalEntityIdException;

    public abstract boolean isHover(int var1, int var2) throws IllegalEntityIdException;

    public boolean isHover(Point point) throws IllegalEntityIdException {
        return this.isHover(point.x, point.y);
    }

    public void openWindowProperty(IFrameGameAlmandine frameGameAlmandine) {
        IDialogProperty dialogProperty = frameGameAlmandine.createDialogProperty(this.getClass().getSimpleName()).orElse(null);
        if (dialogProperty == null) {
            return;
        }
        this.addProperty(dialogProperty);
        frameGameAlmandine.getFrame().hookHidden(e -> dialogProperty.dispose());
        dialogProperty.open();
    }

    protected void addProperty(IDialogProperty dialogProperty) {
        dialogProperty.addPropertyInt("Id", "id", () -> this.id, id -> {
            if (this.game.factory.getEntity(id).isPresent()) {
                return false;
            }
            this.game.factory.hookEditPrimaries(() -> {
                this.id = id;
            });
            return true;
        });
    }

    public abstract Point getPoint() throws IllegalEntityIdException;
}

