/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.converters.ConversionException;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Supplier;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.swing.helium.logging.HLog;
import mirrg.swing.helium.property.ManagerProperty;
import mirrg.swing.helium.property.PropertyDouble;
import mirrg.swing.helium.property.PropertyInteger;
import mirrg.swing.helium.property.PropertyString;

public class GameAlmandine {
    public ManagerProperty managerProperty = new ManagerProperty();
    @XStreamOmitField
    private Supplier<PropertyInteger> propertyTickPerFrame;
    @XStreamOmitField
    private Supplier<PropertyDouble> propertySecondPerTick;
    @XStreamOmitField
    private Supplier<PropertyInteger> propertyOffsetX;
    @XStreamOmitField
    private Supplier<PropertyInteger> propertyOffsetY;
    @XStreamOmitField
    private Supplier<PropertyDouble> propertyFPS;
    @XStreamOmitField
    private Supplier<PropertyDouble> propertyTime;
    @XStreamOmitField
    private Supplier<PropertyString> propertyIdDialogProperty;
    public Factory factory = new Factory();

    private Supplier<PropertyInteger> getOrCreatePropertyInteger(int defaultValue, String id, String name) {
        return this.managerProperty.getOrCreateProperty(PropertyInteger::new, PropertyInteger.class, defaultValue, id, name);
    }

    private Supplier<PropertyDouble> getOrCreatePropertyDouble(Double defaultValue, String id, String name) {
        return this.managerProperty.getOrCreateProperty(PropertyDouble::new, PropertyDouble.class, defaultValue, id, name);
    }

    private Supplier<PropertyString> getOrCreatePropertyString(String defaultValue, String id, String name) {
        return this.managerProperty.getOrCreateProperty(PropertyString::new, PropertyString.class, defaultValue, id, name);
    }

    public PropertyInteger getTickPerFrame() {
        if (this.propertyTickPerFrame == null) {
            this.propertyTickPerFrame = this.getOrCreatePropertyInteger(1, "panel.tickPerFrame", "1\u63cf\u753b\u30d5\u30ec\u30fc\u30e0\u3042\u305f\u308a\u306eTick\u6570[t/f]");
        }
        return this.propertyTickPerFrame.get();
    }

    public PropertyDouble getSecondPerTick() {
        if (this.propertySecondPerTick == null) {
            this.propertySecondPerTick = this.getOrCreatePropertyDouble(2.0, "panel.secondPerTick", "1Tick\u3042\u305f\u308a\u306e\u9032\u884c\u6642\u9593[s/t]");
        }
        return this.propertySecondPerTick.get();
    }

    public PropertyInteger getOffsetX() {
        if (this.propertyOffsetX == null) {
            this.propertyOffsetX = this.getOrCreatePropertyInteger(0, "panel.offsetX", "\u753b\u9762\u4e2d\u592e\u306e\u5ea7\u6a19X[px]");
        }
        return this.propertyOffsetX.get();
    }

    public PropertyInteger getOffsetY() {
        if (this.propertyOffsetY == null) {
            this.propertyOffsetY = this.getOrCreatePropertyInteger(0, "panel.offsetY", "\u753b\u9762\u4e2d\u592e\u306e\u5ea7\u6a19Y[px]");
        }
        return this.propertyOffsetY.get();
    }

    public PropertyDouble getFPS() {
        if (this.propertyFPS == null) {
            this.propertyFPS = this.getOrCreatePropertyDouble(60.0, "panel.fps", "\u63cf\u753bFPS[frame/s]");
        }
        return this.propertyFPS.get();
    }

    public PropertyDouble getTime() {
        if (this.propertyTime == null) {
            this.propertyTime = this.getOrCreatePropertyDouble(0.0, "factory.time", "\u7d4c\u904e\u6642\u9593[s]");
        }
        return this.propertyTime.get();
    }

    public PropertyString getIdDialogProperty() {
        if (this.propertyIdDialogProperty == null) {
            this.propertyIdDialogProperty = this.getOrCreatePropertyString("null:null", "panel.idDialogProperty", "\u30d7\u30ed\u30d1\u30c6\u30a3\u30c0\u30a4\u30a2\u30ed\u30b0\u30d7\u30ed\u30d0\u30a4\u30c0ID");
        }
        return this.propertyIdDialogProperty.get();
    }

    public void tick() {
        for (int i = 0; i < this.getTickPerFrame().value; ++i) {
            this.factory.tick(this.getSecondPerTick().value);
            this.factory.processEditPrimaries();
            this.getTime().value += this.getSecondPerTick().value;
        }
        if (this.getTickPerFrame().value == 0) {
            this.factory.processEditPrimaries();
        }
    }

    public void render(Graphics2D graphics, IFrameGameAlmandine frameGameAlmandine) {
        this.factory.render(graphics, frameGameAlmandine);
    }

    public boolean save(File file) {
        if (file.exists()) {
            Path pathBackup = new File(file.getAbsolutePath() + ".orig").toPath();
            try {
                Files.copy(file.toPath(), pathBackup, StandardCopyOption.REPLACE_EXISTING);
                HLog.fine("\u53e4\u3044\u8a2d\u5b9a\u30c7\u30fc\u30bf\u3092\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3057\u307e\u3057\u305f: " + pathBackup);
            }
            catch (IOException e) {
                HLog.processException(e, "\u53e4\u3044\u8a2d\u5b9a\u30c7\u30fc\u30bf\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + pathBackup, false);
            }
        }
        try {
            XStream xStream = new XStream();
            xStream.autodetectAnnotations(true);
            xStream.toXML((Object)this, new FileOutputStream(file));
        }
        catch (FileNotFoundException e2) {
            HLog.processException(e2);
            return false;
        }
        HLog.fine("\u8a2d\u5b9a\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f: " + file.getPath());
        return true;
    }

    public static GameAlmandine load(File file) {
        Object data;
        if (file.exists()) {
            try {
                data = new XStream().fromXML(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                HLog.processExceptionUnexpected(e);
                return null;
            }
            catch (ConversionException e) {
                HLog.processException(e, "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u304a\u308a\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\uff01: " + file.getPath(), true);
                return null;
            }
        } else {
            HLog.error("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\uff01: " + file.getPath());
            return null;
        }
        if (!(data instanceof GameAlmandine)) {
            HLog.error("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\uff01: " + file.getPath());
            return null;
        }
        GameAlmandine game = (GameAlmandine)data;
        game.factory.onLoad(game);
        return game;
    }
}

