/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.nitrogen;

import mirrg.applet.nitrogen.AppletNitrogen;
import mirrg.applet.nitrogen.FPSAdjuster;
import mirrg.applet.nitrogen.GameThread;
import mirrg.applet.nitrogen.HAppletNitrogenEvent;
import mirrg.applet.nitrogen.InputStatus;
import mirrg.applet.nitrogen.TripleBuffer;
import mirrg.applet.nitrogen.events.NitrogenEventApplet;
import mirrg.applet.nitrogen.events.NitrogenEventGameThread;
import mirrg.applet.nitrogen.events.NitrogenEventKey;
import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.applet.nitrogen.events.NitrogenEventMouseWheel;

public class HAppletNitrogen {
    public static ResponceApplyStandard applyStandard(AppletNitrogen appletNitrogen) {
        appletNitrogen.setFocusable(true);
        HAppletNitrogenEvent.adaptMouseEvent(appletNitrogen);
        HAppletNitrogenEvent.adaptMouseMotionEvent(appletNitrogen);
        HAppletNitrogenEvent.adaptMouseWheelEvent(appletNitrogen);
        HAppletNitrogenEvent.adaptKeyEvent(appletNitrogen);
        HAppletNitrogenEvent.adaptComponentEvent(appletNitrogen);
        ResponceApplyStandard responce = new ResponceApplyStandard();
        responce.gameThread = HAppletNitrogen.applyGameThread(appletNitrogen);
        responce.fpsAdjuster = HAppletNitrogen.applyFPS(appletNitrogen, responce.gameThread);
        responce.tripleBuffer = HAppletNitrogen.applyTripleBuffer(appletNitrogen);
        responce.inputStatus = HAppletNitrogen.applyInputStatus(appletNitrogen);
        return responce;
    }

    public static GameThread applyGameThread(AppletNitrogen appletNitrogen) {
        GameThread gameThread = new GameThread();
        Thread[] thread = new Thread[]{null};
        appletNitrogen.getEventManager().register(NitrogenEventApplet.Start.class, event -> {
            threadArray[0] = new Thread(() -> {
                while (true) {
                    NitrogenEventGameThread.Sleep event2 = new NitrogenEventGameThread.Sleep(gameThread, thread[0]);
                    appletNitrogen.getEventManager().post(event2);
                    if (!event2.cancelled) {
                        try {
                            Thread.sleep((long)(1000.0 / gameThread.objectiveFps));
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    if (event2.interrupted) break;
                    appletNitrogen.getEventManager().post(new NitrogenEventGameThread.Tick(gameThread, thread[0]));
                    appletNitrogen.getEventManager().post(new NitrogenEventGameThread.PostTick(gameThread, thread[0]));
                    appletNitrogen.getEventManager().post(new NitrogenEventGameThread.Render(gameThread, thread[0]));
                }
            });
            thread[0].setDaemon(true);
            appletNitrogen.getEventManager().post(new NitrogenEventGameThread.Init(gameThread, thread[0]));
            thread[0].start();
        });
        appletNitrogen.getEventManager().register(NitrogenEventApplet.Stop.class, event -> thread[0].interrupt());
        return gameThread;
    }

    public static TripleBuffer applyTripleBuffer(AppletNitrogen appletNitrogen) {
        TripleBuffer tripleBuffer = new TripleBuffer();
        appletNitrogen.getEventManager().register(NitrogenEventApplet.Paint.Pre.class, event -> {
            event.cancelled = true;
        });
        tripleBuffer.subscribeEvent(appletNitrogen.getEventManager());
        return tripleBuffer;
    }

    public static InputStatus applyInputStatus(AppletNitrogen appletNitrogen) {
        InputStatus inputStatus = new InputStatus();
        appletNitrogen.getEventManager().register(NitrogenEventMouse.Pressed.class, event -> inputStatus.mousePressed(event.mouseEvent.getX(), event.mouseEvent.getY(), event.mouseEvent.getButton()));
        appletNitrogen.getEventManager().register(NitrogenEventMouse.Released.class, event -> inputStatus.mouseReleased(event.mouseEvent.getX(), event.mouseEvent.getY(), event.mouseEvent.getButton()));
        appletNitrogen.getEventManager().register(NitrogenEventMouseMotion.class, event -> inputStatus.mouseMotion(event.mouseEvent.getX(), event.mouseEvent.getY()));
        appletNitrogen.getEventManager().register(NitrogenEventMouseWheel.Moved.class, event -> inputStatus.mouseWheelMoved(event.mouseWheelEvent.getWheelRotation()));
        appletNitrogen.getEventManager().register(NitrogenEventKey.Pressed.class, event -> inputStatus.keyPressed(event.keyEvent.getKeyCode()));
        appletNitrogen.getEventManager().register(NitrogenEventKey.Released.class, event -> inputStatus.keyReleased(event.keyEvent.getKeyCode()));
        return inputStatus;
    }

    public static FPSAdjuster applyFPS(AppletNitrogen appletNitrogen, GameThread gameThread) {
        FPSAdjuster fpsAdjuster = new FPSAdjuster(gameThread);
        appletNitrogen.getEventManager().register(NitrogenEventGameThread.Sleep.class, event -> {
            event.cancelled = true;
            try {
                fpsAdjuster.waitForNextTick();
            }
            catch (Exception e) {
                event.interrupted = true;
            }
        });
        return fpsAdjuster;
    }

    public static class ResponceApplyStandard {
        public GameThread gameThread;
        public FPSAdjuster fpsAdjuster;
        public TripleBuffer tripleBuffer;
        public InputStatus inputStatus;
    }
}

