/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.nitrogen;

import mirrg.applet.nitrogen.GameThread;

public class FPSAdjuster {
    private long previousTimeMs = 0L;
    private double smoothedLoadFactor = 0.0;
    private double smoothedFps = 0.0;
    private GameThread gameThread;
    private static final double K = 0.1;

    public FPSAdjuster(GameThread gameThread) {
        this.gameThread = gameThread;
    }

    private final void sleepForNextTickFirst() {
        this.smoothedFps = this.getObjectiveFps();
        this.smoothedLoadFactor = 1.0;
        this.previousTimeMs = System.currentTimeMillis();
    }

    public void waitForNextTick() throws InterruptedException {
        if (this.previousTimeMs == 0L) {
            this.sleepForNextTickFirst();
            return;
        }
        long ms = System.currentTimeMillis();
        long previousLoopTimeMs = ms - this.previousTimeMs;
        long dms = (long)(1000.0 / this.getObjectiveFps());
        if (dms - previousLoopTimeMs - 2L >= 0L) {
            Thread.sleep(dms - previousLoopTimeMs - 2L);
        }
        while (System.currentTimeMillis() < this.previousTimeMs + dms) {
        }
        long ms2 = System.currentTimeMillis();
        double fps = ms2 - this.previousTimeMs == 0L ? 1000.0 : 1000.0 / (double)(ms2 - this.previousTimeMs);
        this.smoothedFps = 0.9 * this.smoothedFps + 0.1 * fps;
        double loadFactor = (double)previousLoopTimeMs / (double)dms;
        this.smoothedLoadFactor = 0.9 * this.smoothedLoadFactor + 0.1 * loadFactor;
        this.previousTimeMs = ms2;
    }

    public double getLoadFactor() {
        if (this.smoothedLoadFactor == 0.0) {
            return 1.0;
        }
        return this.smoothedLoadFactor;
    }

    public double getFPS() {
        if (this.smoothedFps == 0.0) {
            return this.getObjectiveFps();
        }
        return this.smoothedFps;
    }

    public double getObjectiveFps() {
        return this.gameThread.objectiveFps;
    }
}

