/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JScrollPane;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;

public class RTextScrollPane
extends JScrollPane {
    private RTextArea textArea;
    private Gutter gutter;

    public RTextScrollPane() {
        this(null, true);
    }

    public RTextScrollPane(RTextArea textArea) {
        this(textArea, true);
    }

    public RTextScrollPane(RTextArea textArea, boolean lineNumbers) {
        this(textArea, lineNumbers, Color.GRAY);
    }

    public RTextScrollPane(RTextArea area, boolean lineNumbers, Color lineNumberColor) {
        super(area);
        this.textArea = area;
        Font defaultFont = new Font("Monospaced", 0, 12);
        this.gutter = new Gutter(this.textArea);
        this.gutter.setLineNumberFont(defaultFont);
        this.gutter.setLineNumberColor(lineNumberColor);
        this.setLineNumbersEnabled(lineNumbers);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
    }

    private void checkGutterVisibility() {
        int count = this.gutter.getComponentCount();
        if (count == 0) {
            if (this.getRowHeader() != null && this.getRowHeader().getView() == this.gutter) {
                this.setRowHeaderView(null);
            }
        } else if (this.getRowHeader() == null || this.getRowHeader().getView() == null) {
            this.setRowHeaderView(this.gutter);
        }
    }

    public Gutter getGutter() {
        return this.gutter;
    }

    public boolean getLineNumbersEnabled() {
        return this.gutter.getLineNumbersEnabled();
    }

    public RTextArea getTextArea() {
        return (RTextArea)this.getViewport().getView();
    }

    public boolean isIconRowHeaderEnabled() {
        return this.gutter.isIconRowHeaderEnabled();
    }

    public void setIconRowHeaderEnabled(boolean enabled) {
        this.gutter.setIconRowHeaderEnabled(enabled);
        this.checkGutterVisibility();
    }

    public void setLineNumbersEnabled(boolean enabled) {
        this.gutter.setLineNumbersEnabled(enabled);
        this.checkGutterVisibility();
    }

    public void setViewportView(Component view) {
        if (!(view instanceof RTextArea)) {
            throw new IllegalArgumentException("view must be an RTextArea");
        }
        super.setViewportView(view);
        this.textArea = (RTextArea)view;
        if (this.gutter != null) {
            this.gutter.setTextArea(this.textArea);
        }
    }
}

