/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RtfGenerator {
    private List fontList = new ArrayList(1);
    private List colorList = new ArrayList(1);
    private StringBuffer document = new StringBuffer();
    private boolean lastWasControlWord;
    private int lastFontIndex;
    private int lastFGIndex;
    private boolean lastBold;
    private boolean lastItalic;
    private int lastFontSize;
    private String monospacedFontName;
    private int screenRes;
    private static final int DEFAULT_FONT_SIZE = 12;

    public RtfGenerator() {
        this.reset();
    }

    public void appendNewline() {
        this.document.append("\\par");
        this.document.append('\n');
        this.lastWasControlWord = false;
    }

    public void appendToDoc(String text, Font f, Color fg, Color bg) {
        this.appendToDoc(text, f, fg, bg, false);
    }

    public void appendToDocNoFG(String text, Font f, Color bg, boolean underline) {
        this.appendToDoc(text, f, null, bg, underline, false);
    }

    public void appendToDoc(String text, Font f, Color fg, Color bg, boolean underline) {
        this.appendToDoc(text, f, fg, bg, underline, true);
    }

    public void appendToDoc(String text, Font f, Color fg, Color bg, boolean underline, boolean setFG) {
        if (text != null) {
            int fontIndex;
            int n = fontIndex = f == null ? 0 : RtfGenerator.getFontIndex(this.fontList, f) + 1;
            if (fontIndex != this.lastFontIndex) {
                this.document.append("\\f").append(fontIndex);
                this.lastFontIndex = fontIndex;
                this.lastWasControlWord = true;
            }
            if (f != null) {
                int fontSize = this.fixFontSize(f.getSize2D());
                if (fontSize != this.lastFontSize) {
                    this.document.append("\\fs").append(fontSize);
                    this.lastFontSize = fontSize;
                    this.lastWasControlWord = true;
                }
                if (f.isBold() != this.lastBold) {
                    this.document.append(this.lastBold ? "\\b0" : "\\b");
                    this.lastBold = !this.lastBold;
                    this.lastWasControlWord = true;
                }
                if (f.isItalic() != this.lastItalic) {
                    this.document.append(this.lastItalic ? "\\i0" : "\\i");
                    this.lastItalic = !this.lastItalic;
                    this.lastWasControlWord = true;
                }
            } else {
                if (this.lastFontSize != 12) {
                    this.document.append("\\fs").append(12);
                    this.lastFontSize = 12;
                    this.lastWasControlWord = true;
                }
                if (this.lastBold) {
                    this.document.append("\\b0");
                    this.lastBold = false;
                    this.lastWasControlWord = true;
                }
                if (this.lastItalic) {
                    this.document.append("\\i0");
                    this.lastItalic = false;
                    this.lastWasControlWord = true;
                }
            }
            if (underline) {
                this.document.append("\\ul");
                this.lastWasControlWord = true;
            }
            if (setFG) {
                int fgIndex = 0;
                if (fg != null) {
                    fgIndex = RtfGenerator.getIndex(this.colorList, fg) + 1;
                }
                if (fgIndex != this.lastFGIndex) {
                    this.document.append("\\cf").append(fgIndex);
                    this.lastFGIndex = fgIndex;
                    this.lastWasControlWord = true;
                }
            }
            if (bg != null) {
                int pos = RtfGenerator.getIndex(this.colorList, bg);
                this.document.append("\\highlight").append(pos + 1);
                this.lastWasControlWord = true;
            }
            if (this.lastWasControlWord) {
                this.document.append(' ');
                this.lastWasControlWord = false;
            }
            this.escapeAndAdd(this.document, text);
            if (bg != null) {
                this.document.append("\\highlight0");
                this.lastWasControlWord = true;
            }
            if (underline) {
                this.document.append("\\ul0");
                this.lastWasControlWord = true;
            }
        }
    }

    private final void escapeAndAdd(StringBuffer sb, String text) {
        int count = text.length();
        block4: for (int i = 0; i < count; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\t': {
                    sb.append("\\tab");
                    while (++i < count && text.charAt(i) == '\t') {
                        sb.append("\\tab");
                    }
                    sb.append(' ');
                    --i;
                    continue block4;
                }
                case '\\': 
                case '{': 
                case '}': {
                    sb.append('\\').append(ch);
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
    }

    private int fixFontSize(float pointSize) {
        if (this.screenRes != 72) {
            pointSize = (int)Math.round((double)(pointSize * (float)this.screenRes) / 72.0);
        }
        return (int)pointSize;
    }

    private String getColorTableRtf() {
        StringBuffer sb = new StringBuffer();
        sb.append("{\\colortbl ;");
        for (int i = 0; i < this.colorList.size(); ++i) {
            Color c = (Color)this.colorList.get(i);
            sb.append("\\red").append(c.getRed());
            sb.append("\\green").append(c.getGreen());
            sb.append("\\blue").append(c.getBlue());
            sb.append(';');
        }
        sb.append("}");
        return sb.toString();
    }

    private static int getFontIndex(List list, Font font) {
        String fontName = font.getFamily();
        for (int i = 0; i < list.size(); ++i) {
            Font font2 = (Font)list.get(i);
            if (!font2.getFamily().equals(fontName)) continue;
            return i;
        }
        list.add(font);
        return list.size() - 1;
    }

    private String getFontTableRtf() {
        StringBuffer sb = new StringBuffer();
        String monoFamilyName = this.getMonospacedFontName();
        sb.append("{\\fonttbl{\\f0\\fnil\\fcharset0 " + monoFamilyName + ";}");
        for (int i = 0; i < this.fontList.size(); ++i) {
            Font f = (Font)this.fontList.get(i);
            String familyName = f.getFamily();
            if (familyName.equals("Monospaced")) {
                familyName = monoFamilyName;
            }
            sb.append("{\\f").append(i + 1).append("\\fnil\\fcharset0 ");
            sb.append(familyName).append(";}");
        }
        sb.append('}');
        return sb.toString();
    }

    private static int getIndex(List list, Object item) {
        int pos = list.indexOf(item);
        if (pos == -1) {
            list.add(item);
            pos = list.size() - 1;
        }
        return pos;
    }

    private String getMonospacedFontName() {
        if (this.monospacedFontName == null) {
            boolean windows;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Object[] familyNames = ge.getAvailableFontFamilyNames();
            Arrays.sort(familyNames);
            boolean bl = windows = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
            if (!windows && Arrays.binarySearch(familyNames, "Monaco") >= 0) {
                this.monospacedFontName = "Monaco";
            } else if (Arrays.binarySearch(familyNames, "Courier New") >= 0) {
                this.monospacedFontName = "Courier New";
            } else if (Arrays.binarySearch(familyNames, "Courier") >= 0) {
                this.monospacedFontName = "Courier";
            } else if (Arrays.binarySearch(familyNames, "Nimbus Mono L") >= 0) {
                this.monospacedFontName = "Nimbus Mono L";
            } else if (Arrays.binarySearch(familyNames, "Lucida Sans Typewriter") >= 0) {
                this.monospacedFontName = "Lucida Sans Typewriter";
            } else if (Arrays.binarySearch(familyNames, "Bitstream Vera Sans Mono") >= 0) {
                this.monospacedFontName = "Bitstream Vera Sans Mono";
            }
            if (this.monospacedFontName == null) {
                this.monospacedFontName = "Terminal";
            }
        }
        return this.monospacedFontName;
    }

    public String getRtf() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("\\rtf1\\ansi\\ansicpg1252");
        sb.append("\\deff0");
        sb.append("\\deflang1033");
        sb.append("\\viewkind4");
        sb.append("\\uc\\pard\\f0");
        sb.append("\\fs20");
        sb.append(this.getFontTableRtf()).append('\n');
        sb.append(this.getColorTableRtf()).append('\n');
        sb.append(this.document);
        sb.append("}");
        return sb.toString();
    }

    public void reset() {
        this.fontList.clear();
        this.colorList.clear();
        this.document.setLength(0);
        this.lastWasControlWord = false;
        this.lastFontIndex = 0;
        this.lastFGIndex = 0;
        this.lastBold = false;
        this.lastItalic = false;
        this.lastFontSize = 12;
        this.screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
    }
}

